<?php
 
// Add function to widgets_init that'll load our widget
add_action( 'widgets_init', 'radium_custom_images_widgets' );

// Register widget
function radium_custom_images_widgets() {
	register_widget( 'radium_custom_images_Widget' );
}

// Widget class
class radium_custom_images_widget extends WP_Widget {

	
	/*-----------------------------------------------------------------------------------*/
	/*	Widget Setup
	/*-----------------------------------------------------------------------------------*/
	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		
		$framework = radium_framework();
		
		parent::__construct(
	 		'radium_custom_images_widget', // Base ID
			'Custom Images ('. $framework->theme_title .')', // Name
			array( 'description' => __( 'A widget that allows the display of images & URLs.', 'radium' ), )
		);
	}
	
	
	/*-----------------------------------------------------------------------------------*/
	/*	Display Widget
	/*-----------------------------------------------------------------------------------*/
		
	function widget( $args, $instance ) {
		extract( $args );
  		
		// Our variables from the widget settings
		$title = apply_filters('widget_title', $instance['title'] );
		$size = $instance['size'];
		$desc = $instance['desc'];
		$image1 = $instance['image1'];
		$image2 = $instance['image2'];
		$image3 = $instance['image3'];
		$image4 = $instance['image4'];
		$image5 = $instance['image5'];
		$image6 = $instance['image6'];
		$link1 = $instance['link1'];
		$link2 = $instance['link2'];
		$link3 = $instance['link3'];
		$link4 = $instance['link4'];
		$link5 = $instance['link5'];
		$link6 = $instance['link6'];
 				
		// Before widget (defined by theme functions file)
		echo $before_widget;
	
		/* Display Widget */
		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title )
			echo $before_title . $title . $after_title;
		
		if($size === 'size1') {
			$size_class = '-104x104'; 
		} elseif ($size === 'size2') {
			$size_class = '-220x220'; 
		} elseif ($size === 'size3') {
		 	$size_class = '-220x104'; 		
		} elseif ($size === 'size4') {
		 	$size_class = '-104x220'; 		
		} 
		
		?>
		
		<div id="radium_custom_images_widget" >                        
		    
		    <?php if($desc) : ?>
		    	<p><?php echo $desc; ?></p>
		    <?php endif; ?>
		                   	
		    <ul class="image-size<?php echo $size_class; ?>">
							
				<?php if($image1 != '') : ?>
				    <li>
				        <a href="<?php echo $link1; ?>"><img src="<?php echo $image1; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
				<?php if($image2 != '') : ?>
				    <li>
				        <a href="<?php echo $link2; ?>"><img src="<?php echo $image2; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
				<?php if($image3 != '') : ?>
				    <li>
				        <a href="<?php echo $link3; ?>"><img src="<?php echo $image3; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
				<?php if($image4 != '') : ?>
				    <li>
				        <a href="<?php echo $link4; ?>"><img src="<?php echo $image4; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
				<?php if($image5 != '') : ?>
				    <li>
				        <a href="<?php echo $link5; ?>"><img src="<?php echo $image5; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
				<?php if($image6 != '') : ?>
				    <li>
				        <a href="<?php echo $link6; ?>"><img src="<?php echo $image6; ?>" alt=""/> </a>
				    </li>
				<?php endif; ?>
				
			</ul><!-- end image-size ul -->	
		</div>			
		
		<?php
			
		// After widget (defined by theme functions file)
		echo $after_widget;
		
	}
	
	
	/*-----------------------------------------------------------------------------------*/
	/*	Update Widget
	/*-----------------------------------------------------------------------------------*/
		
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
	
		// Strip tags to remove HTML (important for text inputs)
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['size'] = strip_tags( $new_instance['size'] );
		
		// No need to strip tags
		$instance['desc'] = $new_instance['desc'];
		$instance['image1'] = $new_instance['image1'];
		$instance['image2'] = $new_instance['image2'];
		$instance['image3'] = $new_instance['image3'];
		$instance['image4'] = $new_instance['image4'];
		$instance['image5'] = $new_instance['image5'];
		$instance['image6'] = $new_instance['image6'];
		$instance['link1'] = $new_instance['link1'];
		$instance['link2'] = $new_instance['link2'];
		$instance['link3'] = $new_instance['link3'];
		$instance['link4'] = $new_instance['link4'];
		$instance['link5'] = $new_instance['link5'];
		$instance['link6'] = $new_instance['link6'];		
		
		return $instance;
	}
	
	/*-----------------------------------------------------------------------------------*/
	/*	Widget Settings (Displays the widget settings controls on the widget panel)
	/*-----------------------------------------------------------------------------------*/
		
	function form( $instance ) {
		
		$framework = radium_framework();
		
		// Set up some default widget settings
		$defaults = array(
			'title'  => '',
			'desc'   => '',
			'size'   => '',
			'image1' => $framework->theme_images_url . '/image-104x104.jpg',	
			'image2' => $framework->theme_images_url . '/image-104x104.jpg',	
			'image3' => $framework->theme_images_url . '/image-104x104.jpg',	
			'image4' => $framework->theme_images_url . '/image-104x104.jpg',	
			'image5' => $framework->theme_images_url . '/image-104x104.jpg',	
			'image6' => $framework->theme_images_url . '/image-104x104.jpg',	
			'link1'  => '',
			'link2'  => '',	
			'link3'  => '',	
			'link4'  => '',	
			'link5'  => '',	
			'link6'  => '',	
 		);
		
		$instance = wp_parse_args( (array) $instance, $defaults ); 
		$size = $instance[ 'size' ];
		
		?>
		
		<p><!-- Widget Title: Text Input -->
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php _e('Description:', 'radium') ?></label>
		 	<textarea class="widefat" rows="6" cols="15" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>"><?php echo $instance['desc']; ?></textarea>
		</p>
	
		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>"><?php _e( 'Choose a size: ', 'radium' ); ?></label>
			<select id="<?php echo esc_attr( $this->get_field_id( 'size' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'size' ) ); ?>">
				<option value="size1" <?php selected( 'size1', $size ); ?>><?php _e( 'Default: 104 x 104px', 'radium' ); ?></option>
				<option value="size2" <?php selected( 'size2', $size ); ?>><?php _e( 'Large: 220 x 220px', 'radium' ); ?></option>
				<option value="size3" <?php selected( 'size3', $size ); ?>><?php _e( 'Tall: 220 x104px', 'radium' ); ?></option>
				<option value="size4" <?php selected( 'size4', $size ); ?>><?php _e( 'Wide: 104 x 220px', 'radium' ); ?></option>
			</select>
		</p>
	
		<br>
		<p><strong>Image/Link 1</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image1' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image1' ); ?>" name="<?php echo $this->get_field_name( 'image1' ); ?>" value="<?php echo $instance['image1']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link1' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link1' ); ?>" name="<?php echo $this->get_field_name( 'link1' ); ?>" value="<?php echo $instance['link1']; ?>" />
		</p>	
		
		<br>
		<p><strong>Image/Link 2:</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image2' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image2' ); ?>" name="<?php echo $this->get_field_name( 'image2' ); ?>" value="<?php echo $instance['image2']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link2' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link2' ); ?>" name="<?php echo $this->get_field_name( 'link2' ); ?>" value="<?php echo $instance['link2']; ?>" />
		</p>	
		
		<br>
		<p><strong>Image/Link 3:</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image3' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image3' ); ?>" name="<?php echo $this->get_field_name( 'image3' ); ?>" value="<?php echo $instance['image3']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link3' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link3' ); ?>" name="<?php echo $this->get_field_name( 'link3' ); ?>" value="<?php echo $instance['link3']; ?>" />
		</p>	
		
		<br>
		<p><strong>Image/Link 4:</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image4' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image4' ); ?>" name="<?php echo $this->get_field_name( 'image4' ); ?>" value="<?php echo $instance['image4']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link4' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link4' ); ?>" name="<?php echo $this->get_field_name( 'link4' ); ?>" value="<?php echo $instance['link4']; ?>" />
		</p>
		
		<br>
		<p><strong>Image/Link 5:</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image5' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image5' ); ?>" name="<?php echo $this->get_field_name( 'image5' ); ?>" value="<?php echo $instance['image5']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link5' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link5' ); ?>" name="<?php echo $this->get_field_name( 'link5' ); ?>" value="<?php echo $instance['link5']; ?>" />
		</p>		
		
		<br>
		<p><strong>Image/Link 6:</strong></p>
		
		<p><!-- Begin Social Media Input -->
			<label for="<?php echo $this->get_field_id( 'image6' ); ?>"><?php _e('Image Direct URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'image6' ); ?>" name="<?php echo $this->get_field_name( 'image6' ); ?>" value="<?php echo $instance['image6']; ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'link6' ); ?>"><?php _e('Link URL:', 'radium') ?></label>
			<input class="widefat" id="<?php echo $this->get_field_id( 'link6' ); ?>" name="<?php echo $this->get_field_name( 'link6' ); ?>" value="<?php echo $instance['link6']; ?>" />
		</p>
		<br>
			
		<?php
		}
	}
?>