<?php
/*-----------------------------------------------------------------------
	Shortcodes Begin Here
 ----------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------------*/
/*	Filters that allows shortcodes in Text Widgets
/*-----------------------------------------------------------------------------------*/
 
if ( !has_filter( 'widget_text', 'do_shortcode' ) ) {
	add_filter('widget_text', 'shortcode_unautop', 10);
	add_filter('widget_text', 'do_shortcode', 10);
}

/*-----------------------------------------------------------------------------------*/
/*	Column Shortcodes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_one_third')) {
	function radium_one_third( $atts, $content = null ) {
	   return '<div class="radium-one-third">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_one_third_last')) {
	function radium_one_third_last( $atts, $content = null ) {
	   return '<div class="radium-one-third radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_two_third')) {
	function radium_two_third( $atts, $content = null ) {
	   return '<div class="radium-two-third">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_two_third_last')) {
	function radium_two_third_last( $atts, $content = null ) {
	   return '<div class="radium-two-third radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_one_half')) {
	function radium_one_half( $atts, $content = null ) {
	   return '<div class="radium-one-half">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_one_half_last')) {
	function radium_one_half_last( $atts, $content = null ) {
	   return '<div class="radium-one-half radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_one_fourth')) {
	function radium_one_fourth( $atts, $content = null ) {
	   return '<div class="radium-one-fourth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_one_fourth_last')) {
	function radium_one_fourth_last( $atts, $content = null ) {
	   return '<div class="radium-one-fourth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_three_fourth')) {
	function radium_three_fourth( $atts, $content = null ) {
	   return '<div class="radium-three-fourth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_three_fourth_last')) {
	function radium_three_fourth_last( $atts, $content = null ) {
	   return '<div class="radium-three-fourth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('one_fifth')) {
	function radium_one_fifth( $atts, $content = null ) {
	   return '<div class="radium-one-fifth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_one_fifth_last')) {
	function radium_one_fifth_last( $atts, $content = null ) {
	   return '<div class="radium-one-fifth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_two_fifth')) {
	function radium_two_fifth( $atts, $content = null ) {
	   return '<div class="radium-two-fifth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_two_fifth_last')) {
	function radium_two_fifth_last( $atts, $content = null ) {
	   return '<div class="radium-two-fifth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_three_fifth')) {
	function radium_three_fifth( $atts, $content = null ) {
	   return '<div class="radium-three-fifth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_three_fifth_last')) {
	function radium_three_fifth_last( $atts, $content = null ) {
	   return '<div class="radium-three-fifth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_four_fifth')) {
	function radium_four_fifth( $atts, $content = null ) {
	   return '<div class="radium-four-fifth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_four_fifth_last')) {
	function radium_four_fifth_last( $atts, $content = null ) {
	   return '<div class="radium-four-fifth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_one_sixth')) {
	function radium_one_sixth( $atts, $content = null ) {
	   return '<div class="radium-one-sixth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('radium_one_sixth_last')) {
	function radium_one_sixth_last( $atts, $content = null ) {
	   return '<div class="radium-one-sixth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

if (!function_exists('radium_five_sixth')) {
	function radium_five_sixth( $atts, $content = null ) {
	   return '<div class="radium-five-sixth">' . do_shortcode($content) . '</div>';
	}
}

if (!function_exists('five_sixth_last')) {
	function radium_five_sixth_last( $atts, $content = null ) {
	   return '<div class="radium-five-sixth radium-column-last">' . do_shortcode($content) . '</div><div class="clearfix"></div>';
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Header Shortcodes
/*-----------------------------------------------------------------------------------*/
if(!function_exists('radium_header_sc')) {

	function radium_header_sc($atts, $content = null) {	
		
		extract(shortcode_atts(array(
			'title'    	 => '',
			'sub_title'  => '',
		), $atts));
		
		$output = '<div class="custom-headline">';
		$output .= '<h1 class="title">'.$title.'</h1>';
		$output .= '<h3 class="sub-title">'.$sub_title.'</h3>';
		$output .= '</div>';
		
		return $output;
	}

}

#-----------------------------------------------------------------
// SEPARATORS 
#-----------------------------------------------------------------
if(!function_exists('radium_hr_sc')) {

	function radium_hr_sc($atts, $content = "", $shortcodename = "") {	
		extract(shortcode_atts(array(
			'link'    	 => '',
			'text'    	 => '',
		), $atts));
		
		$top = $toplink = false;
		
		if (isset($atts[0]) && trim($atts[0]) == 'top')  $top = 'top';
		if($top == 'top') $toplink = '<a href="#top" class="skip">top</a>';
		
		if($shortcodename != "hr_invisible") {
			$output = '<div class="'.$shortcodename.'"></div>';
			
			 if ($toplink) {
			
				$output  = '<div class="hr totop">'.$toplink.'</div>';	
			 
			 } elseif ($link) {
			 
			 	$output  = '<div class="hr headline solid"><a class="skip" href="'.$link.'">'.$text.'</a></div>';
			 
			 } else {

				$output  = '<div class="hr"></div>';	
			 	
			 }
		
		} else {
		
			$output  = '<div class="hr_invisible"></div>';	
			
		}
		
		return $output;
	}
	
}

if(!function_exists('radium_clear')) {

	function radium_clear( $atts ) {
	   return '<div class="clearfix"></div>';
	}
	
}


/*-----------------------------------------------------------------------------------*/
/*	Toggle Shortcodes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_toggle')) {

	function radium_toggle( $atts, $content = null ) {
	    extract(shortcode_atts(array(
			'title'    	 => 'Title goes here',
			'state'		 => 'closed'
	    ), $atts));
	
		return "<div data-id='".$state."' class=\"radium-toggle\"><span class=\"radium-toggle-title\">". $title ."</span><div class=\"radium-toggle-inner\"><div class=\"target\">". do_shortcode($content) ."</div></div></div>";
	}
	
}


/*-----------------------------------------------------------------------------------*/
/*	Tabs Shortcodes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_tabs')) {

	function radium_tabs( $atts, $content = null ) {
		$defaults = array( 
			'type'		 => 'horizontal', //vertical or horizontal
		);
		extract( shortcode_atts( $defaults, $atts ) );
		
		// Extract the tab titles for use in the tab widget.
		preg_match_all( '/tab title="([^\"]+)"/i', $content, $matches, PREG_OFFSET_CAPTURE );
		
		$tab_titles = array();
		if( isset($matches[1]) ){ $tab_titles = $matches[1]; }
		
		$output = '';
		
		if( count($tab_titles) ){
		    $output .= '<div id="radium-tabs-'. rand(1, 100) .'" class="radium-tabs radium-tabs-'.$type.' clearfix"><div class="radium-tab-inner">';
			$output .= '<ul class="radium-nav clearfix">';
			
			foreach( $tab_titles as $tab ){
				$output .= '<li><a href="#radium-tab-'. sanitize_title( $tab[0] ) .'">' . $tab[0] . '</a><span class="sidebar_tab_shadow" style="height: 280px;"></span></li>';
			}
		    
		    $output .= '</ul>';
		    $output .= do_shortcode( $content );
		    $output .= '</div></div>';
		} else {
			$output .= do_shortcode( $content );
		}
		
		return $output;
	}
	
}

if (!function_exists('radium_tab')) {
	
	function radium_tab( $atts, $content = null ) {
	
		$defaults = array( 'title' => 'Tab' );
		extract( shortcode_atts( $defaults, $atts ) );
		
		return '<div id="radium-tab-'. sanitize_title( $title ) .'" class="radium-tab">'. do_shortcode( $content ) .'</div>';
	}
	
}


/*-----------------------------------------------------------------------------------*/
/*	Alerts/Message boxes
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_alert')) {

	function radium_alert( $atts, $content = null ) {
 	   
	   extract(shortcode_atts(array(
	   		'style' => '',
	       ), $atts));
	   
	   	$class = 'messageBox';
	   	$icon = null;
	   	
	   	if ($style == 'inset') {
	   		$class = 'insetBox'; // overwrite the messageBox class for inset boxes.
	   	} elseif ($style) {
	   		$class .= ' '. $style; // add the type class
	   	}
	   	if ($icon) $class .= ' icon';
	   
	   	$box = '<div class="'.$class.'"><span class="closeBox icon"><a href="#"><span class="icon-close"></span></a></span>';
	   	$box .= '<span>'.do_shortcode($content).'</span>';
	   	$box .= '</div>';
	   		
	      return $box;
	}
	
}


//*-----------------------------------------------------------------------------------*/
/* DropCaps - Emphasize the first character of a paragraph 
/*-----------------------------------------------------------------------------------*/

if(!function_exists('radium_dropcaps_sc')) {

	function radium_dropcaps_sc($atts, $content = "", $shortcodename = "")	{	
	
		//this is a fix that solves the false paragraph removal by wordpress if the dropcaps shortcode is used at the beginning of the content of single posts/pages
		
		global $post, $radium_add_p;
		
		$add_p = "";
		if(isset($post->post_content) && strpos($post->post_content, '[dropcap') === 0 && $radium_add_p == false && is_singular()) {
			$add_p = "<p>";
			$radium_add_p = true;
		}
		
		//this is the actual shortcode
		$output  = $add_p.'<span class="'.$shortcodename.' dropcap">';
		$output .= $content;
		$output .= '</span>';	
		
	
		return $output;
	}
	
}


/*-----------------------------------------------------------------------------------*/
/* Highlight - [highlight][/highlight]
/*-----------------------------------------------------------------------------------*/

if(!function_exists('radium_highlight_sc')) {

	function radium_highlight_sc ( $atts, $content = null ) {
	
		$defaults = array();
	
		extract( shortcode_atts( $defaults, $atts ) );
	
		return '<span class="highlight">' . $content . '</span>';
	
	} 
	
}


//*-----------------------------------------------------------------------------------*/
/* Chat Post Format Shortcode */
/*-----------------------------------------------------------------------------------*/
if(!function_exists('radium_chat_post_sc')) {

	function radium_chat_post_sc($atts, $content=null) {
	
		$chatoutput = "<dl class=\"chat-transcript\">\n";
		$split = preg_split("/(\r?\n)+|(<br\s*\/?>\s*)+/", $content);
		
			foreach($split as $haystack) {
				if (strpos($haystack, ":")) {
					$string = explode(":", trim($haystack), 2);
					$who = strip_tags(trim($string[0]));
					$what = strip_tags(trim($string[1]));
					$row_class = empty($row_class)? " class=\"chat-highlight\"" : "";
					$chatoutput = $chatoutput . "<dt$row_class><strong>$who:</strong></dt> <dd>$what</dd>\n";
				}
				else {
					$chatoutput = $chatoutput . $haystack . "\n";
				}
			}
			
		// print the formated chat post
		$content = $chatoutput . "</dl>\n";
		
		return $content;
	}

}

#-----------------------------------------------------------------
// LISTS 
#-----------------------------------------------------------------

if (!function_exists('radium_lists_sc')) {

	function radium_lists_sc($atts, $content = null) {
		extract( shortcode_atts( array(
			'icon' => 'icon-forward',
			'style' => ''
		), $atts ) );
		
	     $content = do_shortcode($content);
	     
	     $content = str_replace('<li>', '<li><span class="'.$icon.'"></span>', $content);
	     
		return '<div class="list '.$style.'">'.$content.'</div>';
	}
	
}


#-----------------------------------------------------------------
# Social Icons
#-----------------------------------------------------------------

// Single Icon
//...............................................
if (!function_exists('radium_social_icon_sc')) {

	function radium_social_icon_sc( $atts, $content = null ) {
	
		extract(shortcode_atts(array(
			'size' => '',			// small, medium, large (16px, 24px, 32px)
			'type' => '', 			// the type of icon image to use
			'style' => 'style3',	// style1, style2, style3
			'link' => '#',			// if a link is provided
			'title' => '',			// the link title attribute
			'link' => false,		// if a link is provided
			'title' => false,		// the link title attribute
			'target' => '_blank',	// the link target
			'tooltip' => false,		// show tooltip title attribute
			'container' => 'div',	// the container type (span, div, li, etc...)
			'return' => ''			// if you don't want the element, rather the class to be returned
	    ), $atts));
		
		$icon = null;
	 	$class = null;
 			
		if ($type) {
		
			$type = strtolower($type);
			
			// Icon size
			switch ($size) {
				case 'small':
					$class .= 'icon16';
					break;
				case 'medium':
					$class .= 'icon24';
					break;
				default:
					$class .= 'icon32';
			}
			
			// array of icon classes
			$iconSocial = array('digg', 'twitter', 'dribbble',  'youtube',  'facebook', 'forrst', 'zerply', 'flickr', 'envato', 'rss');
	
			// set class for icon image source
			$class .= ' iconSocial';
		
			if ($title == '0')	$title = $icon;
			
			// icon image
			$class .= ' '. $type;
			
			// if return is set to class (otherwise continue with image)
			if ($return == 'class') return $class;
			
			// icon
			$image = '<'.$container.' class="'.$class.'"></'.$container.'>';	
				
			// link
			if ($link) {
				
				$link = trim($link);
				
				// target setup
				if		($target == 'blank' || $target == '_blank' || $target == 'new' )	{ $target = ' target="_blank"'; }
				elseif	($target == 'parent')	{ $target = ' target="_parent"'; }
				elseif	($target == 'self')		{ $target = ' target="_self"'; }
				elseif	($target == 'top')		{ $target = ' target="_top"'; }
				else	{ $target = ''; }
				
				$tooltip_content = null;
				if($tooltip){ $tooltip_content = 'has-tip tip-top'; }
				
				$image = '<a href="'.$link.'" title="'.$type.'" '.$target.' class="'. $style  .' social-icons '. $tooltip_content .'">' . $image . '</a>';
			}
			
			return $image;
		
		}
		
	}
	
}

/*-----------------------------------------------------------------------------------*/
/*	Icons
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_icon_sc')) {

	function radium_icon_sc( $atts, $content = null ) {
	
		extract(shortcode_atts(array(
			'title_tag' => 'h4',		
			'size' => '',			// small, medium, large (16px, 24px, 32px)
			'type' => '', 			// the type of icon image to use
			'style' => 'style3',	// style1, style2, style3
			'icon' => '',	// style1, style2, style3
			'link' => '#',			// if a link is provided
			'title' => '',			// the link title attribute
			'link' => false,		// if a link is provided
			'title' => false,		// the link title attribute
			'target' => '_blank',	// the link target
			'container' => 'div',	// the container type (span, div, li, etc...)
			'return' => ''			// if you don't want the element, rather the class to be returned
	    ), $atts));
		
	 	$class = null;

				// icon image
			$class .= ' '. $type;
			
			// if return is set to class (otherwise continue with image)
			if ($return == 'class') return $class;
			
			// icon
			$output = null;
			
			//$output = '<'.$container.' class="'.$class.'"></'.$container.'>';	
			
 			// link
			if ($link) {
				
				$link = trim($link);
				
				// target setup
				if		($target == 'blank' || $target == '_blank' || $target == 'new' )	{ $target = ' target="_blank"'; }
				elseif	($target == 'parent')	{ $target = ' target="_parent"'; }
				elseif	($target == 'self')		{ $target = ' target="_self"'; }
				elseif	($target == 'top')		{ $target = ' target="_top"'; }
				else	{ $target = ''; }
				
			}
			
			$output .= '<'.$title_tag.' class="'.$type.' feature-area-wrapper clearfix">';
				
			$output .= '<span class="'.$icon.' '. $style .'"></span><span class="feature_icon_title">' .$title .'' . do_shortcode( $content ) .'</span>';
				
			$output .= '</'.$title_tag.'>';
			
			return $output;
		
	}
	
}

#-----------------------------------------------------------------
// IconBox boxes
#-----------------------------------------------------------------
if (!function_exists('radium_icon_box_sc')) {

	function radium_icon_box_sc($atts, $content=null ) {	
		extract(shortcode_atts(array(
			'title' => '', 
			'icon' => ''
			), $atts));
		
		if($icon != "") $icon = "<span class='icon $icon'></span>";
		
		// add blockquotes to the content
		$output  = '<div class="iconbox">';
		$output .= '<span class="iconbox_icon">'.$icon.'</span>';
		$output .= '<div class="iconbox_content">';
		$output .= '<h5 class="iconbox_content_title">'.$title."</h5>";
		$output .= wpautop($content);
		$output .= '</div></div>';
		
		return $output;
	}

}

/*-----------------------------------------------------------------------------------*/
/*	Buttons
/*-----------------------------------------------------------------------------------*/

if (!function_exists('radium_button_sc')) {

	function radium_button_sc( $atts, $content = null ) {
	    extract(shortcode_atts(array(
			'id'		=> false,
			'title'		=> false,			
			'url'		=> '#',
 			'target'	=> '',
			'style'		=> '',
			'type'      => '',
			'size'      => '',
			'onclick'	=> false,
			'icon'	    => '',
	    ), $atts));
		
		// variable setup
		$title = ($title) ? ' title="'.$title .'"' : '';
 		$id = ($id) ? ' id="'.$id .'"' : '';
		
 		if ($style) $style = $style;
 		if ($type) $type = $type;
 		if ($size) $size = $size;
 		
		$onclick = ($onclick) ? ' onclick="'.$onclick .'"' : '';
		
		$icon = ($icon) ? '<span class="'.$icon.'"></span>': null;
		
		// target setup
		if		($target == 'blank' || $target == '_blank' || $target == 'new' ) { $target = ' target="_blank"'; }
		elseif	($target == 'parent')	{ $target = ' target="_parent"'; }
		elseif	($target == 'self')		{ $target = ' target="_self"'; }
		elseif	($target == 'top')		{ $target = ' target="_top"'; }
		else	{$target = '';}
		
		$button = '<a' .$target. ' ' .$onclick. '  ' .$title. '  ' .$id. ' class="button ' .$style. ' '.$type.' '.$size.'" href="' .$url. '">'.$icon.'<span>' .do_shortcode($content). '</span></a>';
	    
	    return $button;
	}
	
}


#-----------------------------------------------------------------
// Call to Action
#-----------------------------------------------------------------
if (!function_exists('radium_call_to_action_sc')) {

	function radium_call_to_action_sc( $atts, $content = null ) {
	
		extract(shortcode_atts(array(
			'tag_line' => '',
			'link' => '#',
			'style' => '',
			'target' => '',
			'btn_style' => '',
			'size' => 'large',
			'type' => '',
 			'button_text' => '',
 			'icon' => ''
	    ), $atts));
		
		if ($icon) 
			$icon = '<i class="'.$icon.'"></i>';
			
		// target setup
		if		($target == 'blank' || $target == '_blank' || $target == 'new' ) { $target = ' target="_blank"'; }
		elseif	($target == 'parent')	{ $target = ' target="_parent"'; }
		elseif	($target == 'self')		{ $target = ' target="_self"'; }
		elseif	($target == 'top')		{ $target = ' target="_top"'; }
		else	{$target = '';}
					
		if (!empty($tag_line)) {
			
			$call_to_action = '<div class="cta-wrapper '.$style.'">
				<div class="tab left"><div class="nub"></div></div>
				<div class="cta-content">';
					if ($tag_line) $call_to_action .= '<p class="cta-tag-line">'. $tag_line .'</p>
				</div>';
				
				if (!empty($button_text)) 
					$call_to_action .= '<div class="cta-action"><a' .$target. ' class="button ' .$btn_style. ' '.$type.' '.$size.'" href="' .$link. '"><span>'.$icon.''.$button_text.'</span></a></div>';
			
			$call_to_action .= '</div>';
		}
		
		// closing containers
		return $call_to_action;
		
	}
	
}
 

/* -------------------------------------------------- */
/*	Projects/Posts Carousel
/* -------------------------------------------------- */
if (!function_exists('radium_carousel_sc')) {
	
	function radium_carousel_sc( $atts, $content = null ) {
	
		extract( shortcode_atts( array(
			'title'			=> __('Latest projects', 'radium'),
			'limit' 		=> 16,
			'type' 			=> 'portfolio',
			'caption' 		=> '',
			'url' 			=> '#',
			'categories' 	=> ''
		), $atts ));
	
		global $post;
				
		$output = null;
		
		$args = array('post_type'      => esc_attr( $type ),
					  'posts_per_page' => esc_attr( $limit ),
					  'order'          => 'ASC',
					  'post_status'    => 'publish'
				  );
			
		if( $categories ) {
		
			if ( $type == 'portfolio') {
				
				$args = array_merge( $args, array( 'portfolio_category' => esc_attr( $categories ) ) );
				
			} elseif ( $type === 'gallery' ) {
				
				$args = array_merge( $args, array( 'gallery_cat' => esc_attr( $categories ) ) );
				
			} else {
				
				$args = array_merge( $args, array( 'category_name' => esc_attr( $categories ) ) );
				
			}
		
		}	
				  
		query_posts( $args );
			
		if( have_posts() ) {
			
			$output = '<div class="radium-carousel-wrapper '.$type.'">';
			
			$output .= '<h3 class="section-title">' . esc_attr( $title ) . '</h3>';
						
			if ($caption) 
				$output .= '<div class="hr headline solid"><a href="' . esc_attr( $url ) . '" class="skip">' . esc_attr( $caption ) . '</a></div>';
						
			$output .= '<ul class="radium-carousel recent-'.$type.'">';
			
				while( have_posts() ) { the_post();
								
					$post_id = get_the_ID();
					$permalink = get_permalink( $post->ID );	
					$title = get_the_title( $post->ID );
					$excerpt = strip_tags(wp_trim_words( get_the_excerpt(), '16' ));
					$post_class = null;
					$mediaType = null;
					
					//Generate portfolio terms list
					$category_name = null;
					
					$terms = get_the_terms( $post->ID, 'portfolio_category' );
					
					if( is_array($terms) ) {
						foreach ( $terms as $term ) {
							$category_name .= $term->name.', ';
	   					}
					} 
		
		 			if ( $type == 'portfolio' ) {
					
						$mediaType = get_post_meta($post->ID, '_radium_portfolio_type', true);
						$post_class = strtolower($mediaType); 
						
						$thumb_w = 220;
						$thumb_h = 150;
			    	   								
					} else {
												
						$mediaType = get_post_format();
						$post_class = strtolower($mediaType);
						
						$thumb_w = 220;
						$thumb_h = 136;
					}
					
					if ( get_the_post_thumbnail($post_id) != '' ) {
					
					  $thumb = get_post_thumbnail_id();
					  $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
					  $image = radium_resize( $img_url, $thumb_w, $thumb_h, true ); //resize & crop the image
					
					} else {
					
					 	$image = get_radium_first_post_image(true);
					 	
					}
															
					if($excerpt){
						$myExcerpt = '<div class="excerpt"><p>' . $excerpt . '</p></div>';
					}
					
					$output .= '<li>';
							
						$output .= '<article id="post-' . $post_id. '" class="' . esc_attr( $type ) . ' '.$mediaType.'">';
						
						$output .= '<div class="carousel-media"  data-width="'.$thumb_w.'" data-height="'.$thumb_h.'">';
						
							switch ( $mediaType ) {
								
								case "slideshow":
									$output .= '<a href="' . $permalink . '" title="' . $title . '" class="carousel-slider">';
								    $output .= get_radium_gallery( $post->ID, $thumb_w, $thumb_h, true, null );
								    $output .= '<span class="post-thumb-overlay">'.__('View Post', 'radium').'</span>';
								    $output .= '<div class="stripes"></div>';
								    $output .= '</a>';
	 							    break; 
								 
								case "video":
								
				                    $embed = get_post_meta($post->ID, '_radium_portfolio_embed_code', true);
				                    if( !empty($embed) ) {
				                    
				                    	$output .= "<div class='video-frame'>";
				                    	$output .= '<a href="' . $permalink . '" title="' . $title . '">';
				                        	$output .= stripslashes(htmlspecialchars_decode($embed));
				                        	$output .= '<span class="post-thumb-overlay">'.__('View Post', 'radium').'</span>';
				                        	$output .= '<div class="stripes"></div>';
				                        $output .= '</a>';
				                        $output .= "</div>";
				                        
				                    } else {
				                    
										$output .= '<div class="post-thumb preload">';
										$output .= '<a href="' . $permalink . '" title="' . $title . '">';
										$output .= '<img src="' . $image . '" alt="' . $title . '"/>';
										$output .= '<span class="post-thumb-overlay">'.__('View Post', 'radium').'</span>';
										$output .= '<div class="stripes"></div>';
										$output .= '</a>';
										$output .= '</div>'; 
				                    } 
				                    break;
				
				               case "audio":
						               $output .= get_radium_audio($post->ID);
				                    break; 
				
				                default: 
				                		$output .= '<div class="post-thumb preload">';
				                		$output .= '<a href="' . $permalink . '" title="' . $title . '">';
				                		$output .= '<img src="' . $image . '" alt="' . $title . '"/>';
				                		$output .= '<span class="post-thumb-overlay">'.__('View Post', 'radium').'</span>';
				                		$output .= '<div class="stripes"></div>';
				                		$output .= '</a>';
				                		$output .= '</div>'; 
				                	
				                	break;
							}
						
						$output .= '</div>';
							
			   			if ($type === 'post') {
			   			
				   			$output .='<div class="entry-summary">
				   							<a title="' . $title . '" href="' . $permalink  . '"><span class="post-format ' . $post_class . '">Permalink</span></a>
				   							<h4><a title="' . $title . '" href="' . $permalink  . '">' . $title . '</a></h4>';
				   			$output .= $myExcerpt;
				   			$output .= '</div><!-- .entry-summary -->';
				   			
				   		} else {
				   			$output .= '<h4>';
				   			$output .= '<a href="' . $permalink . '" title="' . $title . '" data-width="'.$thumb_w.'" data-height="'.$thumb_h.'">' . $title . '</a>';
				   			$output .= '</h4>';
				   		}
						   			
						$output .= '</article>';
					
					$output .= '</li>';
				
				}
				
				$output .= '</ul>';
				$output .= '</div><!-- end .radium-carousel -->';
	
			}
	
			wp_reset_query();
	
	
		return $output;
	
	}

}

/* -------------------------------------------------- */
/*	Google Map [map height="250px" address="London" /]
/* -------------------------------------------------- */
if (!function_exists('radium_google_map_shortcode')) {
	
	function radium_google_map_shortcode( $atts ) {
		
		extract( shortcode_atts( array(
			'maptype' 	=> 'roadmap',  	// hybrid, satellite, roadmap, terrain
			'zoom'		=> 14,			// 1-19
			'address'	=> '',			// Ex: 6921 Brayton Drive, Anchorage, Alaska
			'html'		=> '',			// Will default to Address if left empty
			'popup'		=> 'true',		// true/false
			'width'		=> '',			// Leave blank for 100%, need to use 'px' or '%'
			'height'	=> '500px'		// Need to use 'px' or '%'
		), $atts ) );
		
		$framework = radium_framework();
		
		// Map type
		$maptype = strtoupper( $maptype );
		
		// HTML
		if( ! $html )
			$html = $address;
			
		// Width/Height
		$styles = 'height:'.$height;
		if( $width )
			$styles .= ';width:'.$width;
		
		// Unique ID
		$id = rand();
		
		// Start output
		ob_start();
		?>
		<!-- Include google map api-->	
		<script type="text/javascript" src="http://maps.google.com/maps/api/js?sensor=true"></script>
		
	 	<script type="text/javascript">
		jQuery(document).ready(function($) {
			$("#radium_gmap_<?php echo $id; ?>").gMap({
				maptype: "<?php echo $maptype; ?>",
				zoom: <?php echo $zoom; ?>,
				markers: [
					{
						address: "<?php echo $address; ?>",
						popup: <?php echo $popup; ?>,
						html: "<?php echo $html; ?>",
						icon: {
							image: "<?php echo $framework->theme_images_url .'/map_pointer_home.png'; ?>",
							iconsize: [60, 60],
							iconanchor: [12,46]
						}
						
					}
				],
				controls: {
					panControl: true,
					zoomControl: true,
					mapTypeControl: true,
					scaleControl: true,
					streetViewControl: false,
					overviewMapControl: false
				}
			});
		});
		</script>
		<div id="radium_gmap_<?php echo $id; ?>" class="radium-gmap" style="<?php echo $styles; ?>"></div>
		<?php
		return ob_get_clean();
	}

}

/* -------------------------------------------------- */
/*	Google Document Viewer
/* -------------------------------------------------- */
if (!function_exists('radium_email_form_sc')) {

	function radium_email_form_sc( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'sign_up_text'			=> 'Go',
			'action' =>'',
			'subscribecode' => '',
			'placeholder' => ''
		), $atts ) );
	
		$output = '
		<form action=" ' . $subscribecode . '" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" class="validate" target="_blank">
			<input type="email" name="EMAIL" class="email-newsletter" id="mce-EMAIL" value=" ' . $placeholder . ' " required="">
 			<button class="newsletter-button button" type="submit"><span>' . $sign_up_text . '</span></button>
		</form>
		'; 
	
		return $output;
	}

}

/* -------------------------------------------------- */
/*	Popup Viewer
/* -------------------------------------------------- */
if (!function_exists('radium_popup_sc')) {

	function radium_popup_sc( $atts, $content = null ) {
		extract( shortcode_atts( array(
			'heading' 	=> '',
			'popup_link' 	=> null,
			'type' 			=> null,
			'class' 		=> null,
			'height' 		=> 500,
			'width' 		=> 400,
			'href' 			=> null,
			'state'			=> 'closed',
		), $atts ) );
		
		$id = rand(1, 10000);
		
		if ($content) $output ='
	
		<!-- modal content -->
		<div id="radium-modal-'. $id  .'" class="modal hide fade '.$class.'">
			<div class="modal-header">
				<a href="#" class="close" data-dismiss="modal">&#120;</a>
				<h3>'. $heading .'</h3>
			</div>
			<div class="modal-body">'. do_shortcode($content) .'</div>
		</div>
		
		<a data-toggle="modal" href="#radium-modal-'.$id .'" class="modal-popup-link '.$class.'">'.$popup_link.'</a>';
	
		return $output;
	}

}


/* -------------------------------------------------- */
/*	Testimonials
/* -------------------------------------------------- */
if (!function_exists('radium_testimonials_sc')) {

	function radium_testimonials_sc($atts, $content = null) {
		extract(shortcode_atts(array(
	    	"by" => '',
			"from" => ''
		), $atts));
		return '<div class="radium_testimonials_sc"><span class="arrow"></span><p>'.$content.'</p></div><div class="radium_testimonial_author"><h6>'.$by.', '. $from.'</h6></div>';
	}
}


/* -------------------------------------------------- */
/*	Accordion Content
/* -------------------------------------------------- */

function radium_accordion_content_sc( $atts, $content = null ) {

	extract( shortcode_atts( array(
		'title'      => '',
	), $atts ) );

	return '<div class="accordion-trigger"><h4><a href="#"><span class="trigger-icon"></span>' . esc_attr( $title ) . '</a></h4></div><div class="accordion-container"><div class="content">' . do_shortcode( $content ) . '</div></div>';

}
add_shortcode('accordion', 'radium_accordion_content_sc');
	
/* -------------------------------------------------- */
/* Skill Progess Bar
/* -------------------------------------------------- */
function shortcode_progress($atts, $content = null) {
	extract(shortcode_atts(array(
		'percentage'	=> '',
	), $atts));
				
	$html = '';
	$html .= '<div class="progress-bar">';
	$html .= '<div class="progress-bar-content" data-percentage="'.$percentage.'" style="width: ' . $percentage . '%">';
	$html .= '</div>';
	$html .= '<span class="progress-title">' . $content . ' ' . $percentage . '%</span>';
	$html .= '</div>';

	return $html;
}
add_shortcode('progress', 'shortcode_progress');


/* -------------------------------------------------- */
/*	Teaser Content
/* -------------------------------------------------- */

function radium_teaser_sc($atts, $button_title = null) {
	$target_html = '';
	extract(shortcode_atts(array(
		'url'	=> home_url(),
		'title'	=> get_bloginfo('name'),
		'src'	=> '',
		'post'	=> '',
		'target'=> '',
		'style' => ''
	), $atts));
	
	$target_html = isset($target) ? ' target="_blank"' : null;
		
	$class_html = isset($style) ?' class=" '.$style.'"' : null;
		
	$html = '<a href="'.esc_url($url).'" class="teaser_box"'.$target_html.'>';

	if($src && strlen($src)) {
	
		$html .= '<img src="'.esc_url($src).'" alt="'.esc_html($title).'" '.$class_html.'>';
		
	} elseif($post) {
	
		ob_start();
		get_theme_post_thumbnail($post, 'thumbnail');
		$img = ob_get_clean();
		
		$html .= $img;
		
	}
	
	if($title)
		$html .= '<span class="teaser_title"><span class="teaser_title_inner">'.$title.'</span>';
	
	if($button_title)
		$html .= '<span class="teaser_more">'.$button_title.'</span>';
	
	$html .= '</span></a>';

	return $html;
}

/**
*
* Audio Shortcode
* @Supports mp3, m4a, ogg, webma, wav
* @usage [audio href="#" hide_title="false"] 
* @param href= link to file
* @param hide_title bool
*/
function radium_audio_sc($atts, $title = null) {
	
	extract(shortcode_atts(array(
				'href' => '',
				'hide_title' => '',
	), $atts));
	
		$html = get_radium_audio( null, $href ); 
		
		return $html;	
	
}
/**
 * Outputs Video file data in a shortcode called '[radium_audio]'.
 *
 * @since 1.0.0
 *
 * @Supports mp3, m4a, ogg, webma, wav
 * @usage [audio href="#" hide_title="false"] 
 * @param href= link to file
 * @param hide_title bool
 * @return string $output Concatenated string
 */

function radium_video_sc($atts, $title = null) {
	
	extract( shortcode_atts( array( 
		'href' => '', 
		'poster' => '', 
		'height' => 400, 
	), $atts ) );
			
	$html = get_radium_video( null,  $href , $poster, $height ); 

	return $html;	
	
}

/* ----------------------------------------------------- */
/* Accordion Shortcode 
/* ----------------------------------------------------- */
function radium_accordion_sc($atts, $content, $code) {
	extract(shortcode_atts(array(
		'style' => false
	), $atts));
	if (!preg_match_all("/(.?)\[(tab)\b(.*?)(?:(\/))?\](?:(.+?)\[\/tab\])?(.?)/s", $content, $matches)) {
		return do_shortcode($content);
	} else {
		$output = '';
		for($i = 0; $i < count($matches[0]); $i++) {
			$matches[3][$i] = shortcode_parse_atts($matches[3][$i]);
			if($i == 0){$first = 'class="firsttitle"';}else{$first = '';}
			$output .= '<div class="title"><a href="#acc-' . $i . '" '.$first.'><span class="ui-accordion-header-icon"></span>' . $matches[3][$i]['title'] . '</a></div><div class="inner" id="acc-' . $i . '">' . do_shortcode(trim($matches[5][$i])) .'</div>';
		}
		return '<div class="accordion">' . $output . '</div>';
		
	}
}


/* ----------------------------------------------------- */
/* Person
/* ----------------------------------------------------- */
add_shortcode('person', 'shortcode_person');
function shortcode_person($atts, $content = null) {
	
	$social_links = array(
		'behance', 
		'delicious', 
		'deviantart', 
		'digg', 
		'reddit',
	 	'dribbble', 'zerply', 'facebook', 'flickr', 'forrst', 'github', 'pinterest', 'googleplus', 'yelp', 'lastfm', 'linkedin', 'foursquare', 'myspace', 'gowalla', 'skype', 'stumbleupon', 'tumblr', 'twitter', 'vimeo', 'youtube', 'email'
	);
	
	$output = '';
	$output .= '<div class="person">';
	if($atts['picture']):
	$output .= '<img class="person-img" src="' . $atts['picture'] . '" alt="' . $atts['name'] . '" />';
	endif;
	if($atts['name'] || $atts['title'] || $atts['facebooklink'] || $atts['twitterlink'] || $atts['linkedinlink'] || $content) {
		$output .= '<div class="person-desc">';
			$output .= '<div class="person-author clearfix">';
				$output .= '<div class="person-author-wrapper"><h3 class="person-name">' . $atts['name'] . '</h3>';
				$output .= '<h5 class="person-title">' . $atts['title'] . '</h5></div>';
				$output .='<div class="social-media-links"><ul class="dark">';
				
				if($atts['facebook']) {
					$output .= '<li class="facebook"><a href="' . $atts['facebook'] . '" class="facebook" rel="tooltip">Facebook</a></li>';
				}
				if($atts['twitter']) {
					$output .= '<li class="twitter"><a href="' . $atts['twitter'] . '" class="twitter" rel="tooltip">Twitter</a></li>';
				}
				if($atts['linkedin']) {
					$output .= '<li class="linkedin"><a href="' . $atts['linkedin'] . '" class="linkedin" rel="tooltip">LinkedIn</a></li>';
				}
				if($atts['dribbble']) {
					$output .= '<li class="dribbble"><a href="' . $atts['dribbble'] . '" class="dribbble" rel="tooltip">Dribbble</a></li>';
				}
			$output .= '</ul></div><div class="clear"></div></div>';
			$output .= '<div class="person-content">' . $content . '</div>';
		$output .= '</div>';
	}
	$output .= '</div>';

	return $output;
}


/**
 * Add Shortcodes and removes Wordpress autop and invalid nesting of p tags, as well as br tags
 *
 * @param string $text html content by the Wordpress editor
 * @return string $text
 */
 
 
/*Columns Shortcodes*/
add_shortcode('one_third', 			'radium_one_third');
add_shortcode('one_third_last', 	'radium_one_third_last');
add_shortcode('two_third', 			'radium_two_third');
add_shortcode('two_third_last', 	'radium_two_third_last');
add_shortcode('one_half', 			'radium_one_half');
add_shortcode('one_half_last', 		'radium_one_half_last');
add_shortcode('one_fourth', 		'radium_one_fourth');
add_shortcode('one_fourth_last', 	'radium_one_fourth_last');
add_shortcode('three_fourth', 		'radium_three_fourth');
add_shortcode('three_fourth_last', 	'radium_three_fourth_last');
add_shortcode('one_fifth', 			'radium_one_fifth');
add_shortcode('one_fifth_last', 	'radium_one_fifth_last');
add_shortcode('two_fifth', 			'radium_two_fifth');
add_shortcode('two_fifth_last', 	'radium_two_fifth_last');
add_shortcode('three_fifth', 		'radium_three_fifth');
add_shortcode('three_fifth_last', 	'radium_three_fifth_last');
add_shortcode('four_fifth_last', 	'radium_four_fifth_last');
add_shortcode('one_sixth', 			'radium_one_sixth');
add_shortcode('four_fifth', 		'radium_four_fifth');
add_shortcode('one_sixth_last', 	'radium_one_sixth_last');
add_shortcode('five_sixth', 		'radium_five_sixth');
add_shortcode('five_sixth_last', 	'radium_five_sixth_last');

/* Other */
add_shortcode('header', 			'radium_header_sc');

add_shortcode('hr', 				'radium_hr_sc');
add_shortcode('hr_invisible', 		'radium_hr_sc');

add_shortcode('clear', 				'radium_clear');
add_shortcode('clearfix', 			'radium_clear');

add_shortcode('toggle', 			'radium_toggle');
add_shortcode('tabs', 				'radium_tabs' );
add_shortcode('tab', 				'radium_tab' );
add_shortcode('alert', 				'radium_alert');

add_shortcode('dropcap', 			'radium_dropcaps_sc');
add_shortcode('dropcap1', 			'radium_dropcaps_sc');
add_shortcode('dropcap2', 			'radium_dropcaps_sc');
add_shortcode('dropcap3', 			'radium_dropcaps_sc');
add_shortcode('dropcap4', 			'radium_dropcaps_sc');

add_shortcode('highlight', 		'radium_highlight_sc' );

add_shortcode("chat", 				"radium_chat_post_sc");

add_shortcode("list", 				"radium_lists_sc");

add_shortcode('social-icon', 		'radium_social_icon_sc');
add_shortcode('icon', 				'radium_icon_sc');
add_shortcode('iconbox', 			'radium_icon_box_sc');
add_shortcode('button', 			'radium_button_sc');

add_shortcode('call_to_action', 	'radium_call_to_action_sc');
add_shortcode('carousel', 			'radium_carousel_sc');
add_shortcode('map', 				'radium_google_map_shortcode' );
add_shortcode('email_form', 		'radium_email_form_sc');
add_shortcode('popup', 				'radium_popup_sc');
add_shortcode('testimonial', 		'radium_testimonials_sc');
add_shortcode('teaser', 			'radium_teaser_sc');
add_shortcode('audio', 				'radium_audio_sc');
add_shortcode('video', 				'radium_video_sc');
add_shortcode('accordion', 			'radium_accordion_sc');

 
function radium_the_content_filter($content) {
 
	// array of custom shortcodes requiring the fix 
	$block = join("|",array( 
	
		/* Columns */
	 	'one_third', 
	 	'one_third_last', 
	 	'two_third', 
	 	'two_third_last',
	 	'one_half', 
	 	'one_half_last', 
	 	'one_fourth', 	
	 	'one_fourth_last', 	
	 	'three_fourth', 
	 	'three_fourth_last',
	 	'one_fifth', 	
	 	'one_fifth_last', 
	 	'two_fifth', 		
	 	'two_fifth_last', 
	 	'three_fifth', 	
	 	'three_fifth_last', 
	 	'four_fifth_last', 
	 	'one_sixth', 	
	 	'four_fifth', 
	 	'one_sixth_last',
	 	'five_sixth', 		
	 	'five_sixth_last', 
	 	/* end columns */
	 	
	 	'accordion', 	
	 	'alert', 
	 	'button', 
	 	'call_to_action', 	
	 	'carousel', 	
	 	'header', 	
	 	'hr', 				
	 	'hr_invisible', 	
	 	'clear', 		
	 	'clearfix', 		
	 		
	 	'chat',
	 	'iconbox', 
	 	'list',
 	 	'map', 	
 	 	'social-icon', 
 	 	'tab', 
	 	'tabs', 
	 	'testimonial',
	 	'toggle', 		
	 			
	 	'email_form', 	
	 	'person', 
	 	'progress', 	
	 	'teaser', 	
	 	'audio', 		
	 	'video'
	));
 
	// opening tag
	$rep = preg_replace("/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/","[$2$3]",$content);
		
	// closing tag
	$rep = preg_replace("/(<p>)?\[\/($block)](<\/p>|<br \/>)?/","[/$2]",$rep);
 
	return $rep;
 
}
add_filter("the_content", "radium_the_content_filter");
?>
