<?php

/********************* META BOX DEFINITIONS ***********************/

$prefix = '_radium_';

global $meta_boxes, $pagenow;
 
/********************* META BOX REGISTERING ***********************/

/* ---------------------------------------------------------------------- */
/*	Custom Post Type: Portfolio
/* ---------------------------------------------------------------------- */ 

$meta_boxes[] = array(
	'id' => 'portfolio',
	'title' =>  __('Portfolio Detail Settings', 'radium'),
	'pages' => array('portfolio'),
	'context' => 'normal',
	'priority' => 'high',
	
	'fields' => array(
	
		array('name' => __('Subtitle:', 'radium'),
			'id'   => $prefix . 'subtitle',
			'type' => 'text',
				'desc' => 'Page subtitle'
		),
	
    	array(
			'name' =>  __('Portfolio Type', 'radium'),
			'desc' => __('Choose the type of portfolio you wish to display.', 'radium'),
			'id' => $prefix . 'portfolio_type',
			"type" => "select",
			'std' => 'normal',
			'options' => array(
				'normal' 	=>'Normal Post',
				'slideshow' =>'Slideshow', 
				'audio' 	=>'Audio', 
				'video' 	=>'Video', 
				'image' 	=>'Image', 
 			)
		),
    	array(
    	   'name' => __('Portfolio Date', 'radium'),
    	   'desc' => __('What was the date of the completed portfolio', 'radium'),
    	   'id' => $prefix . 'portfolio_date',
    	   'type' => 'text',
    	   'std' => ''
    	),
    	array(
    	   'name' => __('Portfolio Client', 'radium'),
    	   'desc' => __('For whom was the portfolio completed', 'radium'),
    	   'id' => $prefix . 'portfolio_client',
    	   'type' => 'text',
    	   'std' => ''
    	),
    	array(
    	   'name' => __('Portfolio URL', 'radium'),
    	   'desc' => __('What is the URL for the Portfolio?', 'radium'),
    	   'id' => $prefix . 'portfolio_url',
    	   'type' => 'text',
    	   'std' => ''
    	)
	)
);

$meta_boxes[] = array(
	'id' => 'portfolio_image_gallery',
	'title' => __('Image Settings', 'radium'),
	'pages' => array('portfolio'),
	'context' => 'normal',
	'priority' => 'high',
	
	'fields' => array(
		array( "name" => '<strong>Gallery Images</strong><br><br><small>Click "<strong>Select Images Insert into Post</strong>"(It will insert the image into this box).</small>',
				"desc" => 'Images uploaded here will show up in the item page, slided one after another. ',
				"id" => $prefix . "portfolio_upload_images",
				"type" => 'plupload_image',
 			)
    )
);

 
$meta_boxes[] = array(
	'id' => 'portfolio-video',
	'title' => __('Video Settings', 'radium'),
	'pages' => array('portfolio'),
	'context' => 'normal',
	'priority' => 'high',
	
	'fields' => array(
		
		/*
		array( "name" => __('Video Height','radium'),
				"desc" => __('The video height (e.g. 390).','radium'),
				"id" => $prefix . "video_height",
				"type" => "text",
				'std' => ''
			), */
			
		array( "name" => __('M4V File URL','radium'),
				"desc" => __('The URL to the .m4v video file','radium'),
				"id" => $prefix . "video_m4v",
				"type" => "text",
				'std' => ''
			),
		array( "name" => __('OGV File URL','radium'),
				"desc" => __('The URL to the .ogv video file','radium'),
				"id" => $prefix . "video_ogv",
				"type" => "text",
				'std' => ''
			),
		array( "name" => __('Poster Image','radium'),
				"desc" => __('The preview image. (It is only displayed on self hosted videos)','radium'),
				"id" => $prefix . "video_poster",
				"type" => "text",
				'std' => ''
			),
		array(
			'name' => __('Embedded Code', 'radium'),
			'desc' => __('If you are using something other than a self hosted video such as Youtube or Vimeo, paste the embed code here. Width is best at 710px with any height.<br><br> This field will override the above.', 'radium'),
			'id' => $prefix . 'portfolio_embed_code',
			'type' => 'textarea',
			'std' => ''
		)
	),
	
);

$meta_boxes[] = array(
	'id' => 'portfolio-audio',
	'title' =>  __('Audio Settings', 'radium'),
	'pages' => array('portfolio'),
	'context' => 'normal',
	'priority' => 'high',
	
	'fields' => array(
		array( 
		    "name" => __('Audio File URL','radium'),
				"desc" => __('The URL to the audio file. Supported formats are mp3, m4a, oga, fla ','radium'),
				"id" => $prefix."audio_file",
				"type" => "text",
				'std' => ''
		),

		array(
		    'name' => __('Poster Image', 'radium'),
		    'desc' => __('The Preview Image for this audio track', 'radium'),
		    'id' => $prefix . 'audio_poster',
		    'type' => 'text',
		    'std' => ''
		),
		
		/*
		array(
		    'name' => __('Poster Image Height', 'radium'),
		    'desc' => __('The height of the poster image', 'radium'),
		    'id' => $prefix . 'poster_height',
		    'type' => 'text',
		    'std' => ''
		) */
	)
);