<?php
/*
 * This file is a part of the RadiumFramework core.
 * Please be extremely cautious editing this file,
 *
 * @category RadiumFramework
 * @package  Singleton
 * @author   Franklin M Gitonga
 * @link     http://radiumthemes.com/
 */
 
 
 /*-----------------------------------------------------------------------------------------------*/
 /* General Theme Functions for the Front-end
 /*------------------------------------------------------------------------------------------------*/

 /*-----------------------------------------------------------------------------------*/
 /* Clean Up the <head> 
 /*--------------------------------------- --------------------------------------------*/
 //remove_action('wp_head','feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
 //remove_action('wp_head','feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
 //remove_action('wp_head','rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
 //remove_action('wp_head','wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
 //remove_action('wp_head','index_rel_link'); // index link
 //remove_action('wp_head','parent_post_rel_link', 10, 0); // prev link
 //remove_action('wp_head','start_post_rel_link', 10, 0); // start link
 //remove_action('wp_head','adjacent_posts_rel_link', 10, 0); // Display relational links for the posts adjacent to the current post.
 remove_action('wp_head','wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
 
 //remove inline style added by multisite in the signup form
 if ( !function_exists('radium_wpmu_signup_stylesheet') ) {
 	
 	function radium_wpmu_signup_stylesheet() {
 		remove_action( 'wp_head', 'wpmu_signup_stylesheet');
 	}
 	add_action( 'wp_head', 'radium_wpmu_signup_stylesheet', 1 );
 	
 }


/*-----------------------------------------------------------------------------------*/
/* Read More
/*--------------------------------------- --------------------------------------------*/
 
 function radium_blog_grid_excerpt_more( $more ) {
    global $post;
 	
 	//if( is_page_template('page-blog-grid.php') || is_page_template('page-portfolio.php') )
 		return '<div class="clearfix"><a href="'. get_permalink($post->ID) . '" class="more-link"><span>'.__('Continue Reading','radium').' &rarr;</span></a></div>';
 
 }
 add_filter('excerpt_more', 'radium_blog_grid_excerpt_more');
 
 
 /*-----------------------------------------------------------------------------------*/
 /* Remove unnecessary dashboard widgets
 /* @link http://www.deluxeblogtips.com/2011/01/remove-dashboard-widgets-in-wordpress.html
 /*-----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_remove_dashboard_widgets') ) {
 
 	function radium_remove_dashboard_widgets() {
 	  	remove_meta_box('dashboard_incoming_links', 'dashboard', 'normal');
 	 	remove_meta_box('dashboard_plugins', 'dashboard', 'normal');
 		remove_meta_box('dashboard_primary', 'dashboard', 'normal');
 	  	remove_meta_box('dashboard_secondary', 'dashboard', 'normal');
 	}
 	
 	//add_action('admin_init', 'radium_remove_dashboard_widgets');
 	
 }
 		
 /*----------------------------------------------------------------------------------
 // Fix for Category Rel Tag (Produces invalid HTML5 code)
  ----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_add_nofollow_cat') ) {
 	 
 	function radium_add_nofollow_cat( $text ) {
 	
 		$text = str_replace('rel="category tag"', "", $text); 
 		
 		return $text;
 		
 	}
 	add_filter( 'the_category', 'radium_add_nofollow_cat' ); 
 }
 
 
 /*-----------------------------------------------------------------------------------
 /* 	 Override default logo if set in options radium_custom_logo()
 /*-----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_custom_logo') ) {
 
 	function radium_custom_logo() {
 	  	
 	  	$framework = radium_framework();
 	  	
 	  	$options = $framework->options;
 	  	
 	  	?>
 	  	
 	  	<a href="<?php echo home_url(); ?>" title="<?php echo bloginfo( 'name' ); ?>" rel="home">
 	
 	 		<?php 
 	 		
 	 		// if there is text defined (instead of logo), display it
 			if(!$framework->options['logo']) { ?>
 			
 				 <h1 id="logo_text"><?php echo bloginfo( 'name' ); ?></h1>
 				 
 	 		 <?php 
 	 		 
 	 		 } else { // display custom logo (if defined) or default logo
 			
 				$logo_img = $framework->options['logo'];
 				
 				if(empty($logo_img)) { $logo_img = $framework->theme_images_url.'/logo.png'; } ?>
 				
 				<!-- Custom Logo -->
 				<img src=" <?php echo $logo_img; ?>" class="logo" alt="logo"/>	
 							
 			<?php } 
 			
 			if( isset($options['site_description']) ){ ?><div id='branding-tagline'><p><?php echo bloginfo( 'description' ); ?></p></div> <?php } 
 			
 			?>
 			  
 		</a>
 		
 		<?php  
 	 
 	 }
 	add_action('radium_header_logo', 'radium_custom_logo');
 }
 
 
 /*-------------------------------------------------------------------------------------------------
  * Custom Admin & Login Logo
  --------------------------------------------------------------------------------------------------*/
 if ( !function_exists('radium_login_head') ) {
  
 	function radium_login_head() {
 	
 	  	$framework = radium_framework();
 	  	
 	  	$options = $framework->options;
 	
 		/* Setup settings to use */
 		$logo_url = '';
 		if ( isset($options['logo']) && $options['logo'] != '' ) {
 			$logo_url = $options['logo'];
 		}
 		if ( $logo_url != '' ) {
 			$dimensions = @getimagesize( $logo_url );
 			echo '<style>' . "\n" . 'body.login #login h1 a { background: url("' . $logo_url . '") no-repeat scroll center top transparent; height: ' . $dimensions[1] . 'px; width: auto; }' . "\n" . '</style>' . "\n";
 		}
 	
 	} // End radium_login_head()
 	add_filter('login_head', 'radium_login_head');	
 }
 if ( !function_exists('radium_login_header_url') ) {
 
 	function radium_login_header_url($url) {
 		
		$framework = radium_framework();

		$options = $framework->options;
 		
 		/* Setup settings to use */
 		$login_url = home_url();
 	
 		return $login_url;
 	    
 	} // End radium_login_header_url()
 	add_filter('login_headerurl', 'radium_login_header_url');
 }
 if ( !function_exists('radium_login_header_title') ) {
 
 	function radium_login_header_title($title) {
 	
 		$title_text = get_bloginfo('name').' &raquo; Log In';
 	
 		return $title_text;
 	
 	} // End radium_login_header_title()
 	add_filter('login_headertitle', 'radium_login_header_title');
 }	
 	
 
 /*------------------------------------------------------------------------------------
 			Custom Favicon and Apple Touch Icon
 --------------------------------------------------------------------------------------*/
 if ( !function_exists('radium_add_favicon') ) {
 
 	function radium_add_favicon() { 
 		
 		$framework = radium_framework();
 	
 		$favicon = $framework->options['favicon'];
 		$appleicon = $framework->options['appleicon'];
 		
 		if(empty($favicon)) { 
 			$favicon = $framework->theme_images_url.'/favicon.gif';
 		}
 		
 		if(empty($appleicon)) { 
 			$appleicon = $framework->theme_images_url.'/apple-touch-icon.png';
 		}
 		?>
 			<link rel="shortcut icon" href="<?php echo $favicon ?>"/> 
 			<link rel="apple-touch-icon" href="<?php echo $appleicon ?>"/>
 			
 		<?php 
 	}
 	
 	add_action('wp_head', 'radium_add_favicon');
 	
 }
 
 /* ---------------------------------------------------------------------- */
 /* Renders the theme feed URL (either the user-specified feed or the native WordPress-based feed).
 /* ---------------------------------------------------------------------- */
 if ( !function_exists('radium_feed_url') ) {
 	
 	function radium_feed_url() {
 		
  		$framework = radium_framework();
  		
  		$options = $framework->options;
  
  		echo $options['feedburner_url'] ? $options['feedburner_url'] : get_bloginfo_rss('rss2_url');
 		
 	} // end get_feed_url
 	
 }
 
 
 /*-----------------------------------------------------------------------------------
 	Password Box Filter
 -----------------------------------------------------------------------------------*/
 if ( !function_exists('custom_password_form') ) {
 
 	function custom_password_form() {
 	
 		global $post;
 	  	
 			$label = 'pwbox-' . ( empty($post->ID) ? rand() : $post->ID );
 			
 			$output = '<form action="' . esc_url( site_url( 'wp-login.php?action=postpass', 'login_post' ) ) . '" method="post" class="post-password-form">
 			<p>' . __("This post is password protected. To view it please enter your password below:", 'radium') . '</p>
 			
 			<label for="' . $label . '">' . __( "Password:", 'radium' ) . ' </label><input name="post_password" id="' . $label . '" type="password" size="20" /><input class="button" type="submit" name="Submit" value="' . esc_attr__("Submit") . '" />
 		</form>
 			';
 			return $output;
 	}
 	add_filter( 'the_password_form', 'custom_password_form' );
 	
 }
 
 /*-----------------------------------------------------------------------------------
 /* 	Post Meta
 /*-----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_posted_on') ) {
 	
 	/* Time and Date*/
 	function radium_posted_on() {
 		
 		$comments =  ( comments_open() && ! post_password_required() ) ? 'comments-on' : null; 
 		
 		printf( __( '<div class="date %8$s"><i class="icon-calendar"></i><time class="entry-date" datetime="%3$s">%4$s</time></div>', 'radium' ),
 			esc_url( get_permalink() ),
 			esc_attr( get_the_time() ),
 			esc_attr( get_the_date( 'c' ) ),
 			esc_html( get_the_date() ),
 			esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
 			esc_attr( sprintf( __( 'View all posts by %s', 'radium' ), get_the_author() ) ),
 			get_the_author(),
 			$comments
 		);
 	}
 
 }
 
 if ( !function_exists('radium_post_format_icon') ) {
 
 	/* Show Post Format Icon */
 	function radium_post_format_icon() { ?>
 		<i class="icon-calendar"></i>
 		<a href="<?php echo get_permalink() ?>" title="<?php echo sprintf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ) ?>" rel="bookmark"><span class="post-format <?php echo get_post_format() ?>"><?php echo __('Permalink', 'radium') ?></span></a>
 	<?php	
 	}
 
 }
 
 if ( !function_exists('radium_post_meta') ) {
 
 	/* Meta Loader for Frontend */
 	function radium_post_meta() { ?>
 	
 	    <div class="entry-meta clearfix">
 	    	<div class="info clearfix">
	 	    	<?php radium_posted_on(); 
	 	    	
	 	    	if ( comments_open() && ! post_password_required() ) : ?>
	 	    	
	 	    		<div class="comments-link comments-on">
	 	    			<i class="icon-comments-alt"></i>
	 	    			<?php comments_popup_link( '<span class="leave-reply">' . __( 'Reply', 'radium' ) . '</span>', _x( '1 Comment', 'comments number', 'radium' ), _x( '% Comments', 'comments number', 'radium' ) ); ?>
	 	    		</div>
	 	    		
	 	    	<?php endif; ?>
 	    	</div>
 	    	<div class="by-author">
 	    		<i class="icon-user "></i>
 	    		<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
 	    			<?php printf( __( 'By %s', 'radium' ), get_the_author() ); ?>
 	    		</a>
 	    	</div><!-- #author-link	-->
 	    			 	    	
 	    	<?php
 	    	
 	    	edit_post_link( __( '[edit]', 'radium' ), '<div class="edit-link">', '</div>' ); ?>
 	    	
 	    </div><!-- .entry-meta --><?php
 	
 	}
 	add_action('radium_post_meta','radium_post_meta');
 
 }
 
 
 /*-----------------------------------------------------------------------------------
 /* Blog Grid Post Meta
 /*-----------------------------------------------------------------------------------*/

 if ( !function_exists('radium_post_grid_meta') ) {
 
 	/* Meta Loader for Frontend */
 	function radium_post_grid_meta() { ?>
 	
 	    <div class="entry-meta clearfix">
 	    	
 	    	<div class="by-author">
 	    	 	<span class="icon-user "></span>
 	    		<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
 	    			<?php printf( __( 'By %s', 'radium' ), get_the_author() ); ?>
 	    		</a>
 	    	</div><!-- #author-link	-->
 	    			
 	     	<?php radium_posted_on(); ?>
 	    	
 	    	<?php
 	    	
 	    	edit_post_link( __( '[edit]', 'radium' ), '<div class="edit-link">', '</div>' ); ?>
 	    	
 	    </div><!-- .entry-meta --><?php
 	
 	}
 	add_action('radium_post_grid_meta','radium_post_grid_meta');
 
 }
 
 if ( !function_exists('radium_post_grid_footer_meta') ) {
 
 	/* Meta Loader for Frontend */
 	function radium_post_grid_footer_meta() { ?>
 	
 	    <div class="footer-meta clearfix">
 	    	
 	    	<?php if ( comments_open() && ! post_password_required() ) : ?>
 	    	
 	    		<div class="comments-link">
 	    			<?php comments_popup_link( '<span class="leave-reply">' . __( 'Reply', 'radium' ) . '</span>', _x( '1 Comment', 'comments number', 'radium' ), _x( '% Comments', 'comments number', 'radium' ) ); ?>
 	    		</div>
 	    		
 	    	<?php endif; ?>
 
 	    </div><!-- .entry-meta --><?php
 	
 	}
 	//add_action('radium_post_grid_footer_meta','radium_post_grid_footer_meta');
 
 }
 
 /*-----------------------------------------------------------------------------------
 /* 	Share Posts 
 /*-----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_social_share') ) {
 	
 	function radium_social_share() {
 		
 		global $post;
 		
 	 	$framework = radium_framework();
 	 	
 	 	$options = $framework->options;
 		
 	    @$share_buttons = $options['share_post'] ? $options['share_post'] : false;
 		
 		if ( $share_buttons ) : ?> 
 		
 		<div class="share-buttons-wrapper">
 			<div class="share-post clearfix">
 			
 				<?php if ( $share_buttons && array_key_exists('twitter', $share_buttons) ) : ?> 
 					<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0];if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src="//platform.twitter.com/widgets.js";fjs.parentNode.insertBefore(js,fjs);}}(document,"script","twitter-wjs");</script>
 				
 		 			<div class="twitter-share">	
 						<a href="http://twitter.com/share" class="twitter-share-button" 
 							data-url="<?php the_permalink(); ?>"
 							data-via="<?php bloginfo('name'); ?>"
 							data-text="<?php the_title(); ?>"
 							data-related="<?php bloginfo('name'); ?>"
 							data-count="horizontal"
 							>
 							Tweet
 						</a>
 					</div>
 				<?php endif; ?>
 				
 				<?php if ( $share_buttons && array_key_exists('facebook', $share_buttons) ) : ?> 
 		 			<div class="facebook-like">	
 						<script src="http://connect.facebook.net/en_US/all.js#xfbml=1"></script><fb:like href="<?php echo urlencode(get_permalink(get_The_ID())); ?>"; layout="button_count" show_faces="false"></fb:like>
 					</div>	
 				<?php endif; ?>
 				
 				<?php if ( $share_buttons && array_key_exists('pinterest', $share_buttons) ) : 
 				
 					wp_enqueue_script('pinit', 'https://assets.pinterest.com/js/pinit.js', true );  
 				
 				?> 
 	 				<div class="pinit">
 						<a href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php @$thumb = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'thumbnail' ); if ( $thumb ) echo $thumb['0']; ?>&description=<?php the_title(); ?>" class="pin-it-button" count-layout="horizontal">Pin It</a>
 					</div>
 	 			<?php endif; ?>
 				
 				<?php if ( $share_buttons && array_key_exists('google+', $share_buttons) ) : 
 				
 				wp_enqueue_script('googleplus', 'https://apis.google.com/js/plusone.js', false );  
 				
 				?> 
 	 				<div class="gplus">
 						<g:plusone size="medium" annotation="inline" width="120"></g:plusone>
 					</div>
 					
 	 			<?php endif; ?>
 				
 			</div>
 		</div>
 		
 		<?php endif; ?>
 		
 		<?php
 	}
 	add_action('radium_after_post_content', 'radium_social_share');
 
 }
 
   
 /*-----------------------------------------------------------------------------------
 /* 	Footer Tracking Code
 /*-----------------------------------------------------------------------------------*/
 if ( !function_exists('radium_footer_trackingcode') ) {
 
 	function radium_footer_trackingcode() {
 	
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 		
 		echo $options['trackingcode'];
 	}
 
 }
 
 /*------------------------------------------------------------------------------------
 // Load the Radium Message bar
  -------------------------------------------------------------------------------------*/
 if ( !function_exists('radium_foobar') ) {
 
 	function radium_foobar() {
 	
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 	  
 		if ( isset($options['enable_message_bar']) ) {
 			echo '<div id="radium_foobar" class="load_foobar hidden">
 				<div class="inner">
 					<div class="row">
 						<div class="twelve columns">
 							<div class="message">'. $options['message_bar_text'] .'</div>
 						</div>
 					</div>
 				</div>
 				<div class="openbtn cursor"></div>
 				<div class="closebtn cursor"></div>
 			</div>';
 		}
 	}
 	add_action('radium_before_header', 'radium_foobar');
 	
 }
 
 /*------------------------------------------------------------------------------------
 // Load Single Post Navigation
  -------------------------------------------------------------------------------------*/
 if ( !function_exists('radium_single_posts_navigation') ) {
 
 	function radium_single_posts_navigation() { 
 	
 		if( is_single() ) : ?>
 	
 			<nav id="nav-single" >
 				<span class="nav-previous left"><?php previous_post_link( '%link', __( '<span class="meta-nav">&larr;</span> Previous', 'radium' ) ); ?></span>
 				<span class="nav-next right"><?php next_post_link( '%link', __( 'Next <span class="meta-nav">&rarr;</span>', 'radium' ) ); ?></span>
 			</nav><!-- #nav-single -->
 	
 		<?php endif; // End if Nav 
 		
 	}
 	add_action('radium_after_post', 'radium_single_posts_navigation');
 	add_action('radium_after_portfolio', 'radium_single_posts_navigation');
 	
 }

 
 /*------------------------------------------------------------------------------------
 //Post Tags
  -------------------------------------------------------------------------------------*/
 if( !function_exists('radium_single_post_tags') ) {
   
 	/* Show/hide Tags */
 	function radium_single_post_tags() {
 	 	
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 		
 		$post_tags = isset($options['post_tags']) ? $options['post_tags'] : false;
 				
 		if ( is_single() && ( $post_tags && array_key_exists('posts', $post_tags )) ) :  
 	  		
 	  		$tags_list = get_the_tag_list( '', __( ', ', 'radium' ) );
 	  
 			if ( $tags_list ): ?>
 				<div class="tags entry-meta clearfix">
 					<div class="tags-list">
 						<span class="icon"><span class="icon-tag"></span></span>
 						<?php printf( __( ' %2$s', 'radium' ), 'entry-utility-prep entry-utility-prep-tag-links', $tags_list ); ?>
 					</div>
 				</div>
 			<?php endif; 
 	
 		endif;
 	}
 	add_action('radium_after_post_content', 'radium_single_post_tags');
 
 }
 
 
 /*------------------------------------------------------------------------------------
 // Load the Radium Related Posts
  -------------------------------------------------------------------------------------*/
   
 if( !function_exists('radium_related_posts') ) {
 
 	function radium_related_posts(){
 		
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 				
 		$related_posts = isset($options['related_posts']) ? $options['related_posts'] : false;
 		
 		if ( $related_posts && array_key_exists( 'posts', $related_posts ) )
 			include( $framework->theme_includes_dir . '/extensions/related-posts.php');
 	}
 	add_action('radium_after_post_content', 'radium_related_posts');
 
 }
 
 if ( !function_exists('radium_related_items') ) {
 
 	function radium_related_items() {
 	
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 		
 		?> 	<div class="intro">
 		        <h3 class="widget-title entry-title"><?php echo $options['related_portfolio_header']; ?></h3>
 			    <p><?php echo $options['related_portfolio_desc']; ?></p>
 			</div>
 		<?php
 	}
 
 }
 
 /* ---------------------------------------------------------------------- */
 /* Render the analytics either in the footer or the header depending on which part
 /* of the page is calling this function.
 /*
 /* @IsHeader	Whether or not the header is calling this function.
 /* ---------------------------------------------------------------------- */
 if( !function_exists('radium_analytics') ) {
 
 	function radium_analytics($IsHeader) {
 	
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 		
 		if($IsHeader):
 			if ($options['header_analytics']):
 				echo $options['header_analytics'];
 			endif;
 		else:
 			if($options['other_analytics']):
 				echo $options['other_analytics'];
 			endif;
 		endif;
 		
 	} // end radium_analytics
 
 }
 
 /*------------------------------------------------------------------------------------
 // Load Footer Copyright
  -------------------------------------------------------------------------------------*/
 if( !function_exists('radium_footer_copyright') ) {
  
 	function radium_footer_copyright(){ 
 		
 		$framework = radium_framework();
 		
 		$options = $framework->options;
 	
 		echo $options['footer_copyright_text'];
 	
 	}
 	add_action('radium_copyright', 'radium_footer_copyright', 1);
 	
 }
 
 
 /*------------------------------------------------------------------------------------
 // Allow Iframes in content
  -------------------------------------------------------------------------------------*/
 
 function radium_change_mce_iframe_options($initArray) {
     // Comma separated string od extendes tags
     // Command separated string of extended elements
     $ext = 'pre[id|name|class|style],iframe[align|longdesc|name|width|height|frameborder|scrolling|marginheight|marginwidth|src]';
 
     if ( isset( $initArray['extended_valid_elements'] ) ) {
         $initArray['extended_valid_elements'] .= ',' . $ext;
     } else {
         $initArray['extended_valid_elements'] = $ext;
     }
     // maybe; set tiny paramter verify_html
     //$initArray['verify_html'] = false;
 
     return $initArray;
 }
 //add_filter('tiny_mce_before_init', 'radium_change_mce_iframe_options');
 
 
 /*------------------------------------------------------------------------------------
 // Allow Iframes in layout builder
  -------------------------------------------------------------------------------------*/
 
 /* 
  * This is an example of how to override a default filter
  * for 'textarea' sanitization and $allowedposttags + embed and script.
  */
 add_action('admin_init','radium_bulder_optionscheck_change_sanitization', 100);
  
 function radium_bulder_optionscheck_change_sanitization() {
     remove_filter( 'radium_opt_sanitize_textarea', 'radium_opt_sanitize_textarea' );
     add_filter( 'radium_opt_sanitize_textarea', 'radium_builder_custom_sanitize_textarea' );
 }
  
 function radium_builder_custom_sanitize_textarea($input) {
    global $allowedposttags;
	
	//if($option['validate'] == 'embed'){
	
	$my_tags = array();
	$my_tags = $allowedposttags; //duplicate $allowed tags
	
	$my_tags["iframe"] = array( //add new allowed tags
		"src" => array(),
		"height" => array(),
		"width" => array(),
		"frameborder" => array(),
		"allowfullscreen" => array(),
	);
	
	$my_tags["object"] = array(
		"height" => array(),
		"width" => array()
	);
	
	$my_tags["param"] = array(
		"name" => array(),
		"value" => array()
	);
	
	$my_tags["embed"] = array(
		"src" => array(),
		"type" => array(),
		"allowfullscreen" => array(),
		"allowscriptaccess" => array(),
		"height" => array(),
		"width" => array()
	);
	
	$output = wp_kses( $input, $my_tags); //kses filter against my new list of allowed tags
	    
	return $output;

 }
 
 
 /*------------------------------------------------------------------------------------
 /* Header Meta region
  -------------------------------------------------------------------------------------*/

 function radium_header_meta(){
 	dynamic_sidebar('Header Tools');
 }
 add_action('radium_header_tools', 'radium_header_meta');