<?php

/**
 * Get all sample layouts.
 *
 * @return array
 */
 
function radium_builder_portfolio_samples( $samples ) {

	$framework = radium_framework();
	
	$samples['portfolio'] = array(
		'name' => 'Portfolio',
		'id' => 'portfolio',
		'preview' => $framework->theme_includes_url . '/builder/assets/images/sample-layouts/portfolio.png',
			'featured' => array(
			'element_1' => array(
				'type' => 'slider',
				'query_type' => 'secondary',
				'options' => array(
					'slider_id' => null
				)
			)
		),
		'primary' => array(
			'element_2' => array(
				'type' => 'post_grid_paginated',
				'query_type' => 'primary',
				'options' => array(
					'type' => 'post_grid_paginated',
					'query_type' => 'primary',
					'options' => array(
					'categories' => array('all'=>1),
					'columns' => 4,
					'rows' => 3,
					'orderby' => 'post_date',
					'order' => 'DESC',
					'offset' => 0
				)
				)
			)
		)
	);
	
	return $samples;
}
add_filter('radium_sample_layouts', 'radium_builder_portfolio_samples');