<?php
/** 
 * Register Columns Element
 * @return array();
 */
function radium_builder_registar_slider_element( $elements ) {
	
	//Select Slider
	$sliders_select = array();
	
	$slider = get_posts( 'post_type=slider&numberposts=-1' );
	if( ! empty( $slider ) )
		foreach( $slider as $k )
			$sliders_select[$k->post_name] = $k->post_title;
	else
		$sliders_select['null'] = __( 'You haven\'t created any slider yet.', 'radium' );
				
	
	// Slider
	$element_slider = array(
	    array(
	    	'id' 		=> 'slider_id',
	    	'name'		=> __( 'Select Slider', 'radium' ),
	    	'desc'		=> __( 'Choose the slider you\'d like to show.', 'radium' ),
	    	'type'		=> 'select',
	    	'options'	=> $sliders_select,
	    	'class'		=> 'slider-content'
	    )
	);
	
	$elements['slider'] = array(
		'info' => array(
			'name' 	=> 'Slider',
			'id'	=> 'slider',
			'query'	=> 'none',
			'hook'	=> 'radium_slider_block',
			'shortcode'	=> '[slider]',
			'desc' 	=> __( 'Slider', 'radium' )
		),
		'options' => $element_slider
	);
	
	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builder_registar_slider_element');	