<?php
/**
* Plugin Name: Radium Sidebars
* Plugin URI: http://radiumthemes.com/
* Description: Replace widget areas in your theme for specific pages, archives and other sections of WordPress.
* Author: RadiumThemes
* Author URI: http://radiumthemes.com/
* Version: 1.2.2
* License: GPL v2 - http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
* Based on WooSidebars by WooThemes
*/

$framework = radium_framework();
 
require_once( $framework -> theme_framework_dir . '/sidebars/classes/class.radiumconditions.php' );
require_once( $framework -> theme_framework_dir . '/sidebars/classes/class.radiumsidebars.php' );
require_once( $framework -> theme_framework_dir . '/sidebars/classes/class.widgetclass.php' );
 
global $radiumsidebars;

$radiumsidebars = new Radium_Sidebars();
$radiumsidebars->init();

$radium_widget_class = new Radium_WidgetClass();

// Third-party integrations.
if ( class_exists( 'Woocommerce' ) ) 
	require_once( $framework -> theme_framework_dir . '/sidebars/classes/class.integration-woocommerce.php' );

function radium_add_widget_manager_admin_bar_link() {

	global $wp_admin_bar;
	
	if(!current_user_can('edit_theme_options')) return;

	$urlpagesBase = admin_url( 'edit.php' );
		
	// Add sub menu link "View All Posts"
	$wp_admin_bar->add_node( array(
		'parent' => 'radiumthemes-options',
		'id'     => 'radium_sbm',
		'title'  => __( 'Widget Areas','radium'),
		'href'   => _x($urlpagesBase.'?post_type=sidebar', 'radium'),
	));
	
}
add_action('admin_bar_menu', 'radium_add_widget_manager_admin_bar_link',9999);

/* Message for Widgets page. */

if ( ! function_exists( 'radium_sidebar_widgets_admin_page' ) ) {

	function radium_sidebar_widgets_admin_page() {
		// Kind of a sloppy w/all the yucky inline styles, but otherwise, 
		// we'd have to enqueue an entire stylesheet just for the widgets 
		// page of the admin panel.
		echo '<div style="width:300px;float:right;position:relative;z-index:1000"><p class="description" style="padding-left:5px">';
		_e( 'In the <a href="edit.php?post_type=sidebar">Widget Area Manager</a>, you can create and manage widget areas for specific pages of your website to override the default locations you see below.', 'radium');
		echo '</p></div>';
	}
	
} 


if ( current_user_can( 'edit_theme_options' ) )
   	add_action( 'widgets_admin_page', 'radium_sidebar_widgets_admin_page' );