<?php
/**
 * Template Name: Custom Layout
 *
 * This template file is a core part of the 
 * Radium Framework. This framework is 
 * designed around this file NEVER being altered. It 
 * is advised that any edits to the way this file 
 * displays its content be done with via hooks and filters.
 * 
 * @author		Franklin M Gitonga
 * @copyright	Copyright (c) Franklin M Gitonga
 * @link		http://radiumthemes.com
 * @package 	Radium Framework
 * @since 		RadiumFramework 2.1.0
 */

get_header(); 

radium_sidebar_loader();

$layout = radium_builder_config( 'builder' );

// Featured area
if( radium_builder_config( 'featured' ) ) {

	$layout_post_id = radium_post_id_by_name( $layout, 'radium_layout' );
	$featured_settings =  get_post_meta( $layout_post_id, 'settings', true ); 
	
	?>
	<div id="featured-area" <?php if( isset( $featured_settings['settings']['featured']['layout'] ) ) { ?>class="<?php echo $featured_settings['settings']['featured']['layout']; ?>" <?php } ?> style="<?php if( isset( $featured_settings['settings']['featured']['background']['color'] ) ) { ?>background-color: <?php echo $featured_settings['settings']['featured']['background']['color']; ?>; <?php } if( isset( $featured_settings['settings']['featured']['background']['url']) ) { ?> background-image: url('<?php echo $featured_settings['settings']['featured']['background']['url']; ?>'); background-repeat: repeat; <?php } ?> background-position: center center; " >
		<div class="<?php if( $featured_settings['settings']['featured']['layout']  !== 'wide') { echo 'row'; } else { echo 'fullwidth'; }  ?> clearfix">
			<?php radium_builder_elements( $layout, 'featured' ); ?>
		</div>
	</div>
<?php } else { 
//Load page header page header if featured area is inactive
?>
<header id="page-header">
	<div class="inner">
		<div class="row">
			<div class="twelve columns">
				<div id="header-title">
					<?php get_template_part( 'includes/content/content', 'header' ); ?>
				</div>
	      	</div>
	    </div>
    </div>
</header>
<?php } ?>	
<section id="builder-container">
	<div class="row">
		 <?php  //Start Main Area ?>
			<div id="main" class="<?php echo $radium_content_class; ?> clearfix" role="main">
				<div id="content" role="main">
					<div class="row">
						<?php radium_builder_elements( $layout, 'primary' ); ?>
					</div><!-- .inner  -->
				</div><!-- #content  -->
			</div><!-- #main -->
		<?php
		// End main area
		if( $radium_sidebar_location === 'left' || $radium_sidebar_location === 'right' ) { ?>
			<aside id="sidebar" class="sidebar <?php echo $radium_sidebar_class; ?>">
				<div id="sidebar-main" class="sidebar">
			     	<?php get_sidebar(); ?>
				</div><!--sidebar-main-->
			</aside>
		<?php }	?>
	</div><!--.row-->
</section>
<?php get_footer();