<?php

/*-----------------------------------------------------------------------------------

 	Widget Name: Recent Portfolio Widget
 	Widget URI: 
 	Description:  A widget that displays your recent portfolios.
 	Author: RadiumThemes
 	Author URI: http://radiumthemes.com
 	Version: 1.0
 
-----------------------------------------------------------------------------------*/

// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'radium_recent_portfolios_widget' );


// Register widget.
function radium_recent_portfolios_widget() {
	register_widget( 'radium_Recent_Portfolios_Widget' );
}

// Widget class.
class radium_recent_portfolios_widget extends WP_Widget {

/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
 
	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
	
		$framework = radium_framework();
		
		parent::__construct(
	 		'radium_recent_portfolios_widget', // Base ID
			'Recent Portfolio Widget ('. $framework->theme_title .')', // Name
			array( 'description' => __( 'A widget that displays your recent portfolios.', 'radium' ), )
		);
	}

/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/

function widget( $args, $instance ) {
	
	$framework = radium_framework();

	extract( $args );
	
	$title = apply_filters('widget_title', $instance['title'] );
	
	/* Our variables from the widget settings. */
	$number = ( isset($instance['number']) ) ? $instance['number'] : 0;
	$desc = $instance['desc'];
	
	/* Before widget (defined by themes). */
	
	echo $before_widget;
	
	/* Display Widget */
	?>
   	<?php 
   		
   		/* Display the widget title if one was input (before and after defined by themes). */
   		if ( $title )
   			echo $before_title . $title . $after_title; 
   		?>		    
	    
	    <div class="radium-recent-portfolios-widget">
		    <?php if ($desc) { ?>
            	<p><?php echo $desc; ?></p>
           	<?php }
 
				//fallback if all image urls are false
				if (empty($img_url)) { $image = $framework->theme_images_url . '/placeholder.gif'; }  
							   	 	
			   	//Set Thumbs
		    	$thumb_w 	= 220; //Define width
		   	 	$thumb_h 	= 136; // Define height
		   	 	$crop 		= true; //resize 
		   	 	$single 	= true; //return array
		   	 	
			    $args = array(
			        'post_type' => 'portfolio',
			        'orderby' => 'menu_order',
			        'order' => 'ASC',
			        'posts_per_page' => $number
			    );
			    $query = new WP_Query( $args );
			    
				while ( $query->have_posts() ) : $query->the_post(); ?> 
    								
				<article class="portfolio-item">
					<div class="post-thumb preload">
						<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" data-width="<?php echo $thumb_w; ?>" data-height="<?php echo $thumb_h; ?>">
							
						<?php $mediaType = get_post_meta(get_the_ID(), '_radium_portfolio_type', true);
						
						    switch ( $mediaType ) {
					                    
				                case "slideshow":
				                    radium_gallery( get_the_ID(), $thumb_w, $thumb_h, false, null );
				                    break;
				
				                case "video":
				                    $embed = get_post_meta(get_the_ID(), '_radium_portfolio_embed_code', true);
				                    if( !empty($embed) ) {
				                    	echo "<div class='video-frame'>";
				                        	echo stripslashes(htmlspecialchars_decode($embed));
				                        echo "</div>";
				                    } else {
				                        radium_video(get_the_ID());
				                    }
				                    break;
				
				                case "audio":
						                radium_audio(get_the_ID());
				                    break;
				
				                default: 
					                
					                //Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
					                if ( has_post_thumbnail() ) {
					                	
					                	//get featured image
					                    $thumb = get_post_thumbnail_id();
					                    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
					                  
					                } else {
					                
					                	$attachments = get_children(
					                        array(
					                        	'post_parent' => get_the_ID(), 
					                        	'post_type' => 'attachment', 
					                        	'post_mime_type' => 'image', 
					                        	'orderby' => 'menu_order'
					                        )
					                    );
					                    
					                    if ( ! is_array($attachments) ) continue;
					                    	$count = count($attachments);
					                    	$first_attachment = array_shift($attachments);
					                    
					                     $img_url = wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
						           }
					                
			                		$image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
			                		
			                		//fallback if all image urls are false
		                			if(empty($image)) $image = get_radium_first_post_image(true);
		                
		                		?>
									
								<img src="<?php echo $image ?>" alt="<?php the_title();?>"/>
					                 
							<?php break;
						
						} ?>
					<span class="post-thumb-overlay"><?php _e('View Portfolio', 'radium'); ?></span>
					<div class="stripes"></div>
				</a>
			</div>
			<h4>
				<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>">
					<?php the_title(); ?>
				</a>
			</h4>
        </article>
	        
       	<?php endwhile; ?>	
        <?php wp_reset_postdata(); ?>
        
    </div><!-- End Recent Portfolios Widget -->
	
	<?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = strip_tags( $new_instance['number'] );
	    $instance['desc'] = $new_instance['desc'];

		/* No need to strip tags for.. */

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
			'title' => 'Our Recent Works.',
			'desc' => '',
			'number' => 3
 		);
 		
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
 		<p><!-- Widget Title: Text Input -->
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>
 		
		<p><!-- Number Input: Text Input -->
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e('Number of Posts to Display:', 'radium') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" />
		</p>
		
        <p><!-- Description Input: Text Input -->
        	<label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php _e('Description:', 'radium') ?></label>
        	<textarea class="widefat" rows="6" cols="15" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>"><?php echo $instance['desc']; ?></textarea>
        </p>
	
	<?php
	}
}
?>
