<?php 

$framework = radium_framework();

$options = $framework->options;

/*-----------------------------------------------------------------------------------
	 Register widgetized areas
-----------------------------------------------------------------------------------*/
if ( function_exists('register_sidebar') ) {
    $allWidgetizedAreas = 
        array(
                __( 'Internal Sidebar', 'radium' ), //You can Add new Widget Areas here as an array
                __( 'Header Tools', 'radium'),
            );
            
    foreach ($allWidgetizedAreas as $WidgetAreaName) {
        register_sidebar(array(
           'name'=> $WidgetAreaName,
           'before_widget' => '<div id="%1$s" class="widget %2$s clearfix">',
           'after_widget' => '</div>',
           'before_title' => '<h4 class="widget-title"><span>',
           'after_title' => '</span></h4>',
        ));
    }
    
    
	// Footer widgetized area
	$footer_widget_count = null;
	$footer_widget_left_count = null;
	$footer_widget_right_count = null;
	$footer_layout = null;
 	
	if(isset($options['footer_layout']))
		$footer_layout = $options['footer_layout'];
	
	if ( $footer_layout == '50-25-25' ) {
				
		$footer_widget_left_count = 1;
		$footer_widget_right_count = 2; 
		 
		/* Dynamic Widget Areas */    
		for($i = 1; $i<= $footer_widget_left_count; $i++) {
		
			register_sidebar(array(
				'name' => __('Footer Widgets Left', 'radium'),
				'before_widget' => '<div class="footer_widget %2$s clearfix">',
				'after_widget' => '</div><!-- END "div.footer_widget" -->',
				'before_title' => '<h4>',
				'after_title' => '</h4>',
			));
		}
		
		/* Dynamic Widget Areas */    
		for($i = 1; $i<= $footer_widget_right_count; $i++) {
		
			register_sidebar(array(
				'name' => sprintf( __('Footer Widget Right %d', 'radium'), $i ),
				'before_widget' => '<div class="footer_widget %2$s clearfix">',
				'after_widget' => '</div><!-- END "div.footer_widget" -->',
				'before_title' => '<h4>',
				'after_title' => '</h4>',
			));
		}
		 
	} else {
			
			if ( $footer_layout == '100' ) { 
			
				$footer_widget_count = 1; 
				
			} elseif ( $footer_layout == '50-50' ) { 
			
				$footer_widget_count = 2; 
				
			} elseif ($footer_layout == '33-33-33' ) {
						 					
				$footer_widget_count = 3; 
				
			} elseif ($footer_layout == '25-25-25-25' ) {
						 					
				$footer_widget_count = 4; 
				
			}	
			 
			 /* Dynamic Widget Areas */    
		     for($i = 1; $i<= $footer_widget_count; $i++) {
		 
		         register_sidebar(array(
		             'name' => sprintf( __('Footer Widgets %d', 'radium'), $i ),
		             'before_widget' => '<div class="footer_widget %2$s">',
		             'after_widget' => '</div><!-- END "div.footer_widget" -->',
		             'before_title' => '<h4>',
		             'after_title' => '</h4>',
		         ));
		     }
	} 
	
	
}

/**
 * @uses unregister_widget() Unregisters a registered widget.
 * @link http://codex.wordpress.org/Function_Reference/unregister_widget
 */
function radium_unregister_widgets() {
	/* Unregister the default WordPress widgets. */
	//unregister_widget( 'WP_Widget_Recent_Posts' ); //We replaced this with more specific 
	//unregister_widget('WP_Widget_Pages'); //We've unregistered this and created a better one that also shows child pages
}
/* Unregister WP widgets. */
add_action( 'widgets_init', 'radium_unregister_widgets' );
?>
