<?php

/*-----------------------------------------------------------------------------------*/
/*	Button Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['button'] = array(
	'no_preview' => true,
	'params' => array(
		'url' => array(
			'std' => 'http://',
			'type' => 'text',
			'label' => __('Button URL:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'target' => array(
			'type' => 'select',
			'label' => __('Link Target:', 'radium'),
			'desc' => __('', 'radium'),
			'options' => array(
				'_self' => '_self (open in same window)',
				'_blank' => '_blank (open in new window)'
			)
		),
		
		'style' => array(
			'type' => 'select',
			'label' => __('Style:', 'radium'),
			'desc' => __('', 'radium'),
			'options' => array(
				' ' => 'Default',
				'white' => 'White',
				'grey' => 'Grey',
				'green' => 'Green',
				'blue' => 'Blue',
				'red' => 'Red',
				'orange' => 'Orange',
			)
		),
		
		'size' => array(
			'type' => 'select',
			'label' => __('Size:', 'radium'),
			'desc' => __('', 'radium'),
			'options' => array(
				'small' => 'Small',
				'medium' => 'Medium',
				'large' => 'Large'
			)
		),
		
		'type' => array(
			'type' => 'select',
			'label' => __('Type:', 'radium'),
			'desc' => __('', 'radium'),
			'options' => array(
				'round' => 'Round',
				'square' => 'Square'
			)
		),
		
		'icon' => array(
			'type' => 'text',
			'label' => __('Icon:', 'radium'),
			'desc' => __('eg: icon-download', 'radium'),
		),
		
				
		'content' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Button Text:', 'radium'),
			'desc' => __('', 'radium'),
			)
		),
	
	'shortcode' => '[button url="{{url}}" style="{{style}}" size="{{size}}" type="{{type}}" icon="{{icon}}" target="{{target}}"] {{content}} [/button]',
	'popup_title' => __('Button Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Alert Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['alert'] = array(
	'no_preview' => true,
	'params' => array(
		'style' => array(
			'type' => 'select',
			'label' => __('Alert Style:', 'radium'),
			'desc' => __('', 'radium'),
			'options' => array(
				'' => 'Default (Grey)',
				'note' => 'Note (Yellow)',
				'info' => 'Info (Blue)',
				'error' => 'Error (Red)',
				'success' => 'Success (Green)',
			)
		),
		'content' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Alert Text:', 'radium'),
			'desc' => __('', 'radium'),
		)
		
	),
	'shortcode' => '[alert style="{{style}}"] {{content}} [/alert]',
	'popup_title' => __('Alert Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Toggle Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['toggle'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium'),
			
		),
		'content' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Content:', 'radium'),
			'desc' => __('Add the toggle content. (HTML Accepted)', 'radium'),
		),
		'state' => array(
			'type' => 'select',
			'label' => __('Loading State:', 'radium'),
			'desc' => __('Select the state of the toggle on page load.', 'radium'),
			'options' => array(
				'open' => 'Open',
				'closed' => 'Closed'
			)
		),
		
	),
	'shortcode' => '[toggle title="{{title}}" state="{{state}}"] {{content}} [/toggle]',
	'popup_title' => __('Toggle Content Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Tabs Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['tabs'] = array(
    'params' => array(),
    'no_preview' => true,
    'shortcode' => '[tabs] {{child_shortcode}}  [/tabs]',
    'popup_title' => __('Tab Shortcode', 'radium'),
    
    'child_shortcode' => array(
        'params' => array(
            'title' => array(
                'std' => '',
                'type' => 'text',
                'label' => __('Title:', 'radium'),
                'desc' => __('', 'radium'),
            ),
            'content' => array(
                'std' => '',
                'type' => 'textarea',
                'label' => __('Tab Content:', 'radium'),
                'desc' => __('', 'radium')
            )
        ),
        'shortcode' => '[tab title="{{title}}"] {{content}} [/tab]',
        'clone_button' => __('Click to Add Another Tab', 'radium')
    )
);

/*-----------------------------------------------------------------------------------*/
/*	Columns Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['columns'] = array(
	'params' => array(),
	'shortcode' => ' {{child_shortcode}} ', // since there is no wrapper shortcode
	'popup_title' => __('Column Shortcodes', 'radium'),
	'no_preview' => true,
	
	// child shortcode is clonable & sortable
	'child_shortcode' => array(
		'params' => array(
			'column' => array(
				'type' => 'select',
				'label' => __('Column Size:', 'radium'),
				'desc' => __('', 'radium'),
				'options' => array(
					'one_third' => '1/3 &nbsp;&nbsp;&nbsp;&nbsp;One Third',
					'one_third_last' => '1/3L &nbsp;&nbsp;One Third Last',
					'two_third' => '2/3 &nbsp;&nbsp;&nbsp;&nbsp;Two Thirds',
					'two_third_last' => '2/3L &nbsp;&nbsp;Two Thirds Last',
					'one_half' => '1/2 &nbsp;&nbsp;&nbsp;&nbsp;One Half',
					'one_half_last' => '1/2L &nbsp;&nbsp;One Half Last',
					'one_fourth' => '1/4 &nbsp;&nbsp;&nbsp;&nbsp;One Fourth',
					'one_fourth_last' => '1/4L &nbsp;&nbsp;One Fourth Last',
					'three_fourth' => '3/4 &nbsp;&nbsp;&nbsp;&nbsp;Three Fourth',
					'three_fourth_last' => '3/4L &nbsp;&nbsp;Three Fourths Last',
					'one_fifth' => '1/5 &nbsp;&nbsp;&nbsp;&nbsp;One Fifth',
					'one_fifth_last' => '1/5L &nbsp;&nbsp;One Fifth Last',
					'two_fifth' => '2/5 &nbsp;&nbsp;&nbsp;&nbsp;Two Fifth',
					'two_fifth_last' => '2/5L &nbsp;&nbsp;Two Fifths Last',
					'three_fifth' => '3/5 &nbsp;&nbsp;&nbsp;&nbsp;Three Fifth',
					'three_fifth_last' => '3/5L &nbsp;&nbsp;Three Fifths Last',
					'four_fifth' => '4/5 &nbsp;&nbsp;&nbsp;&nbsp;Four Fifth',
					'four_fifth_last' => '4/5L &nbsp;&nbsp;Four Fifths Last',
					'one_sixth' => '1/6 &nbsp;&nbsp;&nbsp;&nbsp;One Sixth',
					'one_sixth_last' => '1/6L &nbsp;&nbsp;One Sixth Last',
					'five_sixth' => '5/6 &nbsp;&nbsp;&nbsp;&nbsp;Five Sixths',
					'five_sixth_last' => '5/6L &nbsp;&nbsp;Five Sixths Last'
				)
			),
			'content' => array(
				'std' => '',
				'type' => 'textarea',
				'label' => __('Column Content:', 'radium'),
				'desc' => __('', 'radium'),
			)
		),
		
		'shortcode' => '[{{column}}] {{content}} [/{{column}}] ',
		'clone_button' => __('Click to Add Another Column', 'radium')
	)
);

/*-----------------------------------------------------------------------------------*/
/*	Icon Boxes
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['icon'] = array(
	'params' => array(),
	'shortcode' => ' {{child_shortcode}} ', // as there is no wrapper shortcode
	'popup_title' => __('Icon Shortcodes', 'radium'),
	'no_preview' => true,
	
	// child shortcode is clonable & sortable
	'child_shortcode' => array(
		'params' => array(
			
			'title' => array(
				'type' => 'text',
				'label' => __('Title:', 'radium'),
				'desc' => __('', 'radium'),
				'std' => ''
			),
			
			'title_tag' => array(
				'type' => 'text',
				'label' => __('Title tag:', 'radium'),
				'desc' => __('ex: h1, h2, h3 etc', 'radium'),
				'std' => ''
			),
			
			'icon' => array(
				'type' => 'text',
				'label' => __('Icon:', 'radium'),
				'desc' => __('eg: icon-download', 'radium'),
			),
			
			'content' => array(
				'std' => '',
				'type' => 'textarea',
				'label' => __('Content:', 'radium'),
				'desc' => __('', 'radium'),
			)
		),
		'shortcode' => '[icon title_tag="{{title_tag}}" title="{{title}}" icon="{{icon}}"] {{content}} [/icon] ',
		'clone_button' => __('Click to Add Another Icon', 'radium')
	)
);


/*-----------------------------------------------------------------------------------*/
/*	Icon Boxes
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['iconbox'] = array(
	'params' => array(),
	'shortcode' => ' {{child_shortcode}} ', // as there is no wrapper shortcode
	'popup_title' => __('Icon Box Shortcodes', 'radium'),
	'no_preview' => true,
	
	// child shortcode is clonable & sortable
	'child_shortcode' => array(
		'params' => array(
			
			'title' => array(
				'type' => 'text',
				'label' => __('Title:', 'radium'),
				'desc' => __('', 'radium'),
				'std' => ''
			),

			'icon' => array(
				'type' => 'select',
				'label' => __('Select Icon:', 'radium'),
				'desc' => __('', 'radium'),
				'options' => array(
					'briefcase' => 'Briefcase',
					'briefcase-red' => 'Briefcase Red',
					'calendar' => 'Calendar',
					'clipboard' => 'Clipboard',
					'cloud' => 'Cloud',
					'code' => 'Code',
					'cog' => 'Cog',
					'files' => 'Files',
					'headphones' => 'Headphones',
					'folder' => 'Folder',
					'home' => 'Home',
					'mac' => 'Mac',
					'map' => 'Map',
					'minus' => 'Minus',
					'notebook' => 'Notebook',
					'notes' => 'Notes',
					'paper' => 'Paper',
					'pencil' => 'Pencil',
					'plus' => 'Plus',
					'settings' => 'Settings',
				)
			),
			
			'content' => array(
				'std' => '',
				'type' => 'textarea',
				'label' => __('Content:', 'radium'),
				'desc' => __('', 'radium'),
			)
		),
		'shortcode' => '[iconbox title="{{title}}" icon="{{icon}}"] {{content}} [/iconbox] ',
		'clone_button' => __('Click to Add Another Icon Box', 'radium')
	)
);


/*-----------------------------------------------------------------------------------*/
/*	Social Icons
/*-----------------------------------------------------------------------------------*/
$radium_shortcodes['social-icons'] = array(
	'no_preview' => true,
	'params' => array(
		'type' => array(
					'type' => 'select',
					'label' => __('Select Icon:', 'radium'),
					'desc' => __('', 'radium'),
					'options' => array(
						'behance' => 'Behance',
						'delicious' => 'Delicious',
						'digg' => 'Digg',
						'dribbble' => 'Dribbble',
						'facebook' => 'Facebook',
						'flickr' => 'Flickr',
						'forrst' => 'Forrst',
						'foursquare' => 'FourSquare',
						'github' => 'GitHub',
						'googleplus' => 'Google Plus',
						'Linkedin' => 'LinkedIn',
						'pinterest' => 'Pinterest',
						'reddit' => 'Reddit',
						'rss' => 'RSS',
						'stumbleupon' => 'StumbleUpon',
						'twitter' => 'Twitter',
						'vimeo' => 'Vimeo',
						'yelp' => 'Yelp',
						'youtube' => 'YouTube',
						'zerply' => 'Zerply',
						'youtube' => 'Youtube',
					)
				),
		
		'link' => array(
			'std' => 'http://',
			'type' => 'text',
			'label' => __('Icon URL:', 'radium'),
			'desc' => __('', 'radium')
		),
		'style' => array(
			'type' => 'select',
			'label' => __('Select Icon:', 'radium'),
			'desc' => __('', 'radium'),
			'std' => '',
			'options' => array(
				'style1' => 'Style1',
				'style2' => 'Style2',
				'style3' => 'Style3',
				'style4' => 'Style4',
			)
		),

	),
	
	'shortcode' => '[social-icon style="{{style}}" link="{{link}}" type="{{type}}"/]',
	'popup_title' => __('Social Media Icon Shortcodes', 'radium')
);


/*-----------------------------------------------------------------------------------*/
/*	Lists
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['lists'] = array(
	'no_preview' => true,
	'params' => array(
	
		'icon' => array(
			'type' => 'text',
			'label' => __('List Style:', 'radium'),
			'desc' => __('eg: icon-ok ', 'radium'),
		),
		
		'style' => array(
			'type' => 'select',
			'label' => __('Select Post Type:', 'radium'),
			'desc' => __('', 'radium'),
			'std' => '',
			'options' => array(
				'' => 'Default',
				'dark' => 'Dark',
			)
		),
		
		'content' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('List Content', 'radium'),
			'desc' => __('Enter your list here. <br>Example: (&lt;ul&gt;&lt;li&gt;some content &lt;/li&gt;&lt;/ul&gt;)', 'radium'),
		)
	),
	'shortcode' => '[list icon="{{icon}} {{style}}"] {{content}} [/list] ',
	'popup_title' => __('List Style Shortcodes', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Button Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['carousel'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
	
		'type' => array(
			'type' => 'select',
			'label' => __('Select Post Type:', 'radium'),
			'desc' => __('', 'radium'),
			'std' => '',
			'options' => array(
				'portfolio' => 'Portfolio',
 				'page' => 'Pages',
				'post' => 'Posts',
			)
		),
		'category' => array(
			'type' => 'text',
			'std' => '',
			'label' => __('Category:', 'radium'),
			'desc' => __('Comma separated categories to show', 'radium'),
			'options' => array( )
		),
		
	),
	
	'shortcode' => '[carousel title="{{title}}"  type="{{type}}" /]',
	'popup_title' => __('Carousel Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Call to Action
/*-----------------------------------------------------------------------------------*/
$radium_shortcodes['cta'] = array(
	'no_preview' => true,
	'params' => array(
		
		'tag_line' => array(
			'type' => 'text',
			'label' => __('Call to Action Text:', 'radium'),
			'desc' => __('', 'radium'),
			'std' => ''
		),
		
		'content' => array(
			'std' => 'Sign Up',
			'type' => 'text',
			'label' => __('Button Text:', 'radium'),
			'desc' => __('Add the button\'s text', 'radium'),
		),

		
		'url' => array(
			'std' => 'http://',
			'type' => 'text',
			'label' => __('Button URL:', 'radium'),
			'desc' => __('Add the icon\'s url eg http://example.com', 'radium')
		),
		
		'style' => array(
		'type' => 'select',
		'label' => __('Style:', 'radium'),
		'desc' => __('', 'radium'),
		'options' => array(
			' ' => 'Default',
			'light' => 'Light',
			)
		),
		
		
 	),
	
	'shortcode' => '[call_to_action tag_line="{{tag_line}}" button_text="{{content}}" style="{{style}}" link="{{url}}" /]',
	'popup_title' => __(' Call to Action Shortcode', 'radium')
);


/*-----------------------------------------------------------------------------------*/
/*	Slogan
/*-----------------------------------------------------------------------------------*/
$radium_shortcodes['slogan'] = array(
	'no_preview' => true,
	'params' => array(
		'content' => array(
			'std' => '#',
			'type' => 'text',
			'label' => __('Slogan Content:', 'radium'),
			'desc' => __('', 'radium')
		),
 
	 	'align' => array(
			'type' => 'select',
			'label' => __('Alignment:', 'radium'),
			'desc' => __(' ', 'radium'),
			'options' => array(
				'center' => 'Center',
				'left' => 'Left',
				'right' => 'Right'
			)
		),
		
	),	
	'shortcode' => '[slogan  align="{{align}}"] "{{content}}" [/slogan]',
	'popup_title' => __('Slogan Shortcode', 'radium')
);


/*-----------------------------------------------------------------------------------*/
/*	Google Map Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['gmap'] = array(
	'no_preview' => true,
	'params' => array(
		'address' => array(
			'std' => 'New York',
			'type' => 'text',
			'label' => __('Map Address:', 'radium'),
			'desc' => __('', 'radium')
		),
	
	 	'width' => array(
	 		'std' => '600',
			'type' => 'text',
			'label' => __('Width:', 'radium'),
			'desc' => __('Map width ', 'radium'),
		),
		
		'height' => array(
			'std' => '400',
			'type' => 'text',
			'label' => __('Width:', 'radium'),
			'desc' => __('Map width', 'radium'),
		),
		
		'zoom' => array(
			'std' => '14',
			'type' => 'text',
			'label' => __('Map Zoom:', 'radium'),
			'desc' => __('Use 1-19', 'radium'),
		),
		
		'html' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('HTML:', 'radium'),
			'desc' => __('What to show in the popup, defaults to address', 'radium'),
		),
		
		'popup' => array(
			'std' => '',
			'type' => 'select',
			'label' => __('HTML:', 'radium'),
			'desc' => __('Show or hide the popup, true or false', 'radium'),
			'options' => array(
				'true' => 'True',
				'false' => 'False',
			)
		),
		
		'maptype' => array(
			'std' => 'terrain',
			'type' => 'select',
			'label' => __('Type of map:', 'radium'),
			'desc' => __('Type of map - hybrid, satellite, roadmap, or terrain', 'radium'),
			'options' => array(
				'hybrid' => 'Hybrid',
				'satellite' => 'Satellite',
				'roadmap' => 'Roadmap',
				'terrain' => 'Terrain',
 			)
		),
	
	),	
	'shortcode' => '[map  address="{{address}}" width="{{width}}" height="{{height}}" zoom="{{zoom}}" html="{{html}}" popup="{{popup}}" maptype="{{maptype}}"]',
	'popup_title' => __('Google Map Shortcode', 'radium')
	
);

/*-----------------------------------------------------------------------------------*/
/*	Header Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['header'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
	
	 	'sub_title' => array(
	 		'std' => '',
			'type' => 'text',
			'label' => __('Subtitle text:', 'radium'),
			'desc' => __('', 'radium'),
		),
 	),	
	'shortcode' => '[header  title="{{title}}" sub_title="{{sub_title}}"]',
	'popup_title' => __('Header', 'radium')
	
);
 
 
/*-----------------------------------------------------------------------------------*/
/*	HR Link Config
/*-----------------------------------------------------------------------------------*

$radium_shortcodes['hr_link'] = array(
	'no_preview' => true,
	'params' => array(
		'link' => array(
			'std' => '#',
			'type' => 'text',
			'label' => __('Link:', 'radium'),
			'desc' => __('', 'radium')
		),
	
	 	'text' => array(
	 		'std' => '',
			'type' => 'text',
			'label' => __('text:', 'radium'),
			'desc' => __('Divider link text ', 'radium'),
		),
 	),	
	'shortcode' => '[hr  link="{{link}}" text="{{text}}"]',
	'popup_title' => __('Hr with link Shortcode', 'radium')
	
);
 

/*-----------------------------------------------------------------------------------*/
/*	Popup Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['popup'] = array(
	'no_preview' => true,
	'params' => array(
		'heading' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Heading:', 'radium'),
			'desc' => __('Modal Heading', 'radium')
		),
		
		'popup_link' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Popup Link:', 'radium'),
			'desc' => __('Html is allowed', 'radium'),
		),
 				
		'content' => array(
			'std' => '',
			'type' => 'textarea',
			'label' => __('Popup Content:', 'radium'),
			'desc' => __('Html is allowed', 'radium'),
			),
		
		'class' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Class:', 'radium'),
			'desc' => __('Add a class to the popup', 'radium'),
		),	
		),
	
	'shortcode' => '[popup heading="{{heading}}" popup_link="{{popup_link}}" class="{{class}}"] {{content}} [/popup]',
	'popup_title' => __('Popup Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Popup Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['teaser'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'url' => array(
			'std' => '#',
			'type' => 'text',
			'label' => __('Popup Link:', 'radium'),
			'desc' => __('', 'radium'),
		),
 		'src' => array(
 			'std' => '',
 			'type' => 'text',
 			'label' => __('Image Link:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
		'content' => array(
			'std' => 'learn more',
			'type' => 'text',
			'label' => __('Button text', 'radium'),
			'desc' => __('', 'radium'),
			),
	
		),
	
	'shortcode' => '[teaser title="{{title}}" url="{{url}}" src="{{src}}"] {{content}} [/teaser]',
	'popup_title' => __('Teaser Shortcode', 'radium')
);	

/*-----------------------------------------------------------------------------------*/
/*	Audio Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['audio'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'href' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Audio file url:', 'radium'),
			'desc' => __('File formats supported: mp3, m4a, fla, ogg, oga, webma, wma', 'radium'),
		),
 		'poster' => array(
 			'std' => '',
 			'type' => 'text',
 			'label' => __('Poster url:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
	
		),
	
	'shortcode' => '[audio href="{{href}}" poster="{{poster}}"] {{title}} [/audio]',
	'popup_title' => __('Teaser Shortcode', 'radium')
);	

/*-----------------------------------------------------------------------------------*/
/*	Video Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['video'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'href' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Video file url:', 'radium'),
			'desc' => __('File formats supported: m4v, mp4, flv, f4v, wmv, ogv, webmv', 'radium'),
		),
 		'poster' => array(
 			'std' => '',
 			'type' => 'text',
 			'label' => __('Poster url:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
	
		),
	
	'shortcode' => '[video href="{{href}}" poster="{{poster}}"] {{title}} [/video]',
	'popup_title' => __('Teaser Shortcode', 'radium')
);	

/*-----------------------------------------------------------------------------------*/
/*	Person/ team members Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['person'] = array(
	'no_preview' => true,
	'params' => array(
		'title' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Title:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'picture' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Image url:', 'radium'),
			'desc' => __('', 'radium'),
		),
 		'content' => array(
 			'std' => '',
 			'type' => 'textarea',
 			'label' => __('Content:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
	
		),
	
	'shortcode' => '[person picture="{{picture}}" title="{{title}}"  facebook="#" twitter="#" linkedin="#" dribbble="#"]{{content}}[/person]',
	'popup_title' => __('Person Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	percentage Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['progress'] = array(
	'no_preview' => true,
	'params' => array(
		'percentage' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Percentage:', 'radium'),
			'desc' => __('0-100', 'radium')
		),
	
 		'title' => array(
 			'std' => '',
 			'type' => 'text',
 			'label' => __('Title:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
	
		),
	
	'shortcode' => '[progress percentage="{{percentage}}" ] {{title}} [/progress]',
	'popup_title' => __('Progress Shortcode', 'radium')
);

/*-----------------------------------------------------------------------------------*/
/*	Testimonial Config
/*-----------------------------------------------------------------------------------*/

$radium_shortcodes['testimonial'] = array(
	'no_preview' => true,
	'params' => array(
		'by' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Name:', 'radium'),
			'desc' => __('', 'radium')
		),
		
		'from' => array(
			'std' => '',
			'type' => 'text',
			'label' => __('Company', 'radium'),
			'desc' => __('', 'radium'),
		),
 		'content' => array(
 			'std' => '',
 			'type' => 'textarea',
 			'label' => __('Message:', 'radium'),
 			'desc' => __('', 'radium'),
 		),		
	
		),
	
	'shortcode' => '[testimonial by="{{by}}" from="{{from}}"] {{content}} [/testimonial]',
	'popup_title' => __('Testimonial Shortcode', 'radium')
);		
?>
