<?php
/*-----------------------------------------------------------------------------------*
* Radium Image Resize Based on Aqua Resizer https://github.com/sy4mil/Aqua-Resizer

* Title		: Aqua Resizer
* Description	: Resizes WordPress images on the fly
* Version	: 1.1.6
* Author	: Syamil MJ
* Author URI	: http://aquagraphite.com
* License	: WTFPL - http://sam.zoy.org/wtfpl/
* Documentation	: https://github.com/sy4mil/Aqua-Resizer/
* 
* @param string $url - (required) must be uploaded using wp media uploader
* @param int $width - (required)
* @param int $height - (optional)
* @param bool $crop - (optional) default to soft crop
* @param bool $single - (optional) returns an array if false
* @uses wp_upload_dir()
* @uses image_resize_dimensions()
* @uses image_resize()
*
* @return str|array
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'radium_resize' ) ) {
	
	function radium_resize( $url, $width, $height = null, $crop = null, $single = true, $quality = 100, $retina = false ) {
			
		if ( $retina ) {
			
			$width = ($width * 2);
		
			$height = isset( $height ) ?  ($height * 2) : null;
		
		}
		
		//validate inputs
		if(!$url OR !$width ) return false;
		
		//define upload path & dir
		$upload_info = wp_upload_dir();
		$upload_dir = $upload_info['basedir'];
		$upload_url = $upload_info['baseurl'];
		
		//check if $img_url is local
		if(strpos( $url, $upload_url ) === false) return false;
		
		//define path of image
		$rel_path = str_replace( $upload_url, '', $url);
		$img_path = $upload_dir . $rel_path;
		
		//check if img path exists, and is an image indeed
		if( !file_exists($img_path) OR !getimagesize($img_path) ) return false;
		
		//get image info
		$info = pathinfo($img_path);
		$ext = $info['extension'];
		list($orig_w,$orig_h) = getimagesize($img_path);
		
		//get image size after cropping
		$dims = image_resize_dimensions($orig_w, $orig_h, $width, $height, $crop);
		$dst_w = $dims[4];
		$dst_h = $dims[5];
		
		//use this to check if cropped image already exists, so we can return that instead
		$suffix = "{$dst_w}x{$dst_h}";
		$dst_rel_path = str_replace( '.'.$ext, '', $rel_path);
		$destfilename = "{$upload_dir}{$dst_rel_path}-{$suffix}.{$ext}";
		
		if(!$dst_h) {
			//can't resize, so return original url
			$img_url = $url;
			$dst_w = $orig_w;
			$dst_h = $orig_h;
		}
		//else check if cache exists
		elseif(file_exists($destfilename) && getimagesize($destfilename)) {
			$img_url = "{$upload_url}{$dst_rel_path}-{$suffix}.{$ext}";
		} 
		//else, we resize the image and return the new resized image url
		else {
			
			// Note: This pre-3.5 fallback check will edited out in subsequent version
			if(function_exists('wp_get_image_editor')) {
			
				$editor = wp_get_image_editor($img_path);
				
				if ( is_wp_error( $editor ) || is_wp_error( $editor->resize( $width, $height, $crop ) ) )
					return false;
				
				if ( $quality  ) 
				$editor->set_quality($quality);
				$resized_file = $editor->save();
				
				if(!is_wp_error($resized_file)) {
					$resized_rel_path = str_replace( $upload_dir, '', $resized_file['path']);
					$img_url = $upload_url . $resized_rel_path;
				} else {
					return false;
				}
				
			} else {
			
				$resized_img_path = image_resize( $img_path, $width, $height, $crop ); // Fallback foo
				if(!is_wp_error($resized_img_path)) {
					$resized_rel_path = str_replace( $upload_dir, '', $resized_img_path);
					$img_url = $upload_url . $resized_rel_path;
				} else {
					return false;
				}
			
			}
			
		}
		
		//return the output
		if($single) {
			//str return
			$image = $img_url;
		} else {
			//array return
			$image = array (
				0 => $img_url,
				1 => $dst_w,
				2 => $dst_h
			);
		}
		
		return $image;
	}

}

/*
* Get First post image
*
* @param $fallback - set to true to show fallback image	
*/

function get_radium_first_post_image( $fallback = '' ) {

	global $post, $posts;
	
	$framework = radium_framework();
	
	$first_img = null;
	
	$args = array(
		'numberposts' => 1,
		'order'=> 'ASC',
		'orderby' => 'menu_order',
		'post_mime_type' => 'image',
		'post_parent' => $post->ID,
		'post_status' => null,
		'post_type' => 'attachment'
	);
	
	$attachments = get_children( $args );
	
	if ( $attachments ) {
		
 		$count = count($attachments);
		$first_attachment = array_shift($attachments);
		
		if ( $first_attachment )
	   		$first_img = @wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
		
		
	} else {
	
		ob_start();
		ob_end_clean();
		
		if ( preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches) ) {
			
			$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
			
			$first_img =  $matches[1][0];
		
		} else {
		
			$first_img = null;
			
		}
   		 
		if ( is_null($first_img) && $fallback ) //Defines a default image
			$first_img = $framework->theme_images_url . '/placeholder.gif';
		
	}
	
	
	return $first_img;
}

/*
* Get Featured image caption
*
* @param $type - what to show image title, caption, description or alt	
*
*/

function radium_get_the_featured_image_details( $type='caption') {
	
	global $post;
	
	$thumb_id = get_post_thumbnail_id($post->ID);
	
	$args = array(
		'post_type' => 'attachment',
		'post_status' => null,
		'post_parent' => $post->ID,
		'include'  => $thumb_id
	); 
	
	$thumbnail_image = get_posts($args);
	
	if ($thumbnail_image && isset($thumbnail_image[0])) {
	
		switch ( $type ) {
		
			case 'title':
				$output = $thumbnail_image[0]->post_title; 
				break;
				
			case 'description':
				$output = $thumbnail_image[0]->post_content; 
				break;
			
			case 'alt':
				$alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
				if(count($alt)) $output = $alt;
				break;
				
			default:	
				$output = $thumbnail_image[0]->post_excerpt; 
				break;
		}
		return $output;
	}
}

/*-----------------------------------------------------------------------------------*/
/* Create the Gallery with a Slider */
/*-----------------------------------------------------------------------------------*/
 
add_shortcode('wp_caption', 'fixed_img_caption_shortcode');
add_shortcode('caption', 'fixed_img_caption_shortcode');
function fixed_img_caption_shortcode($attr, $content = null) {
 
	if ( ! isset( $attr['caption'] ) ) {
		if ( preg_match( '#((?:<a [^>]+>\s*)?<img [^>]+>(?:\s*</a>)?)(.*)#is', $content, $matches ) ) {
			$content = $matches[1];
			$attr['caption'] = trim( $matches[2] );
		}
	}
	 
	$output = apply_filters('img_caption_shortcode', '', $attr, $content);
	
	if ( $output != '' )
		return $output;
	 
	extract(shortcode_atts(array(
		'id' => '',
		'align' => 'alignnone',
		'width' => '',
		'caption' => ''
	), $attr));
	 
	if ( 1 > (int) $width || empty($caption) )
		return $content;
	 
	if ( $id ) $id = 'id="' . esc_attr($id) . '" ';
	 
	return '<div ' . $id . 'class="wp-caption ' . esc_attr($align) . '" >'
	. do_shortcode( $content ) . '<p>' . $caption . '</p></div>';
}

// remove gallery shortcode styling
add_filter('gallery_style',
    create_function(
        '$css',
        'return preg_replace("#<style type=\'text/css\'>(.*?)</style>#s", "", $css);'
    )
);


if ( !function_exists( 'get_radium_gallery' ) ) {
    function get_radium_gallery( $postid, $image_w, $image_h = '', $crop = '', $meta_field = '' ) { 
          
    //validate inputs
    if(!$postid OR !$image_w ) return false;
     
    $slide_id = $postid; 	 
    $thumbid = 0;
    $output = null;
    
    if( $meta_field ) { 
    	
		$attachments = rwmb_meta( $meta_field, 'type=image' );
     	
     	if ( is_array( $attachments ) ) {
     		
	     	$output .='<!-- BEGIN #slider-'.$postid.' -->
	     		<div class="slider-wrapper">
	     			<div class="post-slider">
	     				 <div id="slider-'.$postid.'">';
	     			     	$output .='<ul class="slides">';
					          $i = 0;
					          foreach( $attachments as $image ) {
					              
					              $src = $image['full_url'];
						          $image = radium_resize( $src, $image_w, $image_h, $crop ); //resize & crop the image
					              
					              $caption = null;
					              $caption = ($caption) ? "<div class='slider-desc'><span class='gallery-caption'>$caption</span></div>" : '';
					              $alt = null;
					              $output .='<li>'.$caption.'<img height="'.$image_h.'" width="'.$image_w.'" src="'.$image.'" alt="'.$alt.'" /></li>';
					             
					              $i++;
					          }
	     					$output .='</ul>';
	     			      		
	     	$output .='</div></div></div><!-- END #slider-'.$postid.' -->';
    	
    	}
    	 	
    } else {
     
	    // get the featured image for the post
	    if( has_post_thumbnail($postid) ) {
	        $thumbid = get_post_thumbnail_id($postid);
	    }
	    
	    //Create Exclusion array
	    $exclude_images = array();
	    $bg_images = get_post_meta( $postid, '_radium_bgimage', false );
	    foreach ( $bg_images as $att ) {
	    	$exclude_images[]=$att;
	     }
		
		// get all of the attachments for the post
		$args = array(
		  'orderby' => 'menu_order',
		  'post_type' => 'attachment',
		  'post_parent' => $postid,
		  'exclude' => $exclude_images, 
		  'post_mime_type' => 'image',
		  'post_status' => null,
		  'numberposts' => -1
		);
		
		$attachments = get_posts($args);
	
		if( !empty($attachments) ) {
							
	      $output .='<!-- BEGIN #slider-'.$postid.' -->
			<div class="slider-wrapper">
				<div class="post-slider post-slider-'.$postid.'">
					 <div id="slider-'.$postid.'" class="loading">';
				            $output .='
		          		    <ul class="slides">';
						          $i = 0;
						          foreach( $attachments as $attachment ) {
						              if( $attachment->ID == $thumbid ) continue;
						              
						              $src = wp_get_attachment_image_src( $attachment->ID, 'full' );
							          $image = radium_resize( $src[0], $image_w, $image_h, $crop ); //resize & crop the image
						              
						              $caption = $attachment->post_excerpt;
						              $caption = ($caption) ? "<div class='slider-desc'><span class='gallery-caption'>$caption</span></div>" : '';
						              $alt = ( !empty($attachment->post_content) ) ? $attachment->post_content : $attachment->post_title;
						              $output .='<li>'.$caption.'<img height="'.$image_h.'" width="'.$image_w.'" src="'.$image.'" alt="'.$alt.'" /></li>';
						             
						              $i++;
						          }
				$output .='</ul>';
				      		
				$output .='</div>
						</div>
					</div><!-- END #slider-'.$postid.' -->';
			 }
		 
		 }
		 if ( is_singular() ) {

		 $auto_height = '	
		 start: function(slider) {
		 	    var $new_height = slider.slides.eq(0).height();     
		 	    slider.height($new_height);
		 	},
		 	before: function(slider) {
		 	    var $new_height = slider.slides.eq(slider.animatingTo).height();                
		 	    if($new_height != slider.height()){
		 	        slider.animate({ height: $new_height  }, 300);
		 	    }
		 	},';
		 
		 } else {
		 
		 	$auto_height = '';
		 
		 }
		 
		 $output .='<script type="text/javascript">
		 	jQuery(document).ready(function(){
		 		jQuery("#slider-'.$postid.'").flexslider({
		 			controlsContainer: ".post-slider-'.$postid.'",
		 			slideDirection: "horizontal",
		 			animation: "slide",
		 			slideshow: true,
		 			pauseOnHover: true,
		 			slideshowSpeed: 7000, 
		 			animationDuration: 600,
		 			controlNav: false,
		 			directionNav: true,'.$auto_height.'
		 		});
		 		jQuery("#slider-'.$postid.'").css({ display : "block" });
		 		jQuery("#slider-'.$postid.'").addClass("loaded").removeClass("loading");
		 	});
		 </script>';
		 
		 return $output;
	}
}

/*-----------------------------------------------------------------------------------*/
/*	Echo Gallery
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'radium_gallery' ) ) {
    function radium_gallery($postid, $image_w, $image_h='', $crop = '', $meta_field ='' ) { 
    	echo get_radium_gallery( $postid, $image_w, $image_h, $crop, $meta_field );
    }
}
  
/*-----------------------------------------------------------------------------------*/
/*	Output Audio
/*-----------------------------------------------------------------------------------*/

if ( !function_exists( 'get_radium_audio' ) ) {

	function get_radium_audio( $postid, $audio_file_url = '', $poster = '' ) {
	  	
	  	$framework = radium_framework();
	  	
		$output = null;
		
		if ( $audio_file_url ) {
 			
 			$postid = rand( 1, 10000); //create a random id 
		
		} else {
		
			$audio_file_url = get_post_meta( $postid, '_radium_audio_file', true );
 		
 		}
 		
		if( filter_var( $audio_file_url, FILTER_VALIDATE_URL ) ) {
			switch( pathinfo( $audio_file_url, PATHINFO_EXTENSION ) ) {
				case 'mp3':  //mp3
					$media = "mp3: '$audio_file_url'";
					$supplied = 'supplied: "mp3",';
						break;
				case 'm4a':  //mp4
					$media = "m4a: '$audio_file_url'";
					$supplied = 'supplied: "m4a, mp3",';
					break;
				case 'ogg': //ogg
					$media = "oga: '$audio_file_url'";
					$supplied = 'supplied: "oga, ogg, mp3",';
						break;
				case 'oga': //oga
					$media = "oga: '$audio_file_url'";
					$supplied = 'supplied: "oga, ogg, mp3",';
					break;
				case 'webma': //webma
					$media = "webma: '$audio_file_url'";
					$supplied = 'supplied: "webma, mp3",';	
					break;
				case 'webm': //webma
					$media = "webma: '$audio_file_url'";
					$supplied = 'supplied: "webma, mp3",';	
					break;
				case 'wav':
					$media = "wav: '$audio_file_url'";
					$supplied = 'supplied: "wav, mp3",';	
					break;
				default:
					// audio format not supported 
					return;
					break;
			}
		}
		
		if( $audio_file_url):
		 		
		$output .='<script type="text/javascript">';
		
		$output .='jQuery(document).ready(function(){';
		
		$output .='if(jQuery().jPlayer) {';
		
		$output .='jQuery("#jquery_jplayer_'.$postid.'").jPlayer( {'; 
		
		$output .='ready : function () {'; 
		
		$output .='jQuery(this).jPlayer("setMedia", {';
		
		$output .= $media .',';
		
		if($poster != '') $output .='poster: "'. $poster.'",';
		
		$output .='end: "" }); },';
		
		$output .='play: function() { jQuery(this).jPlayer("pauseOthers"); },';
		
		if( !empty($poster) ) $output .='size: { width: "100%", height: "100%" },';
		
		$output .='swfPath: "'.$framework->theme_js_url.'/",';
		
		$output .='cssSelectorAncestor: "#jp_container_'.$postid.'",';
		
		$output .= $supplied;
		
		$output .='solution: "html, flash",';
		
		$output .='preload: "metadata",';
		
		$output .='wmode: "window",';
		
		$output .='});';
		
		$output .='}';
		
		$output .='jQuery("#jp_container_'.$postid.' .jp-interface").css("display", "block");';
		
		$output .='});';
		
		$output .='</script>';
		
		$output .='<style>';
		
		$output .='/* Fix Jplayer Height if no poster is uploaded */';
		
		if( empty($poster) ) {
			$output .='#jp_container_'.$postid.'.jp-audio.fullwidth {';
  			$output .='padding-bottom: 1px !important;';
 			$output .='margin-bottom: 20px !important;';
 			$output .='height: 40px;';
			$output .='}';
		}
		
 		$output .='</style>';
 		
		$output .='<div id="jp_container_'.$postid.'" class="jp-audio fullwidth">';
	
		$output .='<div class="jp-type-single">';
		
		$output .='<div id="jquery_jplayer_'.$postid.'" class="jp-jplayer"></div>';
		
		$output .='<div class="jp-gui">';
			
		$output .='<div class="jp-audio-play"><a href="javascript:;" tabindex="1" title="Play"></a></div>';
				
		$output .='<div class="jp-interface" style="display: none;">';
		
		$output .='<div class="jp-progress">';
		$output .='<div class="jp-seek-bar">';
		$output .='<div class="jp-play-bar"></div>';
		$output .='</div>';
		$output .='</div>';
		$output .='<div class="jp-duration"></div>';
		$output .='<div class="jp-time-sep">/</div>';
		$output .='<div class="jp-current-time"></div>';
		$output .='<div class="jp-controls-holder">';
		$output .='<ul class="jp-controls">';
		$output .='<li><a href="javascript:;" class="jp-play" tabindex="1" title="Play"><span>Play</span></a></li>';
		$output .='<li><a href="javascript:;" class="jp-pause" tabindex="1" title="Pause"><span>Pause</span></a></li>';
		$output .='<li class="li-jp-stop"><a href="javascript:;" class="jp-stop" tabindex="1" title="Stop"><span>Stop</span></a></li>';
		$output .='</ul>';
		$output .='<div class="jp-volume-bar">';
		$output .='<div class="jp-volume-bar-value"></div>';
		$output .='</div>';
		$output .='<ul class="jp-toggles">';
		$output .='<li><a href="javascript:;" class="jp-mute" tabindex="1" title="Mute"><span>Mute</span></a></li>';
		$output .='<li><a href="javascript:;" class="jp-unmute" tabindex="1" title="Unmute"><span>Unmute</span></a></li>';
		$output .='</ul>';
		$output .='<div class="jp-title"><ul><li></li></ul></div>';
		$output .='</div>';
		$output .='</div>';
		$output .='<div class="jp-no-solution">';
	$output .= __('<span>Update Required</span>To play the audio you will need to either update your browser to a recent version or update your <a href="http://get.adobe.com/flashplayer/" target="_blank">Flash plugin</a>.','radium');
	$output .='</div>';
	$output .='</div>';
	$output .='</div>';
	$output .='</div>';
	
	endif;
	
	return radium_code_compress( $output );
	}
}

if ( !function_exists( 'radium_audio' ) ) {

	function radium_audio($postid, $audio_file_url = '', $poster = '' ) { 
		echo get_radium_audio($postid, $audio_file_url, $poster );
	}
	
}

/*-----------------------------------------------------------------------------------*/
/* Output video */
/*-----------------------------------------------------------------------------------*/
if ( !function_exists( 'get_radium_video' ) ) {

	function get_radium_video( $postid, $video_file_url = '', $poster = '', $height = '' ) {

	  	$framework = radium_framework();

		$output = null;
				
		if ( $video_file_url ) {
				
				$postid = rand( 1, 10000); //create a random id 
		
		} else {
		
			$video_file_url = get_post_meta( $postid, '_radium_video_file', true );
							
			//$width = get_post_meta($postid, '_radium_video_width', true);
			$height = get_post_meta($postid, '_radium_video_height', true);
			$poster = get_post_meta($postid, '_radium_video_poster', true);
		
		}

		if( filter_var( $video_file_url, FILTER_VALIDATE_URL ) ) {
			switch( pathinfo( $video_file_url, PATHINFO_EXTENSION ) ) {
			
				case 'mp4':  //mp3
					$media = "mp4: '$video_file_url'";
					$supplied = 'supplied: "mp4, all"';
						break;
				case 'm4v':  //mp4
					$media = "m4v: '$video_file_url'";
					$supplied = 'supplied: "m4v, all",';
					break;
				case 'flv': //flv
					$media = "flv: '$video_file_url'";
					$supplied = 'supplied: "flv, all",';
						break;	
				case 'f4v': //f4v
					$media = "f4v: '$video_file_url'";
					$supplied = 'supplied: "f4v, all",';
						break;			
				case 'ogg': //ogg
					$media = "oga: '$video_file_url'";
					$supplied = 'supplied: "oga, ogg, mp3",';
						break;
				case 'ogv': //oga
					$media = "ogv: '$video_file_url'";
					$supplied = 'supplied: "ogv, all",';
					break;
				case 'webmv': //webmv
					$media = "webmv: '$video_file_url'";
					$supplied = 'supplied: "webmv, all",';	
					break;
				case 'wmv':
					$media = "wmv: '$video_file_url'";
					$supplied = 'supplied: "wmv, all",';	
					break;
				default:
					// audio format not supported 
					return;
					break;
			}
		}

	 	if( $video_file_url ):
	 	 
	 	$output .= '<script type="text/javascript">'; 
	 		
	 	$output .= 'jQuery(document).ready(function() {'; 
	 		
	 	$output .= 'jQuery("#jquery_jplayer_'.$postid.'").jPlayer( { ready : function() {';
	 	
	 	$output .= 'jQuery(this).jPlayer( "setMedia", {';
	 	
	 	$output .= $media .',';
	 					
		if ($poster != '') $output .= 'poster: "'.$poster.'"';
		$output .='}';
	 	$output .=');';
	 	$output .='},';
	 					 
		$output .= 'cssSelectorAncestor : "#jp_container_'.$postid.'",'; 
		
		$output .='swfPath: "'.$framework->theme_js_url.'/",';
		
		$output .= $supplied;
		
		$output .= 'size : {';
	 	$output .= 'width : "100%",';
	 	$output .= 'height : "100%"';
	 	$output .= '},';
	 	$output .= 'wmode : "window"';
	 	$output .= '}';
	 	$output .= ');';
	 			
	 	$output .= 'jQuery("#jp_container_'.$postid.' .jp-interface").css("display", "block");';
	 			 
	 	$output .= '});'; 
	 		
	 	$output .= '</script>';
	 	
		$output .='<div id="jp_container_'.$postid.'" class="jp-video fullwidth">';
		$output .='<div class="jp-type-single">';
		$output .='<div id="jquery_jplayer_'.$postid.'" class="jp-jplayer"></div>';
		$output .='<div class="jp-gui">';
		$output .='<div class="jp-video-play"><a href="javascript:;" class="jp-video-play-icon" tabindex="1" title="Play">Play</a></div>';
		$output .='<div class="jp-interface" style="display: none;">';
		$output .='<div class="jp-progress">';
		$output .='<div class="jp-seek-bar">';
		$output .='<div class="jp-play-bar"></div>';
		$output .='</div>';
		$output .='</div>';
		$output .='<div class="jp-duration"></div>';
		$output .='<div class="jp-time-sep">/</div>';
		$output .='<div class="jp-current-time"></div>';
		$output .='<div class="jp-controls-holder">';
		$output .='<ul class="jp-controls">';
		$output .='<li><a href="javascript:;" class="jp-play" tabindex="1" title="Play"><span>Play</span></a></li>';
		$output .='<li><a href="javascript:;" class="jp-pause" tabindex="1" title="Pause"><span>Pause</span></a></li>';
		$output .='<li class="li-jp-stop"><a href="javascript:;" class="jp-stop" tabindex="1" title="Stop"><span>Stop</span></a></li>';
		$output .='</ul>';
		$output .='<div class="jp-volume-bar">';
		$output .='<div class="jp-volume-bar-value"></div>';
		$output .='</div>';
		$output .='<ul class="jp-toggles">';
		$output .='<li><a href="javascript:;" class="jp-mute" tabindex="1" title="Mute"><span>Mute</span></a></li>';
		$output .='<li><a href="javascript:;" class="jp-unmute" tabindex="1" title="Unmute"><span>Unmute</span></a></li>';
		$output .='<li class="li-jp-full-screen"><a href="javascript:;" class="jp-full-screen" tabindex="1" title="Full Screen"><span>Full Screen</span></a></li>';
		$output .='<li class="li-jp-restore-screen"><a href="javascript:;" class="jp-restore-screen" tabindex="1" title="Restore Screen"><span>Restore Screen</span></a></li>';
		$output .='</ul>';
		$output .='<div class="jp-title">';
		$output .='<ul>';
		$output .='<li></li>';
		$output .='</ul>';
		$output .='</div>';
		$output .='</div>';
		$output .='</div>';
		$output .='<div class="jp-no-solution">';
		$output .= __('<span>Update Required</span>To play the video you will need to either update your browser to a recent version or update your <a href="http://get.adobe.com/flashplayer/" target="_blank">Flash plugin</a>.','radium');
		$output .= '</div>';
		$output .='</div>';
		$output .='</div>';
		$output .='</div>';
	 	
	 	endif;
	 	
	 	return $output;
	  }
}

if ( !function_exists( 'radium_video' ) ) {

	function radium_video($postid, $video_file_url = '', $poster = '', $height = ''  ) { 
		echo get_radium_video($postid, $video_file_url, $poster, $height  );
	}
	
}


//allow new file uploads
add_filter('upload_mimes','radium_upload_mimes');
if(!function_exists('radium_upload_mimes')) {
	function radium_upload_mimes($mimes){ 
		return array_merge($mimes, 
			array (
				'mp4' 	=> 'video/mp4', 
				'ogv' 	=> 'video/ogg', 
				'webm' 	=> 'video/webm',
				'ico' 	=> 'image/ico',
				'mpa' 	=> 'audio/mpa', 
				'oga' 	=> 'audio/ogg', 
				'wma' 	=> 'audio/wma',
				'wav'	=> 'audio/wav',
 			)
		); 
	}
} 
