<?php

/*
 * Radium Framework Core - A WordPress theme development framework.
 * 
 * This file is a part of the RadiumFramework core.
 * Please be extremely cautious editing this file. 
 * Modifying the contents of this file can be a poor life decision if you don't know what you're doing.
 * 
 * @category RadiumFramework
 * @package  Singleton WP
 * @author   Franklin M Gitonga
 * @link     http://radiumthemes.com/
 */

/**
 * This file contains the portfolio template. 
 * It's been placed here so that it can be reused easily throughout the framework
 * 
 * @since 2.1.0
 *
 * @param array $options all options for posts
 * @param string $type Type of posts, grid or list
 * @param string $current_location Current location of element, featured or primary
 */

if( ! function_exists( 'radium_builder_portfolio' ) ) {
	function radium_builder_portfolio( $type, $options, $location, $radium_sidebar_location = 'none') {
	
	global $post;
		
	//Get Global Page Settings
	$page_items 			= isset($options['posts_per_page']) 	? $page_items = $options['posts_per_page'] 	: $page_items = -1;
	$page_columns 			= isset($options['ctp_page_columns']) 	? $options['ctp_page_columns'] 				: 'three-columns';
	$page_show_pagination 	= isset($options['cpt_pagination']) 	? $options['cpt_pagination'] 				: 1;
	 
	//Pagination Loader
	if ( get_query_var('paged') )
	    $paged = get_query_var('paged');
	else if ( get_query_var('page') )
	    $paged = get_query_var('page'); // This provides compatibility with static frontpage
	else
	    $paged = 1;
	     
	$orderby 		= isset($options['orderby']) ? $options['orderby'] : 'menu_order';
	$order 			= isset($options['order']) ? $options['order'] :'ASC';
	 
	//Load Query
	$args = array(
	    'post_type' 		=> 'portfolio',
	    'orderby' 			=> $orderby,
	    'order' 			=> $order,
	    'posts_per_page' 	=> $page_items,
	    'paged' 			=> $paged	                 
	); 
	  	
	if( ! $options['portfolio_categories']['all'] ) {
		unset( $options['portfolio_categories']['all'] );
		$categories = '';
		foreach( $options['portfolio_categories'] as $category => $include ) {
			if( $include ) {
				$categories .= $category.',';
			}
		}
		if( $categories ) {
		
			$categories = radium_remove_trailing_char( $categories, $char = ',' );
			
			$args = array_merge( $args, array( 'portfolio_category' => esc_attr( $categories ) ) );
			
 		}
	}          
 
	//Check if sidebar is active
	if ( $radium_sidebar_location  == 'none' || $radium_sidebar_location  == '' ) { $sidebar_check = "fullwidth"; } else { $sidebar_check = ";"; }
	 
	//Check number of columns, set column class and thumb sizes
	 
	if ( $page_columns == 'four-columns') { 
	
		$page_columns = 'four-columns';
		$thumb_w = 220; //Define width
		$thumb_h = 138; // Define height
	
	} elseif ( $page_columns == 'three-columns') { 
	
		$page_columns = 'three-columns';
		$thumb_w = 300; //Define width
		$thumb_h = 150; // Define height
		
	}  elseif ( $page_columns == 'one-columns') {
	 
		$page_columns = 'one-column'; 
		$thumb_w = 460; //Define width
		$thumb_h = 200; // Define height
	
	} else {
	 
		$page_columns = 'two-columns'; 
		$thumb_w = 460; //Define width
		$thumb_h = 240; // Define height
	
	}  
	 
	 $crop 	= true; //resize but retain proportions
	 $single = true; //return array
	 
	 //before content action hook 
	 do_action('radium_before_portfolio_template_content'); ?>
	 
	 <div id="template-main" class="<?php echo $radium_content_class; ?> clearfix page-portfolio" role="main">
	     
	 	<div class="entry-content">
	 		<?php get_the_content(); ?>
	 	</div>
	 	
	 	<?php if ( $options['nav_filter'] ) { ?>
	 		<div class="row">
 				<div id="filter-wrapper" class="twelve columns clearfix">
					<p id="filter-title"><a href="#" class="filter-btn"><i class="icon"><span class="icon-reorder"></span></i></a></p>
 					
 					 <div class="section-container" id="filter-section" style="display: none;">
 						<nav class="nav-hori" id="nav-sub">
 							<ul id="filters" class="clearfix">
 							    <li><a href="#all" data-filter="page-grid-item" class="active"><?php _e('View All', 'radium'); ?></a></li>
 							    <?php 
 							        wp_list_categories( array(
 							            'title_li' => '', 
 							            'taxonomy' => 'portfolio_category', 
 							            'walker' => new Portfolio_Walker() )
 							        ); 
 							    ?>
 							</ul>
 						</nav>
 					</div>
 				</div>
 			</div>
	     <?php } ?>
	     <section>
	 	    <div id="stage" class="isotope clearfix <?php echo $sidebar_check; ?>">
	 	    
	             <?php
	               
	            query_posts( $args );
	            
	            if ( have_posts() ) : while ( have_posts() ) : the_post(); 
	  	    	        
	 	    	    //Generate portfolio terms list (required by portfolio sorter)
	 	    	    $terms =  get_the_terms( $post->ID, 'portfolio_category' ); 
	 	    	    $term_list = null;
	 	    	    if( is_array($terms) ) {
	 	    	        foreach( $terms as $term ) {
	 	    	            $term_list .= $term->slug;
	 	    	            $term_list .= ' ';
	 	    	        }
	 	    	    } 
	 	    	    
	 	    		?>
	 	    					
	 	    		<article id="post-<?php the_ID(); ?>" <?php post_class("$term_list isotope-item page-grid-item $page_columns"); ?> >
	 	    			
	 	    			<div class="portfolio-thumb grid-thumb preload <?php if( $page_columns == 'one-column'){ ?> six columns <?php } ?>">
	 	    			
	 	    				<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" data-width="<?php echo $thumb_w; ?>" data-height="<?php echo $thumb_h; ?>">
	 	    				
	 	    				<?php 
	 	    				
	 		                //Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
	 		                if ( has_post_thumbnail() ) {
	 		                	
	 		                	//get featured image
	 		                    $thumb = get_post_thumbnail_id();
	 		                    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
	 		                  
	 		                } else {
	 		                
	 		                	$attachments = get_children(
	 		                        array(
	 		                        	'post_parent' => get_the_ID(), 
	 		                        	'post_type' => 'attachment', 
	 		                        	'post_mime_type' => 'image', 
	 		                        	'orderby' => 'menu_order'
	 		                        )
	 		                    );
	 		                    
	 		                    if ( ! is_array($attachments) ) continue;
	 		                    	$count = count($attachments);
	 		                    	$first_attachment = array_shift($attachments);
	 		                    
	 		                     $img_url = @wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
	 		                
	 		                }
	 
	 		                $image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
	 		            
	 		                //add thumbnail fallback
	 		               if(empty($image)) $image = get_radium_first_post_image(true);
	 	    				
	 						$mediaType = get_post_meta($post->ID, '_radium_portfolio_type', true);
	 					
	 					    switch ( $mediaType ) {
	  			                    
	 			                case "slideshow":
	 			                    radium_gallery( $post->ID, $thumb_w, $thumb_h, true, null );
	 			                    break;
	 			
	 			             	case "video":
	 			                    $embed = get_post_meta($post->ID, '_radium_portfolio_embed_code', true);
	 			                    if( !empty($embed) ) {
	 			                    	echo "<div class='video-frame'>";
	 			                        	echo stripslashes(htmlspecialchars_decode($embed));
	 			                        echo "</div>";
	 			                    } else {
	  								?>	
	  									<img src="<?php echo $image ?>" alt="<?php the_title();?>"/>
	 			                        
	 			                    <?php 
	 			                    
	 			                    } 
	 			                    break;
	 			
	 			                default: ?>
	 			                 
	 			                 	<img src="<?php echo $image ?>" alt="<?php the_title();?>"/>
	 			                 
	 			              <?php  break;
	 						}	
	   	    				
	 	    				?>
	 	    					<span class="post-thumb-overlay"><?php _e('View Post', 'radium'); ?></span>
	 	    					<div class="stripes"></div>
	    	    				</a>
	 	    			</div>
	 	    			
	  	   				<?php if ( $page_columns == 'one-column' ) { ?>
	  	   					<div class="one-column-content six columns">
	  	   						<h2><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
	  	   						<?php the_excerpt(); ?>
	  	   					</div>
	  	   				<?php } else { ?>
	  	   				
	  	   						<h4><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
 	  	   					
	  	   				<?php } ?>	
	  	   					
	  	   				<?php if( $page_columns == 'one-column'){ ?><div class="hr clearfix"></div><?php } ?>
	 	   					
	  	    		</article>
	 	    		
	     			<?php endwhile; endif; ?>				
	 			<div class="clearfix"></div>
	 		</div>
	 		
	 		<?php
				 		
	 		//before content action hook 
	 		do_action('radium_after_portfolio_template_content');
	 		
	 		if ( $page_show_pagination  ) 
				echo radium_theme_pagination();

			 wp_reset_query(); 
			?>
	 		
	     </section>
	 	</div>
	 		
	 <?php 
 	}
}
add_action('radium_builder_portfolio', 'radium_builder_portfolio', 10, 3);