<?php 

/**
 * Display slogan.
 *
 * @since 2.1.0
 *
 * @param array $options all options for slogan
 * @return string $output HTML output for slogan
 */

if( ! function_exists( 'radium_builder_slogan_element' ) ) {
	function radium_builder_slogan_element( $id, $settings, $location ) {
 		
		$align = $settings['align'];
		
		echo '<div class="slogan ' . ( $align ? 'align-' . esc_attr( $align ) : '' )  . '">' . do_shortcode(  stripslashes( $settings['slogan'] )  ) . '</div>';
		
	}	
}
add_action('radium_builder_slogan', 'radium_builder_slogan_element', 10, 3);