<?php

/**
 * Display featured.
 *
 * @since 2.1.0
 *
 * @param array $options Options for featured
 * @return string $output HTML output for featured
 */

if( ! function_exists( 'radium_builder_featured_element' ) ) {
	function radium_builder_featured_element( $id, $settings, $location  ) { ?>
		<div class="featured-area <?php if ( $settings['featured_style'] || $settings['featured_color'] ) echo 'custom-style '; echo $settings['featured_style']; echo ' '.$settings['featured_color']; ?> align-<?php echo $settings['featured_alignment']; ?>" style="background-image: url('<?php if ( $settings['featured_content_image'] ) { echo $settings['featured_content_image']; } ?>');">
			<div class="feature-content">	
			<?php
				$output = apply_filters( 'builder_featured_area', stripslashes( $settings['featured_content'] ) );
				echo do_shortcode($output);
			?>
			</div>
		</div>
		
		<?php
	}
}
add_action('radium_builder_featured', 'radium_builder_featured_element', 10, 3);