<?php
/** 
 * Register Cta Element
 * @return array();
 */
function radium_builider_registar_cta_element( $elements ) {
	
	//Cta
	$element_cta = array(
		array(
			'name' 		=> 'Call to Action',
	    	'type'		=> 'subgroup_start',
	    	'class'		=> 'cta',
	    ),

		array(
			'name' => __('Call to Action Text:', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_text',
			'std' => '',
			'type' => 'text',
		),
		
		array(
			'name' => __('Button Text:', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_button_text',
			'std' => '',
			'type' => 'text',
		),
		
		array(
			'name' => __('Button Icon:', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_button_icon',
			'std' => '',
			'type' => 'text',
		),
		
		
		array(
			'name' => __('Button URL:', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_button_url',
			'std' => '',
			'type' => 'text',
		),
		
		array(
			'name' => __('Style', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_style',
			'std' => '',
			'type' => 'select',
			'options'	=> array(
				'default' 	=> __( 'Default', 'radium' ),
			    'light' 	=> __( 'Light', 'radium' ),
			    'dark' 	=> __( 'Dark', 'radium' ),
			),
		),	
		
		array(
			'name' => __('Button Color', 'radium'),
			'desc' => __('', 'radium'),
			'id' => 'cta_button_style',
			'std' => '',
			'type' => 'select',
			'options'	=> array(
				'' 			=> __( 'Default', 'radium' ),
			    'blue' 		=> __( 'Blue', 'radium' ),
			    'green' 	=> __( 'Green', 'radium' ),
			    'red' 		=> __( 'Red', 'radium' ),
			    'orange' 	=> __( 'Orange', 'radium' ),
			    'grey' 		=> __( 'Grey', 'radium' ),
			),
		),	
		array(
	    	'type'		=> 'subgroup_end'
	    )
	);
	
	$elements['cta'] = array(
		'info' => array(
			'name' 	=> 'Call to Action',
			'id'	=> 'cta',
			'query'	=> 'none',
			'hook'	=> 'radium_cta',
			'shortcode'	=> '[cta]',
			'desc' 	=> __( 'Set of tabbed content', 'radium' )
		),
		'options' => $element_cta
	);

	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builider_registar_cta_element');	