<?php 

/**
 * Posts Element
 *
 * @since 2.1.0
 *
 * @params array $options
 * @param string $current_location Current location of element, featured or primary
 */
if ( ! function_exists( 'radium_builder_blog_element' )) {
	function radium_builder_blog_element( $id, $options, $location  ) {
		
		global $post;
		
		$framework = radium_framework();
				
		//Setup Sidebar
		radium_sidebar_loader(); 
		
		$radium_sidebar_location = null;
				         		
		//Check if sidebar is active
		if ( $radium_sidebar_location  !== 'none' ) { $sidebar_check = "withsidebar"; } else { $sidebar_check = "fullwidth"; }
				
		//image resizer settings
		$crop = true; //resize but retain proportions
		$single = true; //return array
				
		//Get Global Page Settings
		$page_items 	= isset($options['numberposts']) 	? $options['numberposts'] 	: -1;
		$blog_type 		= isset($options['ctp_page_columns']) 	? $options['ctp_page_columns'] 	: 'one-column';
		$blog_show_pagination = isset($options['cpt_pagination']) ? $options['cpt_pagination'] 	: 1;
		 		 
		//Pagination Loader
		if ( get_query_var('paged') )
		    $paged = get_query_var('paged');
		else if ( get_query_var('page') )
		    $paged = get_query_var('page'); // This provides compatibility with static frontpage
		else
		    $paged = 1;
	
		//Load Query
		$args = array(
		    'post_type' 		=> 'post',
		    'posts_per_page' 	=> $page_items,
		    'paged' 			=> $paged	                 
		); 
		 
		if( ! $options['categories']['all'] ) {
			unset( $options['categories']['all'] );
			$categories = '';
			foreach( $options['categories'] as $category => $include ) {
				if( $include ) {
					$categories .= $category.',';
				}
			}
			if( $categories ) {
				$categories = radium_remove_trailing_char( $categories, $char = ',' );
				$args = array_merge( $args, array( 'category_name' => esc_attr( $categories ) ) );
			}
		}
		
		query_posts( $args );
		
		if ( $blog_type == 'one-column' ) :
			
			if (have_posts()) : while (have_posts()) : the_post(); 
				
				global $more; 
				$more = false;
				$format = get_post_format();
				 
				if( false === $format ) { $format = 'standard'; }
				if( $format == 'aside' || $format == 'gallery' || $format == 'link' || $format == 'quote' || $format == 'status') { }
			
			    get_template_part( 'includes/content/content', $format ); 
								
			endwhile; else : 
			
				get_template_part( 'includes/content/content', 'not-found' ); 
			
			endif;
			
		else :
		 
			if ( $blog_type == 'two-columns') {
			
				$type = array( 
				
					1 => array( 
						0 => 'small',
						1 => 'small',
					) 
				);
			
				$reset_counter_at = 2;
					
			} elseif ( $blog_type == 'small-thumbs' ) {
			
				$type = array( 
				
					1 => array( 0 => 'small-thumbs' ) 
				);
				
				$reset_counter_at = 2;
				
				} else {	
			
				$type = array( 
				
					1 => array( 
						0 => 'big',
						1 => 'small',
						2 => 'small'
					),
					
					2 => array( 
						0 => 'big',
						1 => 'mini',
						2 => 'mini',
						3 => 'mini'
						
					),
					
					3 => array( 
						0 => 'small',
						1 => 'small',
						2 => 'mini',
						3 => 'mini',
						4 => 'mini'
					) 
				);
				$reset_counter_at = 4;
			}
			?>
			         
			<section id="blog-grid">
				<div class="blog-grid-container">
				<?php 
				
				$type_counter = 0;
				$which_type = 1;
					
				if ( have_posts() ) : while ( have_posts() ) : the_post(); 
					
					global $more; 
					$more = false;			
					$format = get_post_format();
					
					switch (  $type[$which_type][$type_counter] ) {
					
						case 'mini':
							
							$thumb_w = 222; //Define width
							$thumb_h = 100; // Define height
							$text_lenght= '10';
						
							break;
						
						case 'small':
							
							$thumb_w = 337; //Define width
							$thumb_h = 150; // Define height
							$text_lenght= '10'; //number of words
						
							break;
						
						case 'small-thumbs':
							
							$thumb_w = 320; //Define width
							$thumb_h = 165; // Define height
							$text_lenght= '35';
						
							break;
						
						case 'big':
							$thumb_w = 700; //Define width
							$thumb_h = 240; // Define height
							$text_lenght= '10';
						
							break;
							
						default:
							break;		
					}					
					 						
					if ( $type_counter % count($type[$which_type]) == 0 ) { ?>
						
					<div class="blog-grid-items clearfix"> 
					
					<?php }
					
						$element_class = $type[$which_type][$type_counter];
				
						if ( $type_counter % count($type[$which_type]) == count($type[$which_type]) - 1 )
							$element_class .= ' last';
					
					?>
							
						<div <?php post_class("grid_elements clearfix $element_class"); ?>>
							
							<?php if ( $type[$which_type][$type_counter] !== 'small-thumbs' ) { ?>
								
								<header class="entry-header">
									<h2 class="entry-title"><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
									<?php if ($type[$which_type][$type_counter] !== 'mini') do_action( 'radium_post_grid_meta' ); ?>
								</header><!-- .entry-header -->
							
							<?php }
							
							$embed = get_post_meta($post->ID, '_radium_video_embed', true); ?>
							<?php if ( !empty( $embed ) && !$format == 'video'  ) { ?>
								<div class="entry-content-media">
									<div class='video-frame'>
										<?php echo stripslashes(htmlspecialchars_decode($embed)); ?>
									</div>
								</div>	
							<?php } elseif ( $format=='gallery' ) { ?>
								<div class="entry-content-media">
									<?php radium_gallery( $post->ID, $thumb_w, $thumb_h, $crop, null ); ?>
								</div>
							<?php } else { 
					   			
				   				//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
				   				if ( has_post_thumbnail() ) {
				   					
				   					//get featured image
				   				    $thumb = get_post_thumbnail_id();
				   				    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
				   				  
				   				}
				   				
				   				$image = empty($img_url) ? get_radium_first_post_image( false ) : radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
				   			
				   				if( $image) { ?>
				   					<div class="entry-content-media">
					   					<div class="post-thumb preload">
					   						<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" style="height: <?php echo $thumb_h; ?>px; width: <?php echo $thumb_w; ?>px;">
					   							<img src="<?php echo $image ?>" alt="<?php the_title();?>" style="display: block; height: <?php echo $thumb_h; ?>px; width: <?php echo $thumb_w; ?>px;"/>
					   						</a>
					   						<?php if ( $format == 'video' || $format == 'audio'  ) { ?><a href="<?php the_permalink(); ?>" class="jp-video-play-icon" title="<?php _e('Play', 'radium'); ?>"><?php _e('Play', 'radium'); ?></a><?php } ?>
					   					</div>
				   					</div>
				   				<?php } //image
					   				
							} //embed ?>
							<div class="content_wrapper">
								<?php if ( $type[$which_type][$type_counter] == 'small-thumbs' ) { ?>
									
									<header class="entry-header">
										<h2 class="entry-title"><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										</header><!-- .entry-header -->
								
								<?php }	?>
								<article class="entry-content">
									<?php if ( $type[$which_type][$type_counter] == 'small' || $type[$which_type][$type_counter] == 'small-thumbs' || $type[$which_type][$type_counter] == 'mini') { ?>
											<p><?php echo wp_trim_words( get_the_excerpt(), $text_lenght ); ?></p>
											<p><a href="<?php the_permalink($post->ID); ?>" class="more-link"><span><?php _e( 'Continue Reading &rarr;', 'radium' ); ?></span></a></p>
										<?php } else { ?>	
											<?php the_content( __( '<span>Continue Reading &rarr;</span>', 'radium' ) ); ?>
										<?php } ?>
								</article><!-- .entry-content -->
							</div>
							<?php if ( $type[$which_type][$type_counter] !== 'small-thumbs' || $type[$which_type][$type_counter] !== 'mini' ) do_action( 'radium_post_grid_footer_meta' ); ?>
							
						</div>
							
						<?php if ( $type_counter % count($type[$which_type]) == count($type[$which_type]) - 1 ) { ?><div class="blog-grid-divider clearfix"></div></div><?php }
							
						$type_counter++; 
						
						if ( $type_counter == count($type[$which_type]) ) {
							$which_type++;
							$type_counter = 0;
						}
						
						if ( $which_type == $reset_counter_at )  $which_type = 1; 
							
					endwhile; else : 
					
						get_template_part( 'includes/content/content', 'not-found' ); 
					
					endif; ?>
				
				</div>
			</section>
		
		<?php endif; ?>
		
		<?php 
		
		if ( $blog_show_pagination ) 
			echo radium_theme_pagination(); 
		
		?>
		
		<?php wp_reset_query();
 
 	}
}
add_action('radium_builder_blog', 'radium_builder_blog_element', 10, 3);