<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main-container">
 *
 * @package MetroCorp
 * @since RadiumFramework 1.0.0
 */
$framework = radium_framework();
?><!DOCTYPE html>
<!--[if lt IE 7]><html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>><![endif]-->
<!--[if IE 7]><html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>><![endif]-->
<!--[if IE 8]><html class="no-js lt-ie9" <?php language_attributes(); ?>><![endif]-->
<!--[if gt IE 8]><!--><html <?php language_attributes(); ?>><!--<![endif]-->
<!--
	<?php echo $framework->theme_title; ?> Wordpress Theme.
	Design & Code by Franklin Gitonga - http://radiumthemes.com 
-->
<head>
<!-- Meta Tags -->
<meta http-equiv="content-type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<?php if ( $framework->theme_supports( 'primary', 'responsive' ) ) { ?>
<!-- Set the viewport width to device width for mobile -->
<meta name="viewport" content="width=device-width, initial-scale=1.0" />
<?php } ?>
<title><?php 

if (function_exists("radium_title")) { 

	echo radium_title(); 
	
} else {

(!defined('WPSEO_VERSION')) ? (wp_title('|', true, 'right').bloginfo('name')) : wp_title('');
		
} 

?></title>
<?php
  	//Radium SEO Action Hook
  	do_action('radium_seo');
?>
<!-- RSS & Pingbacks -->
<link rel="alternate" type="application/rss+xml" href="<?php radium_feed_url(); ?>"/>
<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>" title="<?php printf( __( '%s latest comments', 'radium' ), esc_html ( get_bloginfo('name'), 1 ) ); ?>" />
<link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
<?php 

radium_analytics(true);
wp_head(); 

?>
</head>
<body <?php body_class(); ?>>
	
	<div id="body-wrapper">
		<?php do_action('radium_before_header'); ?>
	
		<div id="header" class="container top-bar">
			 <header id="top-header">
			 	<!-- Top -->
				<div id="top">
					 <div class="row">
					
						<div class="six columns">
						 
							<!-- Branding -->
							<div id="branding">
								<div id="logo" class="clearfix">
	 								<?php do_action( 'radium_header_logo' ); ?>
								</div>
							</div><!--#Branding -->
							
						</div>
							
						<div class="six columns">
							
							<?php do_action( 'radium_header_tools' ); ?>
							
						</div>
	
					</div>
							
				<div class="row">
					<div id="navigation-wrap" class="twelve columns">
						<?php if ( $framework->theme_supports( 'primary', 'megamenu') ){ ?>	
							<!-- Main Navigation -->
							<nav id="navigation" class="hide-for-small" role="navigation">
								<div class="container">
									<div class="main_menu">
										 <?php
										/* Main menu */
										$args = array(
										    'container' => '',
										    'menu_id' => 'main-menu',
										    'menu_class' => 'radium_mega menu clearfix',
										    'fallback_cb' => 'radium_fallback_menu',
										    'depth' => 5,
										    'menu' => 'Main Menu',
											'theme_location' => 'main-menu',
										    'walker' => new Radium_Walker()
										);
												
										wp_nav_menu( apply_filters( 'radium_main_menu_args', $args ) );
									 ?>
									</div>	
								</div>
							</nav>
							<!-- /End Main Menu -->
						<?php } ?>
						
						<?php if ( $framework->theme_supports( 'primary', 'responsive' ) ) { ?>
							<!-- Responsive Navigation -->
							<div id="responsive-nav" class="show-for-small">
								<?php
									radium_dropdown_menu(
										array( 
											'depth' 			=> 6,
											'sort_column' 		=> 'menu_order',
											'theme_location' 	=> 'main-menu', 
											'dropdown_title' 	=> 'Select a page...',
											'indent_string' 	=> '- ',
											'indent_after' 	=> '',
											'fallback_cb' 		=> 'radium_mobile_nav_fallback_cb'
										) 
									); 
								?>
							</div>  
							<!-- /End Responsive Navigation -->	 
						<?php } ?>
					</div>
				</div>
				</div> <!--#top -->
				
			</header><!-- /header -->
		</div>
	  
		<?php 
		
		do_action( 'radium_after_header' );
	
		if( !is_page_template('page-builder.php') ) { ?>
			<!-- #page-header -->
		 	<header id="page-header" >
		 		<div class="inner">
			 		<div class="row">
						<div class="twelve columns">
							<div id="header-title">
								<?php get_template_part( 'includes/content/content', 'header' ); ?>
							</div>
			 	      	</div>
			 	    </div>
		 	    </div>
		 	</header>
			<!-- End #page-header -->	
		<?php 
	 		
		}
		
		do_action( 'radium_before_content_container' ); ?>
		<!--  #main-container -->
		<section id="main-container">
	 