// On document ready functions
// ======================================================================

// If JavaScript is enabled remove 'no-js' class and give 'js' class
jQuery('html').removeClass('no-js').addClass('js');

jQuery(document).ready(function($) {

	jQuery('#windowTitleDialog').bind('show', function () { document.getElementById ("xlInput").value = document.title; });
	
	jQuery(document).tooltips();
	
	// Widgets Tabs
	//When page loads...
	$('.tabs-wrapper').each(function() {
		$(this).find(".tab_content").hide(); //Hide all content
		$(this).find("ul.tabs li:first").addClass("active").show(); //Activate first tab
		$(this).find(".tab_content:first").show(); //Show first tab content
 	});
	
	/* ----------------------------------------------------- */
	/* Accordion */

	var allPanels = $('.accordion > .inner').hide();
    
  	$('.accordion > .title > a').click(function() {
      $this = $(this);
      $target =  $this.parent().next();

      if(!$target.hasClass('active')){
         allPanels.slideUp(400, 'easeOutCirc');
         $target.slideDown(400, 'easeOutCirc');
         $this.parent().parent().find('.title').removeClass('active');
         $this.parent().addClass('active');
      }
      
    	return false;
  	});
  		
	//On Click Event
	$("ul.tabs li").click(function(e) {
		$(this).parents('.tabs-wrapper').find("ul.tabs li").removeClass("active"); //Remove any "active" class
		$(this).addClass("active"); //Add "active" class to selected tab
		$(this).parents('.tabs-wrapper').find(".tab_content").hide(); //Hide all tab content

		var activeTab = $(this).find("a").attr("href"); //Find the href attribute value to identify the active tab + content
		$(this).parents('.tabs-wrapper').find(activeTab).fadeIn(); //Fade in the active ID content
		
		e.preventDefault();
	});
	
	$("ul.tabs li a").click(function(e) {
		e.preventDefault();
	})
	
	
	//Image Overlays
	if (jQuery().rmimage_rollover) { jQuery(".grid-thumb, .carousel-media, .radium-gallery-item").rmimage_rollover(); 	}
	
	var sh = jQuery(".grid-thumb > a, .carousel-media, .radium-gallery-item > a").data('height');
	var sw = jQuery(".grid-thumb > a, .carousel-media, .radium-gallery-item > a").data('width');
		       		
	if (sh > sw) {
		var hw = (sw/2);
	} else {
		var hw = (sh/2);
	}
	
	$(".grid-thumb > a, .carousel-media, .radium-gallery-item").find('.post-thumb-overlay').stop().css({ top : -25, left: (sw/2 - hw/2), opacity : 0});
	
   jQuery(".grid-thumb > a, .carousel-media, .radium-gallery-item > a").hover(function(){

		$(this).find('.portfolio-overlay').stop().animate({opacity : 1}, 200, 'easeOutSine');
		
		$(this).find('.post-thumb-overlay').stop().animate({ height:hw, width:hw, top : (sh/2 - hw/2), left:(sw/2 - hw/2), opacity : 1}, 160, 'easeOutSine');	
	
	}, function(){
		
		$(this).find('.portfolio-overlay').stop().animate({opacity : 0}, 300, 'easeInSine');
		$(this).find('.post-thumb-overlay').stop().animate({ top : -25, left: (sw/2 - hw/2), opacity : 0}, 260, 'easeOutSine');
				
   	});
    
	// FitVid Magic - Target all videos
	jQuery("body").fitVids();
	
	//AutoHeight Textareas
	jQuery('textarea.auto-height').flexText();
	  
  	 //Validate forms 
	 if (jQuery().validate) { jQuery("#commentform").validate(); }
	
	// Tabs and Toggle
	jQuery(".radium-tabs").tabs();	
	
	jQuery(".radium-toggle").each( function () {
		if(jQuery(this).attr('data-id') == 'closed') {
			jQuery(this).accordion({ header: '.radium-toggle-title', collapsible: true, active: false  });
		} else {
			jQuery(this).accordion({ header: '.radium-toggle-title', collapsible: true});
		}
	});
		
	// Message box - close buttons
	jQuery(".messageBox .closeBox").click( function() {
		jQuery(this).parent('.messageBox').fadeTo(400, 0.001).slideUp();
	});
    
   	//activate the mega menu
 	jQuery(".main_menu .radium_mega").radiumMegamenu({
 		sensitivity: 7, // number = sensitivity threshold (must be 1 or higher)
 		interval: 100, // number = milliseconds for onMouseOver polling interval
 		timeout: 500, // number = milliseconds delay before onMouseOut	
 	});
 
 	jQuery('#main-menu').spasticNav( {
		overlap : 20,
		speed : 800,
		reset : 1500,
		color : '#AFCEFF',
		//easing : 'linear'
	} );
	
	//Back to Top
	jQuery().UItoTop({ 
		text: 'Top',
		easingType: 'easeOutQuart'
	});
		
	/* ---------------------------------------------------------------------- */
	/* Isotope 
	/* ---------------------------------------------------------------------- */
	if( jQuery().isotope ) {
	    
	    jQuery(function() {

            var container = jQuery('.isotope'),
                optionFilter = jQuery('#filters'),
                optionFilterLinks = optionFilter.find('a');
            
            optionFilterLinks.attr('href', '#');
            
            optionFilterLinks.click(function(){
                var selector = jQuery(this).attr('data-filter');
                container.isotope({ 
                    filter : '.' + selector, 
                    itemSelector : '.page-grid-item',
                    layoutMode : 'fitRows',
                    animationEngine : 'best-available'
                });
                
                // Highlight the correct filter
                optionFilterLinks.removeClass('active');
                jQuery(this).addClass('active');
                return false;
            });
            
	    });
    
	}
	
	/* Portfolio Filter Nav */
	jQuery("#filter-title a").click(function(e) {
		jQuery("#filter-section").toggle("slow");
		jQuery(this).find('span.filter-text').toggle("fast");
		return false; 
	}); 

	
	/* ---------------------------------------------------------------------- */
	/* Content Carousel 
	/* ---------------------------------------------------------------------- */

	(function() {

		var $carousel = $('.radium-carousel');

		if( $carousel.length ) {

			var scrollCount;

			function getWindowWidth() {

				if( $(window).width() < 480 ) {
					scrollCount = 1;
				} else if( $(window).width() < 768 ) {
					scrollCount = 2;
				} else if( $(window).width() < 940 ) {
					scrollCount = 3;
				} else {
					scrollCount = 4;
				}

			}

			function initCarousel( carousels ) {

				carousels.each(function() {

					var $this  = $(this);

					$this.jcarousel({
						animation : 600,
						easing : 'easeOutCubic',
						scroll : scrollCount,
						itemFirstInCallback : function() {
							onAfterAnimation : resetPosition( $this )
						}
					});

				});

			}

			function adjustCarousel() {

				$carousel.each(function() {

					var $this    = $(this),
						$lis     = $this.children('li')
						newWidth = $lis.length * $lis.first().outerWidth( true ) + 100;

					getWindowWidth();

					// Resize only if width has changed
					if( $this.width() !== newWidth ) {

						$this.css('width', newWidth )
							 .data('resize','true');

						initCarousel( $this );

						$this.jcarousel('scroll', 1);

						var timer = window.setTimeout( function() {
							window.clearTimeout( timer );
							$this.data('resize', null);
						}, 600 );

					}

				});

			}

			function resetPosition( elem, resizeEvent ) {
				if( elem.data('resize') )
					elem.css('left', '0');
			}

			getWindowWidth();

			initCarousel( $carousel );

			// Window resize
			$(window).on('resize', function() {

				var timer = window.setTimeout( function() {
					window.clearTimeout( timer );
					adjustCarousel();
				}, 30 );

			});
		}

	})();
 	
 	/* end Post Carousel */ 
 	if ( radium_framework_globals.main_bg_images) {
  		
		// Call backstretch for the first time,
		jQuery.backstretch(radium_framework_globals.main_bg_images  );
	 
	}				 	
});

 
/*-----------------------------------------------------------------------------------*/
//	Preload
/*-----------------------------------------------------------------------------------*/
jQuery(window).bind('load', function() {
	
	/*
     var i = 1;
     var imgs = jQuery('.post-thumb.preload img').length;
     var int = setInterval(function() {

     if(i >= imgs) clearInterval(int);
     	jQuery('.post-thumb img:not(.image-loaded)').eq(0).animate({ opacity: "1"}, 300,"easeInQuart").addClass('image-loaded');
     i++;
     
     }, 100);   
     */
     
    jQuery('div').removeClass('preload');  
    
    jQuery('.post-thumb a img').hover(
        function () { jQuery(jQuery(this)).stop().animate({ opacity: "0.3" },300); },
        function () { jQuery(jQuery(this)).stop().animate({ opacity: "1" },300); }
    );

});

/* ----------------------------------------------------- */
/* Radium Image Rollover */
/* ----------------------------------------------------- */
 
(function($) {
	$.fn.rmimage_rollover = function() {
		return this.each(function() {
			var root = $(this);

			root.hover(function() {
				if(jQuery.browser.msie && parseInt(jQuery.browser.version) < 9) {
 					$(".stripes", this).show();
				} else {
 					$(".stripes", this).css("display" , "none").stop(true, true).fadeIn(400);
				}
			}, function() {
				if(jQuery.browser.msie && parseInt(jQuery.browser.version) < 9) {
 					$(".stripes", this).hide();
				} else {
 					$(".stripes", this).css("display" , "block").stop(true, true).fadeOut(400);
				}
			});
			
			root.click(function(e) {
				if(jQuery.browser.msie && parseInt(jQuery.browser.version) < 9) {
 					$(".stripes", this).hide();
				} else {
 					$(".stripes", this).css("display" , "block").stop(true, true).fadeOut(400);
				}
			});
		});
	};
	$.fn.rmimage_rollover.defaults = {}		
})(jQuery);


/* ----------------------------------------------------- */
/* Modal Triggers*/
/* ----------------------------------------------------- */
function closeDialog () {
	jQuery('#windowTitleDialog').modal('hide'); 
};
function okClicked () {
	document.title = document.getElementById ("xlInput").value;
	closeDialog ();
};
   

/** ----------------------------------------------------- 
 * Radium Mega Menu
 * www.radiumthemes.com
 * Franklin Gitonga
 * 
 * ver 1.1
 /* ----------------------------------------------------- */

(function($) {

	$.fn.radiumMegamenu = function(variables) {
	
		var defaults = {
			modify_position:true,
			sensitivity: 2, // number = sensitivity threshold (must be 1 or higher)
			interval: 100, // number = milliseconds for onMouseOver polling interval
			timeout: 500, // number = milliseconds delay before onMouseOut
		};
		
		var options = $.extend(defaults, variables);
		
		return this.each(function() {
			var menu = $(this),
				menuItems = menu.find(">li"),
				megaItems = menuItems.find(">div").parent().css({overflow:'hidden'}),
				dropdownItems = menuItems.find(">ul").parent(),
				parentContainerWidth = menu.parent().width(),
				descriptions = menu.find('.main-menu-description');
		
			if(descriptions.length) menu.addClass('menu-has-desc');
			
			menuItems.each(function() {
				var item = $(this),
					pos = item.position(),
					megaDiv = item.find("div:first").css({opacity:0, display:"none"}),
					normalDropdown = "";
				
				//check if we got a mega menu	
				if(!megaDiv.length) {
					normalDropdown = item.find(">ul").css({display:"none"});
				}
				
				//if we got a mega menu or dropdown menu add the arrow beside the menu item	
				if(megaDiv.length || normalDropdown.length) {
				
					var link = item.addClass('has-submenu').find('>a');
					link.html("<span class='submenu-link'>"+link.html()+"</span>").append('<span class="submenu-indicator"></span>');

					//is a mega menu main item doesn't have a link to click use the default cursor
					if(typeof link.attr('href') != 'string'){ link.css('cursor','default'); }
				}
				
				//correct position of mega menus			
				if(options.modify_position && megaDiv.length) {										
					if(megaDiv.width() > pos.left) {
						megaDiv.css({left: (Math.ceil() * -1)});
					}
					else if(pos.left + megaDiv.width() > parentContainerWidth) {
						megaDiv.css({left: (megaDiv.width() - pos.left) * -1 });
					}
				}
				
			});	
				
			function megaDivShow(i) {
					var item = megaItems.filter(':eq('+i+')').css({overflow:'visible'}).find("div:first"),
						link = megaItems.filter(':eq('+i+')').find("a:first");
						
					item.stop().css('display','block').animate({opacity:1},200);
						
					if(item.length) {
						link.addClass('open-mega-a');
					}
			}
			
			function megaDivHide (i) {
				megaItems.filter(':eq('+i+')').find(">a").removeClass('open-mega-a');
				
				var listItem = megaItems.filter(':eq('+i+')'),
					item = listItem.find("div:first");
					
				item.stop().css('display','block').animate({opacity:0},300, function() {
					$(this).css('display','none');
					listItem.css({overflow:'hidden'});
				});
			}

			//bind event for mega menu
			megaItems.each(function(i) {
				var menuConfig = {
					sensitivity: options.sensitivity,	
 					interval: options.interval,
					timeout: options.timeout,
				    over: function() { megaDivShow(i); }, 
				    out: function() { megaDivHide(i); } 
				 };
				  			
				$(this).hoverIntent(menuConfig);
			});
			
			// bind events for normal dropdown menus
			dropdownItems.find('li').andSelf().each(function() {	
				var currentItem = $(this),
					sublist = currentItem.find('ul:first'),
					showList = false;
							
				if(sublist.length) { 
					sublist.css({display:'block', opacity:0, visibility:'hidden'}); 
					var currentLink = currentItem.find('>a');
					var menuConfig2 = {
							sensitivity: options.sensitivity,	
							interval: options.interval,
							timeout: options.timeout,
 							over: function() { sublist.stop().css({visibility:'visible'}).animate({opacity:1}); }, 
 							out: function() { sublist.stop().animate({opacity:0}, function() { sublist.css({visibility:'hidden'}); }); } 
						}
					$(this).hoverIntent(menuConfig2);
				}
		
			}); //bind
			
		});
	};
})(jQuery);