<?php
/**
 * Integration class for Radium_PriceTables.
 * This class integrates the pricing tables 
 * generated here into the radium framework
 *
 * @since 1.0.0
 *
 * @package	Radium_PriceTables
 * @author	Franklin M Gitonga
 */
class Radium_PriceTables_Integrate {

	/**
	 * Holds a copy of the object for easy reference.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	private static $instance;

	/**
	 * Constructor. Hooks all interactions to initialize the class.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
	
		self::$instance = $this;
		
 		/** Register hooks */
 		add_filter('radium_builder_elements', array(&$this, 'builder_pricing_element'), 11);	
 		add_action('radium_builder_pricing', array(&$this, 'builder_pricing_frontend_element'), 11, 3); 
 		add_filter('radium_sample_layouts', array(&$this, 'builder_pricing_samples_layout'), 11 );
 		
	}
	
	
	/** 
	 * Register Pricing Element
	 * @return array();
	 * 
	 * @since 1.0.0
	 */
	public function builder_pricing_element( $elements ) {
 
		//Select Slider
		$pricing_table_select = array();
		
		$pricing_tables = get_posts( 'post_type=pricetable&numberposts=-1' );
		if( ! empty( $pricing_tables ) )
			foreach( $pricing_tables as $k )
				$pricing_table_select[$k->ID] = $k->post_title;
		else
			$pricing_table_select['null'] = __( 'You haven\'t created any pricing table yet.', 'radium' );
					
		
		// Slider
		$element_pricing = array(
		    array(
		    	'id' 		=> 'pricing_id',
		    	'name'		=> __( 'Select Pricing Table', 'radium' ),
		    	'desc'		=> __( 'Choose the pricing table you\'d like to display.', 'radium' ),
		    	'type'		=> 'select',
		    	'options'	=> $pricing_table_select,
		    	'class'		=> 'pricing-content'
		    )
		);
		
		$elements['pricing'] = array(
			'info' => array(
				'name' 	=> 'Pricing Table',
				'id'	=> 'pricing',
				'query'	=> 'none',
				'hook'	=> 'radium_pricing_block',
				'shortcode'	=> '[pricing]',
				'desc' 	=> __( 'Pricing Table', 'radium' )
			),
			'options' => $element_pricing
		);
 	
		return $elements;
		
	}
	
	
	/**
	 * Display slider.
	 *
	 * @since 2.1.0
	 *
	 * @param string $slider Slug of custom-built slider to use
	 */

	public function builder_pricing_frontend_element(  $id, $settings, $location ) { 
		
		// Die if there's no pricetable
		if( ! $settings['pricing_id']  || $settings['pricing_id'] =='null' ) {
		
			echo '<div class="messageBox warning">'.__( 'Oops! You have not selected a pricing table in your layout.', 'radium' ).'</div>';
			return;
		} else { ?>
			
			<div class="row">
				<div class="twelve columns">
					<?php echo do_shortcode('[price_table id="'.$settings['pricing_id'].'"]'); ?>
				</div>
			</div>
			<?php
		}
		
	}
	
	/**
	 * Get all sample layouts.
	 *
	 * @return array
	 */
	 
	function builder_pricing_samples_layout( $samples ) {
  		
		$samples['pricing'] = array(
					'name' => 'Pricing Landing Page',
					'id' => 'pricing',
					'preview' => plugins_url( 'assets/admin/images/sample-pricing-table.png', dirname(dirname(__FILE__))),
					
		 			'featured' => array(
		 				'element_1' => array(
		 					'type' => 'pricing',
		 					'query_type' => 'none',
		 					'width' => 'element1-1',
		 					'options' => array(
		 						'pricing_id' => null,
		 					)
		 				)
		 			),
		 			
					'primary' => array(
	 					'element_2' => array(
							'type' => 'slogan',
							'query_type' => 'none',
							'width' => 'element1-1',
							'options' => array(
								'slogan' => '<h3 class="light">We\'ve worked with more than <strong>200,000,000</strong> customers with a teams that wants to get stuff done resulting in over <strong>$1 trillion</strong> in market capitalization.</h3>',
								'align' => 'center'
							 )
						),
						'element_3' => array(
							'type' => 'divider',
							'query_type' => 'none',
							'width' => 'element1-1',
							'options' => array( 'type' => 'default')
						),
						'element_4' => array(
							'type' => 'content',
							'query_type' => 'none',
							'width' => 'element1-1',
							'options' => array( 
								'raw_content' => '<div class="logo-list"><ul>
													<li><a title="" href="#"><img src="http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/03/logo-01.png" alt="" width="187" height="95"></a></li>
													<li><a title="" href="#"><img src="http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/03/logo-02.png" alt="" width="187" height="95"></a></li>
													<li><a title="" href="#"><img src="http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/03/logo-03.png" alt="" width="187" height="95"></a></li>
													<li><a title="" href="#"><img src="http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/03/logo-04.png" alt="" width="187" height="95"></a></li>
													<li><a title="" href="#"><img src="http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/03/logo-05.png" alt="" width="187" height="95"></a></li>
													</ul></div>',
								'source' => 'raw',
 							)
						),
						'element_5' => array(
							'type' => 'divider',
							'query_type' => 'none',
							'width' => 'element1-1',
							'options' => array( 'type' => 'default')
						),
						'element_6' => array(
							'type' => 'content',
							'query_type' => 'none',
							'width' => 'element1-2',
							'options' => array(
								'source' => 'raw',
								'raw_content' => '<h4>Answer a few pre-sale questions here.</h4>
										Currently we accept payments through PayPal. PayPal can take payments from most major debit/credit cards so don’t worry if you don’t have a PayPal account.
										<h4>What are the minimum requirements?</h4>
										Intrinsicly drive functional users through granular potentialities. Professionally myocardinate user-centric "outside the box" thinking and resource-leveling applications. Monotonectally restore backend human capital whereas one-to-one e-bu
										<h4>Are these recurring payments?</h4>
										Professionally myocardinate user-centric "outside the box" thinking and resource-leveling applications. Monotonectally restore backend human capital whereas one-to-one'
							)
						),
						'element_7' => array(
							'type' => 'content',
							'query_type' => 'none',
							'width' => 'element1-2',
							'options' => array(
								'source' => 'raw',
								'raw_content' => '<h4>Can I upgrade?</h4>
								Intrinsicly drive functional users through granular potentialities. Professionally myocardinate user-centric "outside the box" thinking and resource-leveling applications. 
								<h4>Is that all?</h4>
								Intrinsicly drive functional users through granular potentialities. Professionally myocardinate user-centric "outside the box" thinking and resource-leveling applications. Monotonectally restore backend human capital whereas one-to-one e-bu.
								<h4>No hidden fees or secret prices</h4>
								Intrinsicly drive functional users through granular potentialities. Professionally myocardinate user-centric "outside the box" thinking and resource-leveling applications. Monotonectally restore backend human. '
							)
						),
						
						//end elements
					), //end content area
					
					'settings' => array(
						'featured' => array(
							'background' => array(
								'url' => 'http://themes.radiumthemes.com/wp/singleton/wp-content/uploads/2013/01/2-cropped.jpg',
								'color' => 'transparent',
								), //background
								
							) //featured
					) //settings
				);
		
		return $samples;
	}
	
}
