<?php

// Add function to widgets_init that'll load our widget.
add_action( 'widgets_init', 'radium_recent_posts_widget' );


// Register widget.
function radium_recent_posts_widget() {
	register_widget( 'radium_Recent_Posts_Widget' );
	add_image_size( 'recent_posts_thumb', 49, 49, true ); // Recent Posts thumbnail
	
}

// Widget class.
class radium_recent_posts_widget extends WP_Widget {


/*-----------------------------------------------------------------------------------*/
/*	Widget Setup
/*-----------------------------------------------------------------------------------*/
	
	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		
		$framework = radium_framework();
		
		parent::__construct(
	 		'radium_recent_posts_widget', // Base ID
			'Recent Posts ('. $framework->theme_title .')', // Name
			array( 'description' => __( 'A widget that displays your recent Posts.', 'radium' ), )
		);
	}


/*-----------------------------------------------------------------------------------*/
/*	Display Widget
/*-----------------------------------------------------------------------------------*/
	
	function widget( $args, $instance ) {
		extract( $args );
		
		/* Our variables from the widget settings. */
		$title = apply_filters('widget_title', $instance['title'] );
		$number = ( isset($instance['number']) ) ? $instance['number'] : 0;

		/* Before widget (defined by themes). */
		echo $before_widget;

		/* Display the widget title if one was input (before and after defined by themes). */
		if ( $title ) { echo $before_title . $title . $after_title; }
        ?>
			
		<div class="radium-recent-posts-widget">
		
			<?php
			//Set Thumbs
			$thumb_w 	= '48'; //Define width
			$thumb_h 	= '48'; // Define height
			$crop 		= true; //resize 
			$single 	= true; //return array
	
			$args = array(
				'ignore_sticky_posts' => 1,
			    'showposts' => $number
			);	
			$recentPosts = new WP_Query( $args );
				
			// Display recent posts
			echo '<ul>';	
				
			while ( $recentPosts->have_posts() ) : $recentPosts->the_post(); 
	
				//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
				if ( has_post_thumbnail() ) {
					
					//get featured image
				    $thumb = get_post_thumbnail_id();
				    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
				  
				} else {
				
					$attachments = get_children(
				        array(
				        	'post_parent' => get_the_ID(), 
				        	'post_type' => 'attachment', 
				        	'post_mime_type' => 'image', 
				        	'orderby' => 'menu_order'
				        	)
				    );
				    
				    if ( ! is_array($attachments) ) continue;
				    	$count = count($attachments);
				    	$first_attachment = array_shift($attachments);
				    
				     @$img_url = wp_get_attachment_url( $first_attachment->ID,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
				
				}
				if($img_url)
					$image = radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
				
				//add thumbnail fallback
				if(empty($image)) $image = get_radium_first_post_image(true);
				
				?>
				<li class="news-content post-format clearfix <?php echo get_post_format() ?>">
					<a href="<?php the_permalink(); ?>" class="news-link">
						<div class="news-thumb preload">
							<span><img src="<?php echo $image ?>" alt="" width="<?php echo $thumb_w; ?>"  height="<?php echo $thumb_h; ?>"/></span>
						</div>
						<div class="news-title"><strong><?php echo wp_trim_words( get_the_title(), '6' ); ?></strong></div>
					</a>
					<div class="news-meta"><?php _e('Published:', 'radium') ?> <span class="published"><?php the_time( get_option('date_format') ); ?></span></div>
				</li>
			<?php endwhile; 
						
			echo '</ul>';
			
			?>
                               
        </div><!-- / .radium-recent-posts-widget -->
	
	<?php

		/* After widget (defined by themes). */
		echo $after_widget;
	}


/*-----------------------------------------------------------------------------------*/
/*	Update Widget
/*-----------------------------------------------------------------------------------*/
	
	function update( $new_instance, $old_instance ) {
		
		$instance = $old_instance;
		
		/* Strip tags to remove HTML (important for text inputs). */
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['number'] = strip_tags( $new_instance['number'] );

		/* No need to strip tags for.. */

		return $instance;
	}
	

/*-----------------------------------------------------------------------------------*/
/*	Widget Settings
/*-----------------------------------------------------------------------------------*/
	 
	function form( $instance ) {

		/* Set up some default widget settings. */
		$defaults = array(
		    'title' => 'From the Blog.',
		    'desc' => 'Some of our Latest Posts',
		    'number' => 2
 		);
		
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		
        <!-- Widget Title: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e('Title:', 'radium') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $instance['title']; ?>" />
		</p>

		<!-- Number Input: Text Input -->
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e('Amount to show:', 'radium') ?></label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo $instance['number']; ?>" />
		</p>
 	
	<?php
	}
}
 
?>
