<?php
/* ---------------------------------------------------------------------- */
/*	Page Post Type
/* ---------------------------------------------------------------------- */
 /* ---------------------------------------------------------------------- */
 /*	Custom Post Type: Gallery
 /* ---------------------------------------------------------------------- */
$framework = radium_framework();

/********************* META BOX DEFINITIONS ***********************/

$prefix = '_radium_';

global $meta_boxes, $pagenow;
 
/********************* META BOX REGISTERING ***********************/
 
$arg = array( 

  		array('name' => __('Subtitle:', 'radium'),
 			'id'   => $prefix . 'subtitle',
 			'type' => 'text',
 			'desc' => 'Page subtitle',
 		),
 
 		array(
 			'name'     => __('Page Layout (Sidebars):', 'radium'),
 			'id'       => $prefix . 'page_layout',
 			'type'     => 'radio_image',
 			'options'  => array(
 				'none' 		=> '<img src="' . $framework->theme_framework_images_url . '/1col.png" alt="' . __('Fullwidth - No sidebar', 'radium') . '" title="' . __('Fullwidth - No sidebar"', 'radium') . ' />',
 				'left'  	=> '<img src="' . $framework->theme_framework_images_url . '/2cl.png" alt="' . __('Sidebar on the left', 'radium') . '" title="' . __('Sidebar on the left', 'radium') . '" />',
 				'right' 	=> '<img src="' . $framework->theme_framework_images_url . '/2cr.png" alt="' . __('Sidebar on the right', 'radium') . '" title="' . __('Sidebar on the right', 'radium') . '" />'
 			),
 			'std'  => '',
 			'desc' => __('', 'radium')
 		),
	);

$meta_boxes[] = array(
	'id' => 'details',
	'title' => 'Page Settings',
	'pages' => array('page'),
	'context' => 'normal',
	'priority' => 'high',
	'fields' => apply_filters( 'radium_page_setting_metaboxes', $arg )
);

	
/* ---------------------------------------------------------------------- */
/*	Page Sidebar
/* ---------------------------------------------------------------------- */
 $arg2 = array(	
		array(
			'name' => __('Select Column Layout:', 'radium'),
			'id'   => $prefix . 'ctp_page_columns',
			'type'		=> 'select',
			'options'	=> array(
				'one-columns' => 'One Column',
 				'two-columns' => 'Two Columns',
				'three-columns' => 'Three Columns',
				'four-columns' => 'Four Columns',
 			),
			'multiple'	=> false,
			'std'		=> array( 'three-columns' )
		),
		
		array(
			'name' => __('Select Blog Layout:', 'radium'),
			'id'   => $prefix . 'blog_layout',
			'type'		=> 'select',
			'options'	=> array(
				//'modern-grid' => 'Modern Grid',
				'two-columns' => 'Two Columns',
				'one-column' => 'One Column',
				'small-thumbs' => 'One Column with small thumbs',
				
			),
			'multiple'	=> false,
			'std'		=> array( 'three-columns' )
		),
		
		array(
			'name' =>__('Enable Portfolio Sorting','radium'),
			'desc' => __('','radium'),
			'id'   => $prefix . 'cpt_sorting',
			'type' => 'checkbox',
			'std'  => '1',
		),
 		
		array(
			'name' => __('Items per Page ', 'radium'),
			'id'   => $prefix . 'cpt_items_count',
			'type' => 'text',
			'std'  => '-1',
			'desc' => ''
		),
		/*
		// TAXONOMY
		array(
			'name'    => 'Categories to use',
			'id'      => $prefix . 'blog_taxonomy',
			'type'    => 'taxonomy',
			'options' => array(
				// Taxonomy name
				'taxonomy' => 'category',
				// How to show taxonomy: 'checkbox_list' (default) or 'checkbox_tree', 'select_tree' or 'select'. Optional
				'type' => 'checkbox_list',
				// Additional arguments for get_terms() function. Optional
				'args' => array()
			),
		), */
	
);

$meta_boxes[] = array(
	'id'       => 'page-cpt-settings',
	'title'    => __('Template Settings', 'radium'),
	'pages'    => array('page'),
	'context'  => 'side',
	'priority' => 'high',
	'fields'   => apply_filters( 'radium_page_setting_metaboxes', $arg2 )
);
	