<?php
/*
 * This file is a part of the RadiumFramework core
 * and contains theme specific settings .
 * Please be extremely cautious editing this file,
 *
 * Also note that most functions here can be customized/modified
 * 
 * @category RadiumFramework
 * @package  MetroCorp WP
 * @author   Franklin M Gitonga
 * @link     http://radiumthemes.com/
 */
 
 
 /*-----------------------------------------------------------------------------------
   Radium Setup
 -----------------------------------------------------------------------------------*/
 if ( !function_exists( 'radium_theme_setup') ) {
 
 	function radium_theme_setup() {
 			
		// Add post thumbnail supports. http://codex.wordpress.org/Post_Thumbnails
		add_theme_support('post-thumbnails');
		add_theme_support('automatic-feed-links');
		
		set_post_thumbnail_size( 140, 140, true ); // Default Thumbnail

		// Add post formarts supports. http://codex.wordpress.org/Post_Formats
		add_theme_support('post-formats', array('aside', 'gallery', 'link', 'quote', 'status', 'video', 'audio', 'chat'));
 			
 		//add editor style so as to match content in editor
 		add_editor_style('assets/css/style-editor.css');
 		if ( ! isset( $content_width ) ) $content_width = 940;
 		
 		// Register WP Menus */
		add_theme_support( 'nav-menus' );
		$menus = array(
			'main-menu' => __( 'Primary Navigation', 'radium' ),
			'footer-menu' => __( 'Footer Navigation', 'radium' )
		);
		
		$menus = apply_filters( 'radium_nav_menus', $menus );
		register_nav_menus( $menus );
 		
 	}
 	add_action('after_setup_theme', 'radium_theme_setup');
 }
 
 
/*-----------------------------------------------------------------------------------
  Add our scripts 
-----------------------------------------------------------------------------------*/
if ( !function_exists( 'add_our_scripts') ) {
		 
	function add_our_scripts() {
		global $post, $is_IE;
		
		$framework = radium_framework();
		
		$options = $framework->options;	 	
										
	 	wp_enqueue_style( 'main-style-compiled', $framework->theme_css_url . '/style.css', false,'1.0', 'all'); //the main stylesheet
	 	
	 	if ( $framework->theme_supports( 'primary', 'responsive' ) )		
 			wp_enqueue_style( 'main-mobile-compiled', $framework->theme_css_url . '/mobile.css', false,'1.0', 'all'); //the mobile stylesheet
 
		//JS
		wp_enqueue_script('jquery');
		wp_enqueue_script( 'jquery-ui-accordion' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_script('custom-libraries', $framework->theme_js_url . '/custom-libraries.min.js', 'jquery', '1.0', true); //theme libraries
		wp_enqueue_script('custom', $framework->theme_js_url . '/custom.min.js', 'jquery', '2.0', true); //theme js init
		
		if ( $is_IE ){
			wp_enqueue_style('radium-ie', $framework->theme_css_url . '/ie.css', false, '2.0', 'all');
			wp_enqueue_script('selectivizr', $framework->theme_js_url . '/selectivizr-min.js', 'jquery', '2.0', false);
	 	}
	 		 			
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
			wp_enqueue_script('validation', $framework->theme_js_url . '/jquery.validate.min.js', 'jquery', '1.9', true);
		}
		
		if ( isset($options['enable_message_bar']) )
			wp_enqueue_script('radium_message_overlay', $framework->theme_js_url . '/radium_message_overlay.min.js', 'jquery', '1.0', true );  
		
 	}
	add_action( 'wp_enqueue_scripts', 'add_our_scripts');
}

/**
 * Conditionally Enqueue Script for IE browsers less than IE 9
 *
 * @link http://php.net/manual/en/function.version-compare.php
 * @uses wp_check_browser_version()
 */
if ( !function_exists( 'radium_enqueue_lt_ie9') ) {

	function radium_enqueue_lt_ie9() {
	    global $is_IE;
	 	
	 	$framework = radium_framework();
	 
	    // Return early, if not IE
	    if ( ! $is_IE ) return;
	 
	    // Include the file, if needed
	    if ( ! function_exists( 'wp_check_browser_version' ) )
	        include_once( ABSPATH . 'wp-admin/includes/dashboard.php' );
	 
	    // IE version conditional enqueue
	    $response = wp_check_browser_version();
	    if ( 0 > version_compare( intval( $response['version'] ) , 9 ) )
	        wp_enqueue_script( 'radium-html5shiv', $framework->theme_js_url . '/html5.js', array(), '3.6.2pre', false );
	}
	add_action( 'wp_enqueue_scripts', 'radium_enqueue_lt_ie9' );

}

/* ----------------------------------------------------------------------
 *	Insert all custom CSS styles
 *
 * This is where the theme's configured styles 
 * from the Theme Options page get put into place 
 * by inserting CSS in the <head> of the site. It's 
 * shown here as clearly as possible to be edited, 
 * however it gets compressed when actually inserted 
 * into the front end of the site.
 *
/* ---------------------------------------------------------------------- */

/* Background Image */
if ( !function_exists('radium_insert_custom_styles') ) {

	function radium_insert_custom_styles() { 
		
		$framework = radium_framework();
		
		$options = $framework->options;	
		$custom_styles 	= isset( $options['user_custom_styles'] ) 	? $options['user_custom_styles'] 	: null;
		
	ob_start(); ?>
	
	<style>
	<?php 
	/*Google Fonts *
	$font_name = $options['header_fonts'];
	$font_name = str_replace("+", " ", $font_name);
	$font_name = explode(":", $font_name);
	//$font_name = $font_name[0]; ?>
	
	h1,
	h2,
	h3,
	h4,
	h5,
	h6 {
		font-family: <?php echo $font_name[0] ;?>; 
		font-weight: <?php echo $font_name[1] ;?>; 
 		}
		
	<?php 
	*/
	
	$main_bg = $options['main_bg'] ? $options['main_bg'] : $framework->theme_images_url."/patterns/".$options['body_bg_pattern'];
	$main_bg_repeat = $options['main_bg_setting'] == 'fullwidth' ? 'no-repeat' : 'repeat';
	
	if( $options['body_bg_pattern'] ): ?>body.boxed { background: <?php if($options['boxed_bg_color']) echo $options['boxed_bg_color']; ?> url(<?php echo $main_bg; ?>) <?php echo $main_bg_repeat; ?>;  }<?php endif;
		if ($options['header_bg_color']): ?>
		#radium_foobar,
		#header,
		#top-header { background-color: <?php  echo $options['header_bg_color']; ?>; }
		<?php endif; 
		if( $options['accent_color'] ):
		?>
		.tab-holder .tabs li.active, 
		#sidebar .widget_radium_pages_menu li.current_page_item,
		.custom-headline  { 
			border-color: <?php  echo $options['accent_color']; ?>; 
			}
		.dropcap2, 
		.nav-hori ul li a.active, 
		.hr:before,
		.teaser_more,
		::selection{
			background-color: <?php  echo $options['accent_color']; ?>;
			}
		.list[class^='icon-'] li::before,
		.list[class*=' icon-'] li::before,
		#sidebar .widget_radium_pages_menu li.current_page_item a,
		a:hover,
		.entry-header h1 a:hover,
		.entry-header h2 a:hover,
		.entry-header h3 a:hover {
			color: <?php  echo $options['accent_color']; ?> !important;
			}
		<?php endif; 
		
		if( $options['footer_bg_color'] ):
		?>
			#bottom-footer { background-color: <?php echo $options['footer_bg_color']; ?>;}
		<?php endif; 
		// Ouptput compressed CSS
		echo radium_code_compress( ob_get_clean() );
		// Add in user's custom CSS
		if( $custom_styles ) echo $custom_styles; 
		?></style><?php 
		/**
		 * User Styles
		 */
	}
	add_action('wp_head', 'radium_insert_custom_styles');
}

//*-----------------------------------------------------------------------------------*/
/*	Adds Fullwidth background image if available
/*-----------------------------------------------------------------------------------*/
function radium_fullwidth_bg() {
	$framework = radium_framework();
	
	$options = $framework->options;
	
	if ( $options['main_bg'] && $options['main_bg_setting'] == 'fullwidth' ) {
	
	
	//ob_start(); 
	
  ?>
	<script>
	 
		</script>
	<?php //echo radium_code_compress( ob_get_clean() ); 
	} //end if
	
	
}
add_action('wp_head', 'radium_fullwidth_bg');

/**
 * This function is executed when the header is printed and will add the radium_framework_globals to javascript 
 * The radium_framework_globals object contains information and settings about the framework
 */
function radium_set_javascript_framework_url() {	
	$framework = radium_framework();
	
	$options = $framework->options;
	
	echo "\n <script type='text/javascript'>\n /* <![CDATA[ */  \n";
	echo "var radium_framework_globals = {"; 
		if ( $options['main_bg'] && $options['main_bg_setting'] == 'fullwidth'  ){ echo "\n \tmain_bg_images:'".$options['main_bg']."',\n \t"; } echo" }; \n /* ]]> */ \n ";
	echo "</script>\n \n ";
}
add_action('wp_head', 'radium_set_javascript_framework_url');


//*-----------------------------------------------------------------------------------*/
/*	Adds the Theme Style form options panel
/*-----------------------------------------------------------------------------------*/
if ( !function_exists( 'radium_load_theme_style') ) {

	function radium_load_theme_style() {
		
		$framework = radium_framework();
		
		$options = $framework->options;
		
		$skin = $options['theme_style'];
		
		if( $skin !== 'default')	
			wp_enqueue_style( $skin, $framework->theme_styles_url.'/'.$skin.'/style.css', false,'1.0','all');
	
	}
	//add_action('wp_enqueue_scripts', 'radium_load_theme_style');
}


//*-----------------------------------------------------------------------------------*/
/*	Adds the skin classes to the body class array.
/*-----------------------------------------------------------------------------------*/
if ( !function_exists( 'radium_skin_body_class') ) {

	function radium_skin_body_class($classes) {
	
		global $post;
			
		$framework = radium_framework();
		
		$options = $framework->options;
	
		$classes[] = $options['theme_style'];
			
		return $classes;
	}
	//add_filter('body_class','radium_skin_body_class');
} 


//*-----------------------------------------------------------------------------------*/
/*	Adds layout classes to the array of body classes.
/*-----------------------------------------------------------------------------------*/
if ( !function_exists( 'radium_layout_body_class') ) {
	
	function radium_layout_body_class($classes) {
		
		global $post;
			
		$framework = radium_framework();
		
		$options = $framework->options;
			
		$classes[] = $options['layout_type'];
					
		return $classes;
	}
	add_filter('body_class','radium_layout_body_class');

}

 
/**
 * Register the required plugins for this theme.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function radium_theme_register_required_plugins() {
 	
 	$framework = radium_framework();
 	
	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(
		/** This is an example of how to include a plugin pre-packaged with a theme 
		array(
			'name'     => 'Revolution Slider Plugin', // The plugin name
			'slug'     => 'revslider', // The plugin slug (typically the folder name)
			'source'   => $framework ->theme_includes_dir . '/plugins/revslider.zip', // The plugin source
			'required' => false,
		),
		*/
		array(
			'name' 		=> 'Radium Forms',
			'slug' 		=> 'radium-forms',
			'source'   	=> $framework ->theme_includes_dir . '/plugins/radium-forms.zip', // The plugin source
			'required' 	=> false,
		),
		array(
			'name' 		=> 'Radium Galleries',
			'slug' 		=> 'radium-galleries',
			'source'   	=> $framework ->theme_includes_dir . '/plugins/radium-galleries.zip', // The plugin source
			'required' 	=> false,
		),
		array(
			'name' 		=> 'Radium PriceTables',
			'slug' 		=> 'radium-pricetable',
			'source'   	=> $framework ->theme_includes_dir . '/plugins/radium-pricetable.zip', // The plugin source
			'required' 	=> false,
			),
 	);
   
	/**
	 * Array of configuration settings. Uncomment and amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * uncomment the strings and domain.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'strings'      	 => array(),
	);
 
	tgmpa( $plugins, $config );
 
}

add_action( 'tgmpa_register', 'radium_theme_register_required_plugins' );



/**
 * Add specific theme elements previews to customizer.
 */

function radium_customizer_preview_init( $wp_customize ) {
	if ( $wp_customize->is_preview() && ! is_admin() ) {
		add_action( 'wp_footer', 'radium_customizer_preview', 21 );
	}
}
add_action( 'customize_register', 'radium_customizer_preview_init' );

/**
 * Setup javascript needed for customizer to link up 
 * to real-time edit options.
 */

if( ! function_exists( 'radium_customizer_preview' ) ) {
	function radium_customizer_preview() {
		// Begin output	
		
		$framework = radium_framework();
		
		// Global option name
		$option_name = $framework->theme_option_name;;
		?>
		<script type="text/javascript">
		window.onload = function() {
		  
			(function($) {
				<?php 
				radium_customizer_preview_logo(); 
				radium_customizer_preview_main_bg();
				radium_customizer_preview_styles();
				?>
				// ---------------------------------------------------------
				// Main Styles
				// ---------------------------------------------------------
				
				/* Primary Color */
				wp.customize('<?php echo $option_name; ?>[layout_type]',function( value ) {
					value.bind(function(body_class) {
						var classes = 'wide boxed';
						$('body').removeClass(classes);
						$('body').addClass(body_class);
						jQuery("body").trigger("resize");
					});
				});
				
				/* Content Color */
				wp.customize('<?php echo $option_name; ?>[theme_style]',function( value ) {
					value.bind(function(body_class) {
						var classes = 'default dark eclipse fabric green green purple';
						$('body').removeClass(classes);
						$('body').addClass(body_class);
					});
				});

				/* Accent Color */
				wp.customize('<?php echo $option_name; ?>[accent_color]',function( value ) {
					value.bind(function(color) {
						
						var css = ".tab-holder .tabs li.active, \
									#sidebar .widget_radium_pages_menu li.current_page_item,\
									.custom-headline { \
										border-color: "+color+"; \
									} \
									.dropcap2, \
									.nav-hori ul li a.active, \
									.hr:before, \
									.teaser_more, \
									::selection { \
										background-color: "+color+"; \
									} \
									.list[class^='icon-'] li::before, \
									.list[class*=' icon-'] li::before, \
									#sidebar .widget_radium_pages_menu li.current_page_item a, \
									a:hover, \
									.entry-header h1 a:hover, \
									.entry-header h2 a:hover, \
									.entry-header h3 a:hover { \
										color: "+color+" !important; \
									}";
						
						$('.preview_accent_color').remove();
						$('head').append('<style class="preview_accent_color">'+css+'</style>');
					});
				});
				
 				/* Header BG Color */
				wp.customize('<?php echo $option_name; ?>[boxed_bg_color]',function( value ) {
					value.bind(function(color) {
						
						var css = "body.boxed { background-color: "+color+"; }"
						
						$('.preview_boxed_bg_color').remove();
						$('head').append('<style class="preview_boxed_bg_color">'+css+'</style>');
					});
				});
				
				/* Boxed Layout BG Color */
				wp.customize('<?php echo $option_name; ?>[header_bg_color]',function( value ) {
					value.bind(function(color) {
						
						var css = "#radium_foobar,\
						#header, \
						#top-header { background-color: "+color+"; } "
						
						$('.preview_header_bg_color').remove();
						$('head').append('<style class="preview_header_bg_color">'+css+'</style>');
					});
				});
				
				/* Footer BG Color */
				wp.customize('<?php echo $option_name; ?>[footer_bg_color]',function( value ) {
					value.bind(function(color) {
						
						var css = "#bottom-footer { background-color: "+color+";}"
						
						$('.preview_footer_bg_color').remove();
						$('head').append('<style class="preview_footer_bg_color">'+css+'</style>');
					});
				});
				
			})(jQuery);
		}
		</script>
		<?php
	}
}

/**
 * Logo Customizer Preview
 *
 * Since the Javascript for the logo will get repeated in 
 * many themes, its being placed here so it can be easily 
 * placed in each theme that requires it.
 *
 * @since 2.1.0
 */

if( ! function_exists( 'radium_customizer_preview_logo' ) ) {
	function radium_customizer_preview_logo(){
		
		$framework = radium_framework();
		
		// Global option name
		$option_name = $framework->theme_option_name;;
		
		// Setup for logo
		$logo = radium_get_option('logo');
		 		
		// Begin output	
		?>	
		// Logo object
		Logo = new Object();
		Logo.image = '<?php echo $logo; ?>';
		Logo.site_title = '<?php echo bloginfo( 'name' ); ?>';
		
		/* Logo */
		wp.customize('<?php echo $option_name; ?>[logo]',function( value ) {
			value.bind(function(value) {
				// Set global marker
				Logo.image = value;
				
				// Only do if anything if the proper logo 
				// type is currently selected.
				var html;
				if(value)
				{
					html = '<a href="'+Logo.site_url+'" title="'+Logo.title+'" rel="home"><img src="'+Logo.image+'" alt="'+Logo.title+'" /></a>';
				}
				else
				{
					html = '<h1>'+Logo.site_title+'</h1>';
				}
				$('#branding #logo').html(html);
			});
		});
		<?php 
	}
}

/**
 * Logo Customizer Preview
 *
 * Since the Javascript for the logo will get repeated in 
 * many themes, its being placed here so it can be easily 
 * placed in each theme that requires it.
 *
 * @since 2.1.0
 */

if( ! function_exists( 'radium_customizer_preview_main_bg' ) ) {
	function radium_customizer_preview_main_bg(){
		
		$framework = radium_framework();
		
		// Global option name
		$option_name = $framework->theme_option_name;;
		
		// Setup for main_bg
		$main_bg = radium_get_option('main_bg');
		 		
		// Begin output	
		?>	
		// Logo object
		main_bg = new Object();
		main_bg.image = '<?php echo $main_bg; ?>';
		
		/* main_bg */
		wp.customize('<?php echo $option_name; ?>[main_bg]',function( value ) {
			value.bind(function(value) {
				// Set global marker
				main_bg.image = value;
				
				// type is currently selected.

				if(value) {
				
					jQuery.backstretch(main_bg.image);
					
				} else {
					
					jQuery.backstretch(radium_framework_globals.main_bg_images);
					
				}
 			});
		});
		
		
		<?php 
	}
}


/**
 * Custom CSS Customizer Preview
 *
 * Since the Javascript for the fonts will get repeated in 
 * many themes, its being placed here so it can be easily 
 * placed in each theme that requires it.
 *
 * @since 2.1.0
 */

if( ! function_exists( 'radium_customizer_preview_styles' ) ) {
	function radium_customizer_preview_styles(){
		
		$framework = radium_framework();
		
		// Global option name
		$option_name = $framework->theme_option_name;
		
		// Output
		?>		
		/* Custom CSS */
		wp.customize('<?php echo $option_name; ?>[custom_styles]',function( value ) {
			value.bind(function(css) {
				$('.preview_custom_styles').remove();
				$('head').append('<style class="preview_custom_styles">'+css+'</style>');		
			});
		});
		<?php 
	}
}

