<?php
/** 
 * Register map Form Element
 * @return array();
 */
function radium_builder_registar_map_element( $elements ) {

	//map Form
	$element_map = array(
	
		array(
				'id' 	=>'address',
				'std' 	=> 'New York',
				'type' 	=> 'text',
				'label' => __('Map Address:', 'radium'),
				'desc' 	=> __('', 'radium')
			),
		
		 	array(
		 		'id' 	=>'width',
		 		'std' 	=> '100%',
				'type' 	=> 'text',
				'name' 	=> __('Width:', 'radium'),
				'desc' 	=> __('Map width ', 'radium'),
			),
			
			array(
				'id' 	=>'height',
				'std' 	=> '400',
				'type' 	=> 'text',
				'name' 	=> __('Height:', 'radium'),
				'desc' 	=> __('Map height', 'radium'),
			),
			
			array(
				'id' 	=>'zoom',
				'std' 	=> '14',
				'type' 	=> 'text',
				'name' 	=> __('Map Zoom:', 'radium'),
				'desc' 	=> __('Use 1-19', 'radium'),
			),
			
			array(
				'id' 	=>'html',
				'std' 	=> '',
				'type' 	=> 'text',
				'name' 	=> __('HTML:', 'radium'),
				'desc' 	=> __('What to show in the popup, defaults to address', 'radium'),
			),
			
			array(
				'id' 	=>'popup',
				'std' 	=> '',
				'type' 	=> 'select',
				'name' 	=> __('HTML:', 'radium'),
				'desc' 	=> __('Show or hide the popup, true or false', 'radium'),
				'options' 	=> array(
					'true' 	=> 'True',
					'false' => 'False',
				)
			),
			
			array(
				'id' 	=>'maptype',
				'std' 	=> 'terrain',
				'type' 	=> 'select',
				'name' 	=> __('Type of map:', 'radium'),
				'desc' 	=> __('Type of map - hybrid, satellite, roadmap, or terrain', 'radium'),
				'options' 		=> array(
					'hybrid' 	=> 'Hybrid',
					'satellite' => 'Satellite',
					'roadmap' 	=> 'Roadmap',
					'terrain' 	=> 'Terrain',
					)
			),
				    
	);
	
	$elements['map'] = array(
		'info' => array(
			'name' 	=> 'Map',
			'id'	=> 'map',
			'query'	=> 'none',
			'hook'	=> 'radium_map_block',
			'shortcode'	=> '[radium_map]',
			'desc' 	=> __( 'Google Map', 'radium' )
		),
		'options' => $element_map
	);

	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builder_registar_map_element');	