<?php
/** 
 * Register Columns Element
 * @return array();
 */
function radium_builider_registar_headline_element( $elements ) {
 
	// Headline
	$element_headline = array(
		array(
			'id' 		=> 'text',
			'name'		=> __( 'Headline Text', 'radium' ),
			'desc'		=> __( 'Enter in the text you\'d like to use for your headline.', 'radium' ),
			'type'		=> 'text',
		),
		array(
	    	'id' 		=> 'subtitle',
			'name'		=> __( 'Subtitle', 'radium' ),
			'desc'		=> __( 'Enter any text you\'d like to display below the headline as a tagline.', 'radium' ),
			'type'		=> 'textarea'
		),
 
		array(
			'id' 		=> 'align',
			'name'		=> __( 'Headline Alignment', 'radium' ),
			'desc'		=> __( 'Select how you\'d like the text in this title to align.', 'radium' ),
			'type'		=> 'select',
			'options'		=> array(
		        'left' 		=> __( 'Align Left', 'radium' ),
		        'center' 	=> __( 'Center', 'radium' ),
				'right' 	=> __( 'Align Right', 'radium' )
			) 
		)
	);
	
	$elements['headline'] = array(
			'info' => array(
				'name' 	=> 'Headline',
				'id'	=> 'headline',
				'query'	=> 'none',
				'hook'	=> 'radium_headline',
				'shortcode'	=> false,
				'desc' 	=> __( 'Simple <H> header title', 'radium' )
			),
			'options' => $element_headline
	);
		
	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builider_registar_headline_element');	