<?php

/** 
 * Register Blog Element
 * @return array();
 */
function radium_builider_registar_blog_element( $elements ) {
				
	// Setup array for categories select
	$categories_select = array();
	$categories_select['all'] = __( '<strong>All Categories</strong>', 'radium' );
	$categories = get_categories();
	foreach( $categories as $category )
		$categories_select[$category->slug] = $category->name;
		
	// Setup array for categories group of checkboxes
	$categories_multicheck = $categories_select;
	unset( $categories_multicheck['null'] );
	
	// Post List (lead)
	$element_options = array(
	    array(
	    	'id' 		=> 'categories',
			'name'		=> __( 'Categories', 'radium' ),
			'desc'		=> __( 'Select the categories you\'d like to pull posts from. Note that selecting "All Categories" will override any other selections.', 'radium' ),
			'std'		=> array( 'all' => 1 ),
			'type'		=> 'multicheck',
			'options'	=> $categories_multicheck
		),
		array(
	    	'id' 		=> 'numberposts',
			'name'		=> __( 'Number of Posts', 'radium' ),
			'desc'		=> __( 'Enter in the <strong>total number</strong> of posts you\'d like to show. You can enter <em>-1</em> if you\'d like to show all posts from the categories you\'ve selected.', 'radium' ),
			'type'		=> 'text',
			'std'		=> '6'
		),

	 	array(
	 		'id'		=> 'ctp_page_columns',
	 		'name'		=> __( 'Number of columns ', 'radium' ),
	 		'desc'		=> __( '' , 'radium' ),
	 		'std'		=> 'three-columns',
	 		'type'		=> 'select',
	 		'options'			=> array(
	 	       //'modern-grid' => 'Modern Grid',
	 	       'two-columns' => 'Two Columns',
	 	       'one-column' => 'One Column',
	 	       'small-thumbs' => 'One Column with small thumbs',
	 		)
	 	),	
	 	array(
	 		'name' =>__('Show pagination','radium'),
	 		'id'   => 'cpt_pagination',
	 		'type' => 'checkbox',
	 		'std'  => '1',
	 	),    
	 	
	);
	

	$elements['blog'] = array(
			'info' => array(
				'name' 	=> 'Blog',
				'id'	=> 'blog',
				'query'	=> 'none',
				'hook'	=> null,
				'shortcode'	=> false,
				'desc' 	=> __( 'Blog content', 'radium' )
			),
			'options' => $element_options
		);
	
	return $elements;
	
}
add_filter('radium_builder_elements', 'radium_builider_registar_blog_element');	