<?php


/**
 * Add option section for theme customizer 
 * added in WP 3.4
 *
 * @since 2.1.0
 *
 * @param string $section_id ID for section
 * @param string $section_name Name for section
 * @param array $options Options to register for WP theme customizer
 * @param int $priority Priority for section
 */
 
if( ! function_exists( 'radium_add_customizer_section' ) ) {
	function radium_add_customizer_section( $section_id, $section_name, $options, $priority = null ){
		global $_radium_customizer_sections;
		$_radium_customizer_sections[$section_id] = array(
			'id' 		=> $section_id,
			'name' 		=> $section_name,
			'options' 	=> $options,
			'priority'	=> $priority
		);
	}
}

/**
 * Format options for customizer into array organized 
 * with all sections together.
 *
 * This is needed because WordPress's customizer groups 
 * all options together when saving and doesn't take 
 * sections into account. So, we need to organize all 
 * options into an array that we can check against when 
 * saving our options in our custom action added to the 
 * WordPress customizer saving process.
 *
 * The structure of the array returned with this function 
 * is formatted in a specific way to work with the function 
 * "radium_save_customizer"
 *
 * @since 2.1.0
 *
 * @param array $options Options to format
 */
 
if( ! function_exists( 'radium_registered_customizer_options' ) ) {
	function radium_registered_customizer_options( $sections ){
		$registered_options = array();
		if( $sections ){
			foreach( $sections as $section ){
				if( $section['options'] ){
					foreach( $section['options'] as $option ){
						$registered_options[$option['id']] = $option;
					}
				}
			}
		}
		return $registered_options;
	}
}

/**
 * Setup everything we need for WordPress customizer.
 *
 * All custom controls used in this function can be 
 * found in the following file:
 *
 * @since 2.1.0
 */

if( ! function_exists( 'radium_customizer_init' ) ) {
	function radium_customizer_init( $wp_customize ){

		global $_radium_customizer_sections;
	
		$framework = radium_framework();
		
		// Global option name
		$option_name = $framework->theme_option_name;
				
		// Alter current theme options and only modify our select 
		// options controlled with the customizer.
		$theme_options = get_option( $option_name );
						
		// Register sections of options
		if( $_radium_customizer_sections ) {
			foreach( $_radium_customizer_sections as $section ){
				
				// Add section
				$wp_customize->add_section( $section['id'], array(
					'title'    => $section['name'],
					'priority' => $section['priority'],
				) );
				
				$font_counter = 1;
				
				// Add Options
				if( $section['options'] ){
					foreach( $section['options'] as $option ) {
							
						// Default
						$default = '';
						if( isset( $theme_option_defaults[$option['id']] ) )
							$default = $theme_option_defaults[$option['id']];
						
						// Transport
						$transport = '';
						if( isset( $option['transport'] ) )
							$transport = $option['transport'];
						
						$priority = '';
						if( isset( $option['priority'] ) )
							$priority = $option['priority'];
						
						// Register option
						$wp_customize->add_setting( $option_name.'['.$option['id'].']', array(
							'default'    	=> esc_attr( $default ),
							'type'       	=> 'option',
							'capability' 	=> 'edit_theme_options',
							'transport'		=> $transport
						) );
					
						// Add controls
						switch( $option['type'] ) {
							
							// Standard text option
							case 'logo' :
								$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $option['id'].'_image', array(
									'priority'		=> 4,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id']
								) ) );
								break;
							
							// Standard text option
							case 'main_bg' :
								$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, $option['id'].'_image', array(
									'priority'		=> 4,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id']
								) ) );
								break;
									
							// Standard text option
							case 'text' :
								$wp_customize->add_control( $option['id'], array(
									'priority'		=> $priority,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id']
								) );
								break;
							// Textarea
							case 'textarea' :
								$wp_customize->add_control( new WP_Customize_radium_Textarea( $wp_customize, $option['id'], array(
									'priority'		=> $priority,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'   		=> $option['name'],
									'section' 		=> $section['id']
								) ) );
								break;
							// Select box
							case 'select' :
								$wp_customize->add_control( $option['id'], array(
									'priority'		=> $priority,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id'],
									'type'			=> 'select',
									'choices'		=> $option['options']
								) );
								break;
							// Radio set
							case 'radio' :
								$wp_customize->add_control( $option['id'], array(
									'priority'		=> $priority,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id'],
									'type'			=> 'radio',
									'choices'		=> $option['options']
								) );
								break;
							// Color
							case 'color' :
								$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $option['id'], array(
									'priority'		=> $priority,
									'settings'		=> $option_name.'['.$option['id'].']',
									'label'			=> $option['name'],
									'section'		=> $section['id']
								) ) );
								break;	
						}
						
					}
				}
			}
		}

	}
}

/**
 * Styles for WordPress cusomizer.
 *
 * @since 2.1.0
 */ 

if( ! function_exists( 'radium_customizer_styles' ) ) {
	function radium_customizer_styles(){
		wp_register_style( 'radium_skin_customizer', get_template_directory_uri().'/framework/skins/assets/css/customizer.css', false, '1.0' );
		wp_enqueue_style( 'radium_skin_customizer' );
	}
}

/**
 * Scripts for WordPress cusomizer.
 *
 * @since 2.1.0
 */ 

if( ! function_exists( 'radium_customizer_scripts' ) ) {
	function radium_customizer_scripts(){
		wp_register_script( 'radium_skin_customizer', get_template_directory_uri().'/framework/skins/assets/js/customizer.min.js', array('jquery'), '1.0');
	    wp_enqueue_script( 'radium_skin_customizer' );
	}
}

/**
 * Customizer control extensions. 
 */

if( class_exists( 'WP_Customize_Control' ) ) {
	
	/**
	 * Add control for textarea. 
	 */
	
	class WP_Customize_radium_Textarea extends WP_Customize_Control {
		
		public $type = 'textarea';
		public $statuses;
	
		public function __construct( $manager, $id, $args = array() ) {
			$this->statuses = array( '' => __('Default', 'radium' ) );
			parent::__construct( $manager, $id, $args );
		}
		
		public function to_json() {
			parent::to_json();
			$this->json['statuses'] = $this->statuses;
		}
		
		public function render_content() {
			?>		
			<label>
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<textarea <?php $this->link(); ?>><?php echo esc_attr( $this->value() ); ?></textarea>
			</label>
			<?php
		}
	
	} 
	
	/**
	 * Add control to select font face. 
	 *
	 * This is very similar to default select option but with our 
	 * added class that allows us to use it as reference for the 
	 * Google font input.
	 */
	
	class WP_Customize_radium_Font_Face extends WP_Customize_Control {
		
		public $type = 'font_face';
		public $statuses;
	
		public function __construct( $manager, $id, $args = array() ) {
			$this->statuses = array( '' => __( 'Default', 'radium' ) );
			parent::__construct( $manager, $id, $args );
		}
		
		public function enqueue() {
			wp_enqueue_script( 'radium_customizer' );
			wp_enqueue_style( 'radium_customizer' );
		}
		
		public function to_json() {
			parent::to_json();
			$this->json['statuses'] = $this->statuses;
		}
		
		public function render_content() {		
			if ( empty( $this->choices ) )
				return;
			?>
			<label class="radium-font-face">
				<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
				<select <?php $this->link(); ?>>
					<?php
					foreach ( $this->choices as $value => $label )
						echo '<option value="' . esc_attr( $value ) . '"' . selected( $this->value(), $value, false ) . '>' . $label . '</option>';
					?>
				</select>
			</label>
			<?php
		}
		
	}
	
	/**
	 * Add control for divider. 
	 */
	
	class WP_Customize_radium_Divider extends WP_Customize_Control {
		
		public $type = 'divider';
		public $statuses;
	
		public function __construct( $manager, $id, $args = array() ) {
			$this->statuses = array( '' => __('Default', 'radium' ) );
			parent::__construct( $manager, $id, $args );
		}
		
		public function render_content() {
			?>		
			<div class="radium-divider"></div>
			<?php
		}
	
	} 

} // End if class_exists('WP_Customize_Control')
