<?php
/*

Based on 

Plugin Name: Meta Box
Plugin URI: http://www.deluxeblogtips.com/meta-box
Description: Create meta box for editing pages in WordPress. Compatible with custom post types since WP 3.0
Version: 4.1.11
Author: Rilwis
Author URI: http://www.deluxeblogtips.com
License: GPL2+

Modified by Radiumthemes.com for the radium framework
*/
$framework = radium_framework();

// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

// Script version, used to add version for scripts and styles
define( 'RWMB_VER', '4.1.11' );

// Define plugin URLs, for fast enqueuing scripts and styles
if ( ! defined( 'RWMB_URL' ) )
	define( 'RWMB_URL', $framework->theme_framework_url . '/metaboxes/' );
	
define( 'RWMB_JS_URL', RWMB_URL . 'js/' );
define( 'RWMB_CSS_URL', RWMB_URL . 'css/' );

// Plugin paths, for including files
if ( ! defined( 'RWMB_DIR' ) )
	define( 'RWMB_DIR', plugin_dir_path( __FILE__ ) );
define( 'RWMB_INC_DIR', trailingslashit( RWMB_DIR . 'inc' ) );
define( 'RWMB_FIELDS_DIR', trailingslashit( RWMB_INC_DIR . 'fields' ) );
define( 'RWMB_CLASSES_DIR', trailingslashit( RWMB_INC_DIR . 'classes' ) );

// Optimize code for loading plugin files ONLY on admin side
// @see http://www.deluxeblogtips.com/?p=345

// Helper function to retrieve meta value
require_once RWMB_INC_DIR . 'helpers.php';

if ( is_admin() ) {
	// Field classes
	foreach ( glob( RWMB_FIELDS_DIR . '*.php' ) as $file ) {
		require_once $file;
	}

	// Main file
	require_once RWMB_CLASSES_DIR . 'meta-box.php';
}

/**
 * Register meta boxes
 *
 * @since 2.1.0
 * @return void
 */
function radium_register_meta_boxes() {

	global $meta_boxes;

	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if ( class_exists( 'RW_Meta_Box' ) ) {
		foreach ( $meta_boxes as $meta_box ) {
							
			new RW_Meta_Box( $meta_box );
			
		}
	}
}

/**
* Check if theme supports metaboxes and hook into 'admin_init' to make sure the meta box 
* class is loaded before (in case using the meta box class in another plugin)
* This is also helpful for some conditionals like checking page template, categories, etc. 
*/
if( $framework->theme_supports( 'primary', 'meta' ) )
	add_action( 'admin_init', 'radium_register_meta_boxes' );

