<?php 
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/*
 * Radium Framework Core - A WordPress theme development framework.
 * 
 * This file is a part of the RadiumFramework core.
 * Please be extremely cautious editing this file,
 *
 * @category RadiumFramework
 * @package  MetroCorp WP
 * @author   Franklin M Gitonga
 * @link     http://radiumthemes.com/
 */
 
/* ---------------------------------------------------------------------- */
/*	Sidebar Loader
/* ---------------------------------------------------------------------- */
function radium_sidebar_loader( $_radium_sidebar_location = '' ) {

	global $post, $radium_sidebar_location, $radium_sidebar_class, $radium_content_class;
		
	$framework = radium_framework();
	
	$options = $framework->options;
	
	if ( 'post'== get_post_type() && is_single() && ( get_post_meta ($post->ID, '_radium_page_layout', true) == '') ) {
	
		$radium_sidebar_location = isset($options['single_post_layout']) ? $options['single_post_layout'] : null;
	
	} elseif ( 'portfolio'== get_post_type() && is_singular('portfolio') && ( get_post_meta ($post->ID, '_radium_page_layout', true) == '') ) {
	
		$radium_sidebar_location = isset($options['single_portfolio_layout']) ?  $options['single_portfolio_layout'] : null;

	} elseif ( 'gallery'== get_post_type() && is_singular('gallery') && ( get_post_meta ($post->ID, '_radium_page_layout', true) == '') ) {

		$radium_sidebar_location = isset($options['single_gallery_layout']) ? $options['single_gallery_layout'] : null;
	
	} elseif ( $_radium_sidebar_location !== '' ) {
		
		$radium_sidebar_location = $_radium_sidebar_location;
	
	} elseif ( !is_404() && !is_search() ) {
	
		//Setup Sidebar (its also overrides post and archive setting from admin panel) 
		$radium_sidebar_location = get_post_meta ($post->ID, '_radium_page_layout', true);
    		
	}
	
	$radium_sidebar_class = null;
	$radium_content_class = null;
	
	if ( $radium_sidebar_location === 'right' ) {
	
		$radium_sidebar_class = "three columns sidebar-right";
		$radium_content_class = "nine columns";  
	
	} elseif ( $radium_sidebar_location === 'left' ) {
	 
		$radium_sidebar_class = "three columns pull-nine sidebar-left"; 
		$radium_content_class = "nine columns push-three"; 
		
	} else { 
	
		$radium_content_class = "twelve columns"; 
		
	}	
	
	return apply_filters( 'radium_sidebar_loader', $radium_sidebar_location );
}


//*-----------------------------------------------------------------------------------*/
/*	Adds custom classes to the array of body classes.
/*-----------------------------------------------------------------------------------*/
function radium_browser_body_class($classes) {

	global $post,  $radium_sidebar_location, $is_lynx, $is_gecko, $is_IE, $is_opera, $is_NS4, $is_safari, $is_chrome, $is_iphone;
		
	$framework = radium_framework();
	
	$options = $framework->options;
		
	$radium_sidebar_location = radium_sidebar_loader();
	
	if($is_lynx) $classes[] = 'lynx';
	elseif($is_gecko) $classes[] = 'gecko';
	elseif($is_opera) $classes[] = 'opera';
	elseif($is_NS4) $classes[] = 'ns4';
	elseif($is_safari) $classes[] = 'safari';
	elseif($is_chrome) $classes[] = 'chrome';
	elseif($is_IE) {
	    $classes[] = 'ie';
	    $browser = $_SERVER[ 'HTTP_USER_AGENT' ];
	    if( preg_match( "/MSIE 7.0/", $browser ) ) {
	        $classes[] = 'ie7';
	    }
    }
	else $classes[] = 'unknown';

	if($is_iphone) $classes[] = 'iphone';
	
	if ( is_singular() || is_404() ) {
		$classes[] = 'singular';
	} else {
		$classes[] = 'not-singular';
	}
	
	// Adds a class of group-blog to blogs with more than 1 published author
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}
	
	if ( $radium_sidebar_location === 'left'  ) {
	
		$classes[] = 'left-sidebar with-sidebar';
		
	} elseif ( $radium_sidebar_location === 'right') {
	
		$classes[] = 'right-sidebar with-sidebar';
		
	}
		
	return $classes;
}
add_filter('body_class','radium_browser_body_class');


/**
 * Compress a chunk of code to output.
 *
 * @since 2.1.0
 * 
 * @param string $buffer Text to compress
 * @param string $buffer Buffered text 
 */

if( ! function_exists( 'radium_code_compress' ) ) {  
	function radium_code_compress( $buffer ) {
		/* remove comments */
		$buffer = preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $buffer);
		/* remove tabs, spaces, newlines, etc. */
		$buffer = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '    ', '    '), '', $buffer);
		return $buffer;
	}
}


//*-----------------------------------------------------------------------------------*/
/*	add home link to menu
/*-----------------------------------------------------------------------------------*/

if ( !function_exists('radium_home_page_menu_args') ) {

	function radium_home_page_menu_args( $args ) {
		$args['show_home'] = true;
		return $args;
	}
	add_filter( 'wp_page_menu_args', 'radium_home_page_menu_args' );

}


/* ---------------------------------------------------------------------- */
/*	Return template part
/* ---------------------------------------------------------------------- */

if ( !function_exists('radium_load_template_part') ) {

	function radium_load_template_part( $template_name, $part_name = null ) {

		ob_start();
			get_template_part( $template_name, $part_name );
			$output = ob_get_contents();
		ob_end_clean();

		return $output;

	}

}


/* ---------------------------------------------------------------------- */
/*	Check the current post for the existence of a short code 
/* ---------------------------------------------------------------------- */

if ( !function_exists('radium_has_shortcode') ) {

	function radium_has_shortcode($shortcode = '') {
		
		if ( !is_404() ) {
			global $post;
			
			$post_obj = get_post( $post->ID );
			$found = false;
			
			// if no short code was provided, return false
			if ( !$shortcode )
				return $found;
				
			// check the post content for the short code
			if ( stripos( $post_obj->post_content, '[' . $shortcode ) !== false )
			
				// we have found the short code
				$found = true;
	
			// return our final results  
			return $found;
		}
	}
}


/* ---------------------------------------------------------------------- */
/*	Get Custom Field
/* ---------------------------------------------------------------------- */

if ( !function_exists('radium_get_custom_field') ) {

	function radium_get_custom_field( $key, $post_id = null ) {

		global $wp_query;
		
		$post_id = $post_id ? $post_id : $wp_query->get_queried_object()->ID;
		
		return get_post_meta( $post_id, $key, true );

	}

}


/* ---------------------------------------------------------------------- */
/*	Get Custom Taxonomies List. Usage: echo radium_custom_taxonomies_terms_links();
/*  This will List all Taxonomies
/* ---------------------------------------------------------------------- */

if ( !function_exists('radium_custom_taxonomies_terms_links') ) {
	
	function radium_custom_taxonomies_terms_links() {
		global $post, $post_id;
		
		// get post by post id
		$post = &get_post($post->ID);
		
		// get post type by post
		$post_type = $post->post_type;
		
		// get post type taxonomies
		$taxonomies = get_object_taxonomies($post_type);
		foreach ($taxonomies as $taxonomy) {
			// get the terms related to post
			$terms = get_the_terms( $post->ID, $taxonomy );
			if ( !empty( $terms ) ) {
				$out = array();
				foreach ( $terms as $term )
					$out[] = '<a href="' .get_term_link($term->slug, $taxonomy) .'">'.$term->name.'</a>';
				$return = join( ', ', $out );
			}
		}
		
		return $return;
	}

}


/*-----------------------------------------------------------------------------------*/
/*	Get related posts by taxonomy
/*-----------------------------------------------------------------------------------*/
if ( !function_exists('radium_get_posts_related_by_taxonomy') ) {

	function radium_get_posts_related_by_taxonomy($post_id, $taxonomy, $args=array()) {
	
		$query = new WP_Query();
		$terms = wp_get_object_terms($post_id, $taxonomy);
		if (count($terms)) {
		
		// Assumes only one term for per post in this taxonomy
		$post_ids = get_objects_in_term($terms[0]->term_id,$taxonomy);
		$post = get_post($post_id);
		$args = wp_parse_args($args,array(
		  'post_type' => $post->post_type, // The assumes the post types match
		  //'post__in' => $post_ids,
		  'post__not_in' => array($post_id),
		  'taxonomy' => $taxonomy,
		  'term' => $terms[0]->slug,
		  'orderby' => 'rand',
		  'posts_per_page' => -1
		));
		$query = new WP_Query($args);
		}
		return $query;
	}

}


/*-----------------------------------------------------------------------------------*/
/* Add some item to Admin Bar for easier navigation  (frontend and backend)
/*-----------------------------------------------------------------------------------*/

/* Create admin Bar Menu from tabs*/
if (!function_exists("radium_add_toolbar_items")) {
	
	function radium_add_toolbar_items($admin_bar){
		
		$framework = radium_framework();
		
		if(!current_user_can('edit_theme_options')) return;
		
		global $wp_admin_bar;
		
			$urlthemesBase = admin_url( 'themes.php' );
			$urlpagesBase = admin_url( 'edit.php' );
			
			$admin_bar->add_menu( 
				array(
					'id'    => 'radiumthemes-options',
					'title' => __('Theme Settings','radium'),
					'href'  => $urlthemesBase.'?page=radium_theme_options',	
					'meta'  => array(
						'title' => __('Theme Options','radium'),			
					),
				)
			);
			// Add sub menu link "View All Theme Options"
			$wp_admin_bar->add_node( array(
				'parent' => 'radiumthemes-options',
				'id'     => 'radium_builder',
				'title' => __( 'Template Builder','radium'),
				'href' => $urlthemesBase.'?page=radium_builder',
			));	
			
			// Add sub menu link "View All Theme Options"
			$wp_admin_bar->add_node( array(
				'parent' => 'radiumthemes-options',
				'id'     => 'radium_theme_options',
				'title' => __( 'Theme Options','radium'),
				'href' => $urlthemesBase.'?page=radium_theme_options',
			));
			
			// Add sub menu link "View All Slider"
			$wp_admin_bar->add_node( array(
				'parent' => 'radiumthemes-options',
				'id'     => 'radium_theme_sliders',
				'title' => __( 'Sliders','radium'),
				'href' => $urlpagesBase.'?post_type=slider',
			));
	}
	add_action('admin_bar_menu', 'radium_add_toolbar_items', 100);
	
}


/**
 * Test whether an feature is currently supported.
 *
 * @since 2.1.0
 *
 * @param string $group admin or frontend
 * @param string $feature feature key to check
 * @return boolean
 */
 
function radium_supports( $group, $feature ) {
	
	$framework = radium_framework();

	$setup = $framework->feature_setup();
	if( isset( $setup[$group][$feature] ) && $setup[$group][$feature] )
		return true;
	else
		return false;
}


/**
 * Get theme option
 *
 * @since 2.1.0
 * @uses $_radium_theme_options
 */

if( ! function_exists( 'radium_get_option' ) ) {
	function radium_get_option( $primary, $seconday = null, $default = false ) {
		
		$framework = radium_framework(); // We pull from the framework data array, so we're not using WordPress's get_option every single time.
		
		$options = $framework->options ;
		
		if( isset( $options[$primary] ) ) {
			if( $seconday ) {
				if( is_array( $options[$primary] ) && isset( $options[$primary][$seconday] ) )
					$option = $options[$primary][$seconday];
			} else {
				$option = $options[$primary];
			}
		}
		
		if( ! isset( $option ) ) {
			if( $default ) {
				$option = $default;
			}
		}
		
		if( ! isset( $option ) ) $option = null;
		
		return $option;
	}
}

/**
 * Retrieves a post id given a post's slug and post type.
 *
 * @since 2.1.0
 * @uses $wpdb
 *
 * @param string $slug slug of post
 * @param string $post_type post type for post.
 * @return string $id ID of post.
 */
function radium_post_id_by_name( $slug, $post_type ) {
	global $wpdb;
	$null = null;
	$slug = sanitize_title( $slug );
	
	// Grab posts from DB (hopefully there's only one!)
	$posts = $wpdb->get_results( $wpdb->prepare( "SELECT ID FROM $wpdb->posts WHERE post_name = %s AND (post_type = %s)", $slug, $post_type ));
	
	// If no results, return null
	if ( empty($posts) )
		return $null;
	
	// Run through our results and return the ID of the first. 
	// Hopefully there was only one result, but if there was 
	// more than one, we'll just return a single ID.
	foreach ( $posts as $post )
		if( $post->ID )
			return $post->ID;
	
	// If for some odd reason, there was no ID in the returned 
	// post ID's, return nothing.
	return $null;
}


/**
 * Remove trailing space from string.
 *
 * @since 2.0.0 
 *
 * @param string $string Current string to check
 * @param string $char Character to remove from end of string if exists
 * @return string $string String w/out trailing space, if it had one
 */
 
if( ! function_exists( 'radium_remove_trailing_char' ) ) {
	function radium_remove_trailing_char( $string, $char = ' ' ) {
		$offset = strlen( $string ) - 1;
		$trailing_char = strpos( $string, $char, $offset );
		if( $trailing_char )
			$string = substr( $string, 0, -1 );
		return $string;
	}
}


/**
/* Create a theme options feed
 * Since the options panel is only loaded in the admin, this has been placed here instead of the admin panel so 
 * that we don't have to load the entire options panel in the frontend when migrating/backing-up options
 *
 * Download the options file, or display it
 *
 * @since Radium_Options 2.0.1
 */

//we need the framework here too
$framework = radium_framework();
 
if (!function_exists("radium_download_options")) {

	function radium_download_options(){
				
		if(!isset($_GET['secret']) || $_GET['secret'] != md5(AUTH_KEY.SECURE_AUTH_KEY)){wp_die('Invalid Secret for options use');exit;}
		if(!isset($_GET['feed'])){wp_die('No Feed Defined');exit;}
		$backup_options = get_option(str_replace('radiumopts-','',$_GET['feed']));
		$backup_options['radium-opts-backup'] = '1';
		$content = '###'.serialize($backup_options).'###';
		
		if(isset($_GET['action']) && $_GET['action'] == 'download_options'){
			header('Content-Description: File Transfer');
			header('Content-type: application/txt');
			header('Content-Disposition: attachment; filename="'.str_replace('radiumopts-','',$_GET['feed']).'_'.date('d-m-Y').'.txt"');
			header('Content-Transfer-Encoding: binary');
			header('Expires: 0');
			header('Cache-Control: must-revalidate');
			header('Pragma: public');
			echo $content;
			exit;
		}else{
			echo $content;
			exit;
		}
	}
	add_action('do_feed_radiumopts-'. $framework->theme_option_name,  'radium_download_options', 1, 1);
	
}
