<?php
/**
 * The template for displaying the footer.
 *
 * @package RadiumFramework
 * @subpackage MetroCorp
 * 
 * 
 * @since RadiumFramework 1.0.0
 */
 
 $framework = radium_framework();

 $options = $framework->options;
 
 do_action('radium_after_content_container');
 do_action('radium_before_footer'); 
 ?>
</section>
<footer id="bottom-footer">
	<div class="row">
		<div class="twelve columns">
			
			<?php do_action('radium_before_footer_widgets'); ?>
	
			<div class="container">
			
			 	<aside id="footer-widgets" class="clearfix">
			 	
		 		  <?php 
		 			// Footer widgetized area
		 			$footer_widget_count = null;
		 			$footer_widget_left_count = null;
		 			$footer_widget_right_count = null;
		 			$footer_layout = null;
		 		
		 			if(isset($options['footer_layout']))
		 				$footer_layout = $options['footer_layout'];
		 			
		 			 if ( $footer_layout == '50-25-25' ) {
		 					
 						$footer_widget_left_count = 1;
 						$footer_widget_right_count = 2; 
 						 
 						?>
 						<div class="widget_row">
 							<?php
 							   for($i = 1; $i<= $footer_widget_left_count; $i++) {
 							       echo '<div class="widget widget_'.$footer_widget_left_count.'">';
 							           if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Footer Widgets Left') ) : endif;
 							       echo '</div><!-- END div.widget_'.$footer_widget_left_count.' -->';
 							   }
 							?>
 						</div> 
 						<div class="widget_row">
 							<?php
 							   for($i = 1; $i<= $footer_widget_right_count; $i++) {
 							       echo '<div class="widget widget_'.$footer_widget_right_count.'">';
 							           if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Footer Widget Right '.$i) ) : endif;
 							       echo '</div><!-- END div.widget_'.$footer_widget_right_count.' -->';
 							   }
 							?> 
 						</div>
			 				
		 			<?php } else {
		 				
		 				switch ( $footer_layout ) { 
		 				
		 					case '100':
		 						$footer_widget_count = 1; 
		 						break;
		 						
			 				case '50-50':  
			 					$footer_widget_count = 2; 
			 					break;
			 					
		 					case '33-33-33':
		 						$footer_widget_count = 3; 
		 						break;
		 					
		 					case '25-25-25-25':
		 						$footer_widget_count = 4; 
		 						break;
		 					
		 					default:
		 						break;
		 					
		 				}	
		 				 
		 				?>
		 				
		 				<div class="widget_row">
		 					<?php
		 					   for($i = 1; $i<= $footer_widget_count; $i++) {
		 					       echo '<div class="widget widget_'.$footer_widget_count.'">';
		 					           if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Footer Widgets '.$i) ) : endif;
		 					       echo '</div><!-- END div.widget_'.$footer_widget_count.' -->';
		 					   }
		 					?>
		 				</div> 
			 			
					<?php } ?>
					
 				</aside>
				
				<?php do_action('radium_after_footer_widgets'); ?>
						 	
		 	</div>
 		</div>
 	</div>
  	<div id="colophon" role="contentinfo">	
 		<div class="row">
 		
 		 	<div class="six columns">
 		 		<?php do_action('radium_copyright'); ?>
 		 	</div>
 		 	
 			<div id="footer-menu">
 			 	<div class="six columns">
 			 		<!-- Footer Nav-->
 			 		<?php if (function_exists( "wp_nav_menu")) : 
 			 			
 			 				$args = array(
 			 					'menu' => 'Footer Nav',
 			 					'sort_column' => 'menu_order',
 			 					'theme_location' => 'footer-menu',
 			 	    			'fallback_cb' => 'none',
 			 					'container' => 'ul',
 			 					'menu_class' => 'foot-nav',
 			 					'depth' => '1' 
 			 				);
 			 				
 			 				wp_nav_menu(apply_filters('radium_footer_menu_args', $args));
 			 					
 			 			endif; 
 			 		?>
 			 		<!--End Footer Nav -->
 		 		</div>
 			</div><!--End #Footer-menu -->
 			
 		</div>
 	</div><!--End #colophon-->
 	
</footer>
<?php do_action('radium_after_footer');  ?>
</div><!-- #body-wrapper -->
<?php
do_action('radium_developer');

radium_analytics(false); 

wp_footer();  
?>
</body>
</html>