<?php
/**
 * The Single Posts template file.
 */
$framework = radium_framework();

get_header(); 

radium_sidebar_loader(); 

?>
<div class="row">
	<div id="main" class="<?php echo $radium_content_class; ?>" role="main">
	
	    <?php do_action('radium_before_post'); ?>
	    
		<div id="post-box">
	
			<?php 
		
			if (have_posts()) : 
				
				do_action('radium_before_post_content');
			
				while (have_posts()) : the_post();
			    	
				    $format = get_post_format(); 
				    
				    if( false === $format ) { $format = 'standard'; }
			    	
			    	get_template_part( 'includes/content/content', $format );  
			
				endwhile; 
				
				do_action('radium_after_post_content');
				
				// If the theme supports comments in posts and comments are open or we have at least one comment, load up the comment template
				if( $framework->theme_supports( 'comments', 'posts' ) && ( comments_open() || '0' != get_comments_number() )  ) comments_template( '', true );  
	 		 
			 endif; ?>
			
	 	</div><!-- #postbox -->
	 	
		<?php do_action('radium_after_post'); ?>
		
	</div><!-- #main -->
	
	<?php 
		
		if ( function_exists( 'dynamic_sidebar' ) && function_exists( 'is_active_sidebar' ) ) { 
	
			if ( $radium_sidebar_location === 'left' || $radium_sidebar_location === 'right' ) { ?>
		 
			<aside id="sidebar" class="<?php echo $radium_sidebar_class; ?>">
				<div id="sidebar-main" class="sidebar">
					<?php get_sidebar('Internal Sidebar'); ?>
				</div><!--sidebar-main-->
			</aside>
		
			<?php }
	} ?>
</div>
<?php get_footer(); ?>
