<?php
/**
 * Template Name: Blog Grid
 *  
 * @package MetroCorp
 * @since RadiumFramework 2.1.0
 */

get_header(); 

$framework = radium_framework();

$options = $framework->options;

//Setup Sidebar
radium_sidebar_loader(); 

//Get Global Page Settings
$page_items = get_post_meta ($post->ID, '_radium_cpt_items_count', true);
         
//Pagination Loader
$paged = 1;

if ( get_query_var('paged') ) $paged = get_query_var('paged');
if ( get_query_var('page') ) $paged = get_query_var('page');

//Check if sidebar is active
if ( $radium_sidebar_location  !== 'none' ) { $sidebar_check = "withsidebar"; } else { $sidebar_check = "fullwidth"; }
 
$blog_type 	= get_post_meta ($post->ID, '_radium_blog_layout', true);
 
//image resizer settings
$crop = true; //resize but retain proportions
$single = true; //return array

?>
<div class="row">
	<div id="main" class="<?php echo $radium_content_class; ?> " role="main">
	
	    <?php do_action('radium_before_content'); ?>
	    
		<div id="post-box" >
			
			<?php 
			
			//Load Query
			$args = array(
			    'post_type' 		=> 'post',
 			    'order' 			=> 'DESC',
			    'posts_per_page' 	=> $page_items,
			    'paged' 			=> $paged
			);  
			
			$framework = radium_framework();
			
			query_posts( $args );
			
			if ( $blog_type == 'one-column' ) :
				
				if (have_posts()) : while (have_posts()) : the_post(); 
					
					global $more; 
					$more = false;
					$format = get_post_format();
					 
					if( false === $format ) { $format = 'standard'; }
					if( $format == 'aside' || $format == 'gallery' || $format == 'link' || $format == 'quote' || $format == 'status') { }
				
				    get_template_part( 'includes/content/content', $format ); 
									
				endwhile; else : 
				
					get_template_part( 'includes/content/content', 'not-found' ); 
				
				endif;
				
			else :
			 
				if ( $blog_type == 'two-columns') {
				
					$type = array( 
					
						1 => array( 
							0 => 'small',
							1 => 'small',
						) 
					);
				
					$reset_counter_at = 2;
						
				} elseif ( $blog_type == 'small-thumbs') {
				
					$type = array( 
					
						1 => array( 
							0 => 'small-thumbs',
	 					) 
					);
					
					$reset_counter_at = 2;
					
	 			} else {	
				
					$type = array( 
					
						1 => array( 
							0 => 'big',
							1 => 'small',
							2 => 'small'
						),
						
						2 => array( 
							0 => 'big',
							1 => 'mini',
							2 => 'mini',
							3 => 'mini'
							
						),
						
						3 => array( 
							0 => 'small',
							1 => 'small',
							2 => 'mini',
							3 => 'mini',
							4 => 'mini'
						) 
					);
					$reset_counter_at = 4;
				}
				?>
				         
				<section id="blog-grid">
					<div class="blog-grid-container">
					<?php 
					
					$type_counter = 0;
					$which_type = 1;
 					
					if ( have_posts() ) : while ( have_posts() ) : the_post(); 
						
						global $more; 
						$more = false;			
						$format = get_post_format();
												
						if ( $radium_sidebar_location == "" || $sidebar_check == "fullwidth"  ) {
						
							switch (  $type[$which_type][$type_counter] ) {
							
								case 'mini':
									
									$thumb_w = 290; //Define width
									$thumb_h = 120; // Define height
									$text_lenght= '10';
								
									break;
								
								case 'small':
									
									$thumb_w = 449; //Define width
									$thumb_h = 170; // Define height
									$text_lenght= '10'; //number of words
								
									break;
								
								case 'small-thumbs':
									
									$thumb_w = 422; //Define width
									$thumb_h = 210; // Define height
									$text_lenght= '35';
								
									break;
								
								case 'big':
									$thumb_w = 900; //Define width
									$thumb_h = 300; // Define height
									$text_lenght= '10';
								
									break;
									
								default:
									break;		
							}					
							
						} else {
							
							switch (  $type[$which_type][$type_counter] ) {
							
								case 'mini':
									
									$thumb_w = 222; //Define width
									$thumb_h = 100; // Define height
									$text_lenght= '10';
								
									break;
								
								case 'small':
									
									$thumb_w = 350; //Define width
									$thumb_h = 150; // Define height
									$text_lenght = '10'; //number of words
								
									break;
								
								case 'small-thumbs':
									
									$thumb_w = 320; //Define width
									$thumb_h = 190; // Define height
									$text_lenght= '35';
								
									break;
								
								case 'big':
									$thumb_w = 700; //Define width
									$thumb_h = 240; // Define height
									$text_lenght= '10';
								
									break;
									
								default:
									break;		
							}					
							
						}	
											
						if ( $type_counter % count($type[$which_type]) == 0 ) { ?>
							
						<div class="blog-grid-items clearfix"> 
						
						<?php }
						
							$element_class = $type[$which_type][$type_counter];
					
							if ( $type_counter % count($type[$which_type]) == count($type[$which_type]) - 1 )
								$element_class .= ' last';
						
						?>
								
							<div <?php post_class("grid_elements clearfix $element_class"); ?>>
								
								<?php if ( $type[$which_type][$type_counter] !== 'small-thumbs' ) { ?>
									
									<header class="entry-header">
										<h2 class="entry-title"><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
										<?php if ($type[$which_type][$type_counter] !== 'mini') do_action( 'radium_post_grid_meta' ); ?>
									</header><!-- .entry-header -->
								
								<?php }
																
								$embed = get_post_meta($post->ID, '_radium_video_embed', true); ?>
								<?php if ( !empty( $embed ) && !$format == 'video'  ) { ?>
									<div class="entry-content-media">
										<div class='video-frame'>
											<?php echo stripslashes(htmlspecialchars_decode($embed)); ?>
										</div>
									</div>	
								<?php } elseif ( $format=='gallery' ) { ?>
									<div class="entry-content-media">
										<?php radium_gallery( $post->ID, $thumb_w, $thumb_h, $crop, null ); ?>
									</div>
								<?php } else { 
						   			
					   				//Check if post has a featured image set else get the first image from the gallery and use it. If both statements are false display fallback image. 
					   				if ( has_post_thumbnail() ) {
					   					
					   					//get featured image
					   				    $thumb = get_post_thumbnail_id();
					   				    $img_url = wp_get_attachment_url( $thumb,'full' ); //get full URL to image (use "large" or "medium" if the image is too big)
					   				  
					   				}
					   				
					   				$image = empty($img_url) ? get_radium_first_post_image( false ) : radium_resize($img_url, $thumb_w, $thumb_h, $crop, $single);
					   			
					   				if( $image) { ?>
					   					<div class="entry-content-media">
						   					<div class="post-thumb preload">
						   						<a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>" style="height: <?php echo $thumb_h; ?>px; width: <?php echo $thumb_w; ?>px;">
						   							<img src="<?php echo $image ?>" alt="<?php the_title();?>" style="display: block; height: <?php echo $thumb_h; ?>px; width: <?php echo $thumb_w; ?>px;"/>
						   						</a>
						   						<?php if ( $format == 'video' || $format == 'audio'  ) { ?><a href="<?php the_permalink(); ?>" class="jp-video-play-icon" title="<?php _e('Play', 'radium'); ?>"><?php _e('Play', 'radium'); ?></a><?php } ?>
						   					</div>
					   					</div>
					   				<?php } //image
						   				
								} //embed ?>
								<div class="content_wrapper">
									<?php if ( $type[$which_type][$type_counter] == 'small-thumbs' ) { ?>
										
										<header class="entry-header">
											<h2 class="entry-title"><a title="<?php printf(__('Permanent Link to %s', 'radium'), get_the_title()); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
											<?php  do_action( 'radium_post_grid_meta' ); ?>
 										</header><!-- .entry-header -->
									
									<?php }	?>
									<article class="entry-content">
										<?php if ( $type[$which_type][$type_counter] == 'small' || $type[$which_type][$type_counter] == 'small-thumbs' || $type[$which_type][$type_counter] == 'mini') { ?>
												<p><?php echo wp_trim_words( get_the_excerpt(), $text_lenght ); ?></p>
												<p><a href="<?php the_permalink($post->ID); ?>" class="more-link"><span><?php _e( 'Continue Reading &rarr;', 'radium' ); ?></span></a></p>
											<?php } else { ?>	
												<?php the_content( __( '<span>Continue Reading &rarr;</span>', 'radium' ) ); ?>
											<?php } ?>
									</article><!-- .entry-content -->
								</div>
								<?php if ( $type[$which_type][$type_counter] !== 'small-thumbs' || $type[$which_type][$type_counter] !== 'mini' ) do_action( 'radium_post_grid_footer_meta' ); ?>
								
							</div>
								
							<?php if ( $type_counter % count($type[$which_type]) == count($type[$which_type]) - 1 ) { ?><div class="blog-grid-divider clearfix"></div></div><?php }
								
							$type_counter++; 
							
							if ( $type_counter == count($type[$which_type]) ) {
								$which_type++;
								$type_counter = 0;
							}
							
							if ( $which_type == $reset_counter_at )  $which_type = 1; 
																
						endwhile; else : 
						
							get_template_part( 'includes/content/content', 'not-found' ); 
						
						endif; ?>
					
					</div>
				</section>
			
			<?php endif; ?>
			
			<?php echo radium_theme_pagination(); ?>
			
			<?php wp_reset_query(); ?>
 			
		</div><!-- #post-box -->
		
		<?php 
		    //after content action hook 
		    do_action('radium_after_content'); 
		?>
	
	</div><!-- #main -->
	 
	<?php if( $radium_sidebar_location === 'left' || $radium_sidebar_location === 'right' ) { ?>
	 
		<aside id="sidebar" class="<?php echo $radium_sidebar_class; ?>">
			<div id="sidebar-main" class="sidebar">
				<?php get_sidebar('Internal Sidebar'); ?>
			</div><!--sidebar-main-->
		</aside>
	
	<?php } ?>
</div>
<?php get_footer(); ?>