<?php
 
/********************* META BOX DEFINITIONS ***********************/

$prefix = '_radium_';

global $meta_boxes, $pagenow;

/********************* META BOX REGISTERING ***********************/

$arg = array( 

	array(
		'name'     => __('Page Layout (Sidebars):', 'radium'),
		'id'       => $prefix . 'page_layout',
		'type'     => 'radio_image',
		'options'  => array(
			'none' => '<img src="' . $framework->theme_framework_images_url . '/1col.png" alt="' . __('Fullwidth - No sidebar', 'radium') . '" title="' . __('Fullwidth - No sidebar"', 'radium') . ' />',
			'left'  => '<img src="' . $framework->theme_framework_images_url . '/2cl.png" alt="' . __('Sidebar on the left', 'radium') . '" title="' . __('Sidebar on the left', 'radium') . '" />',
			'right'  => '<img src="' . $framework->theme_framework_images_url . '/2cr.png" alt="' . __('Sidebar on the right', 'radium') . '" title="' . __('Sidebar on the right', 'radium') . '" />'
		),
		'std'  => '',
		'desc' => __('', 'radium')
	) 
);

$meta_boxes[] = array(
	'id'       => 'general-settings',
	'title'    => __('General Settings', 'radium'),
	'pages'    => array('post'),
	'context'  => 'normal',
	'priority' => 'default',
	'fields' =>  apply_filters( 'radium_general_metaboxes', $arg )
);

/* ---------------------------------------------------------------------- */
 /*	Post Format: Audio
 /* ----------------------------------------------------------------------  */
 
 $meta_boxes[] = array(
 	'id' => 'radium-meta-box-audio',
 	'title' =>  __('Audio Settings', 'radium'),
 	'page' => 'post',
 	'context' => 'normal',
 	'priority' => 'high',
 	'fields' => array(
 		array( "name" => __('Audio File URL','radium'),
 				"desc" => __('The URL to the .mp3 audio file','radium'),
 				"id" => $prefix."audio_file",
 				"type" => "text",
 				"std" => ''
 		),
 		array( 
 	        "name" => __('Audio Poster Image', 'radium'),
 	        "desc" => __('If you would like a poster image for the audio', 'radium'),
 	        "id" => $prefix . "audio_poster",
 	        "type" => "text",
 	        "std" => ''
 	    )
 	),
 	
 	
 );
 
 /* ---------------------------------------------------------------------- */
 /*	Post Format: Video
 /* ----------------------------------------------------------------------  */
 
 $meta_boxes[] = array(
 	'id' => 'radium-meta-box-video',
 	'title' =>  __('Video Settings', 'radium'),
 	'page' => 'post',
 	'context' => 'normal',
 	'priority' => 'high',
 	'fields' => array(
 		array( "name" => __('Video Height','radium'),
 				"desc" => __('The video height (e.g. 338).','radium'),
 				"id" => $prefix."video_height",
 				"type" => "text",
 				"std" => ''
 		),
 		array( "name" => __('File URL','radium'),
 				"desc" => __('The URL to the .m4v video file','radium'),
 				"id" => $prefix."video_file",
 				"type" => "text",
 				"std" => ''
 		),

 		array( "name" => __('Poster Image','radium'),
 				"desc" => __('The preivew image.','radium'),
 				"id" => $prefix."video_poster",
 				"type" => "text",
 				"std" => ''
 		),
 		array( "name" => __('Embeded Code','radium'),
 				"desc" => __('If you\'re not using self hosted video then you can include embeded code here. Best viewed at 675px wide.','radium'),
 				"id" => $prefix."video_embed",
 				"type" => "textarea",
 				"std" => ''
 		),
 	)
 	
 );
 
/* ---------------------------------------------------------------------- */
/*	Post Format: Link
/* ---------------------------------------------------------------------- */

$meta_boxes[] = array(
	'id' => 'radium-meta-box-link',
	'title' =>  __('Link Settings', 'radium'),
	'page' => 'post',
	'context' => 'normal',
	'priority' => 'high',
	'fields' => array(
		array( "name" => __('The URL','radium'),
				"desc" => __('Insert the URL you wish to link to.','radium'),
				"id" => $prefix."link_url",
				"type" => "text",
				"std" => ''
			),
	),
	
);