<?php
/**
 * The default template for displaying link content
 */
?>

<section id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>>		
	
	<?php if ( 'post' == get_post_type() ) : do_action( 'radium_post_format_icon' ); ?>
	
		<header class="entry-header">
			<?php if ( is_sticky() ) : ?>

				<?php if( is_singular() ) { ?>
					
					<h2 class="entry-title"><span><?php the_title(); ?></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
				
				<?php } else { ?>
				    
					<h2 class="entry-title"><span><a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'radium' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a></span></h2>
					<h3 class="entry-format"><?php _e( 'Featured', 'radium' ); ?></h3>
								
				<?php } ?>
				
			<?php else : ?>

			<?php $link = get_post_meta($post->ID, '_radium_link_url', true); ?>
				
			<?php if( is_singular() ) { ?>
			    
			    <h2 class="entry-title"><a href="<?php echo $link; ?>"><span><?php the_title(); ?></span></h2></a>
			    
			<?php } else { ?>
			    
			    <h2 class="entry-title">
			        <a href="<?php echo $link; ?>">      
			            <?php the_title(); ?>
			        </a>
			    </h2>
			    
			<?php } ?>
			
			<p class="sub-title"><?php echo $link; ?></p>
				
				<?php endif; ?>
	
			<?php do_action( 'radium_post_meta' ); ?>
	
		</header><!-- .entry-header -->	
			
		<article class="entry-content">
			<?php the_content( __( '<span>Continue Reading &rarr;</span>', 'radium' ) ); ?>
			<?php wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'radium' ) . '</span>', 'after' => '</div>' ) ); ?>
		</article><!-- .entry-content -->
		
	<?php endif; ?>
		
</section><!-- #post-<?php the_ID(); ?> -->
