<?php

/**
 * Display headline.
 *
 * @since 2.1.0
 *
 * @param array $options all options for headline
 * @return string $output HTML output for headline
 */

if( ! function_exists( 'radium_builder_headline_element' ) ) {
	function radium_builder_headline_element( $id, $settings, $location ) {
		$output = '<div class="custom-headline">'; 
		$output .= '<h1 class="text-'.$settings['align'].' element-title">';
		$output .= stripslashes( $settings['text'] );
		$output .= '</h1>';
		if( $settings['subtitle'] ) {
			$output .= '<h3 class="text-'.$settings['align'].' element-subtitle">';
			$output .= stripslashes( $settings['subtitle'] );
			$output .= '</h3>';
		}
		$output .= '</div>';
		
		echo $output;
	}
}
add_action('radium_builder_headline', 'radium_builder_headline_element', 10, 3); 