<?php
/**
* Register Builder Elements Configuration Functions
* Add Elements Filter to allow customization 
* @return array
*/
function radium_builder_elements() {

	$elements = array();
	
	return apply_filters( 'radium_builder_elements', $elements );
}

/**
* Include Elements
* loaded on init in Radium_Builder class	
*/ 
function radium_builder_load_elements() {
 
	 include('elements/blog.php');
	 include('elements/carousel.php');
	 //include('elements/clients.php'); //code incomplete for now
	 include('elements/content.php');
	 include('elements/cta.php');
	 include('elements/divider.php');
	 include('elements/featured-area.php');
	 include('elements/headline.php');
	 include('elements/map.php');
	 include('elements/slider.php');
	 include('elements/slogan.php');
	 //include('elements/tabs.php');  //code incomplete for now
	 include('elements/widget-areas.php');
	 
}

/**
 * Register Builder Sample Layouts.
 * Add Sample Filter to allow customization 
 * @return array
 */
 
function radium_builder_samples() {
	
	$samples = array();
	
	return apply_filters( 'radium_sample_layouts', $samples );
}

/**
* Include Sample Layouts
* loaded on init in Radium_Builder class	
*/ 
function radium_builder_load_samples() {

	include('sample-layouts/blank.php'); //blank slate
	include('sample-layouts/avalon-home-1.php');
	include('sample-layouts/avalon-home-2.php');
	include('sample-layouts/avalon-home-3.php');
	include('sample-layouts/avalon-home-4.php');
	include('sample-layouts/avalon-home-5.php');
	include('sample-layouts/avalon-home-6.php');
	include('sample-layouts/avalon-home-7.php');
	include('sample-layouts/avalon-home-8.php');
	include('sample-layouts/avalon-home-9.php');
	include('sample-layouts/avalon-home-10.php');
	include('sample-layouts/portfolio.php');
	
}


/*
 * This is an example of how to add custom scripts to the options panel.
 * This example shows/hides an option when a checkbox is clicked.

add_action( 'admin_head', 'radium_builder_custom_scripts' );

function radium_builder_custom_scripts() { ?>

<script type="text/javascript">
jQuery(document).ready(function($) {

	$('#example_showhidden').click(function() {
  		$('#section-example_text_hidden').fadeToggle(400);
	});

	if ($('#example_showhidden:checked').val() !== undefined) {
		$('#section-example_text_hidden').show();
	}

});
</script>

<?php
}
 */