<?php
/**
 * Assets class for Radium_Galleries.
 *
 *
 * @since 1.0.0
 *
 * @package	Radium_PriceTables
 * @author	Franklin M Gitonga
 */
class Radium_Galleries_Assets { 
	
	/**
	 * Holds a copy of the object for easy reference.
	 *
	 * @since 1.0.0
	 *
	 * @var object
	 */
	private static $instance;
	
	/**
	 * Constructor. Hooks all interactions to initialize the class.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
	
		self::$instance = $this;
		
		/** Register scripts and styles */
		add_action('admin_enqueue_scripts', array( $this, 'admin_scripts'));
			
		add_action('wp_enqueue_scripts', 	array( $this, 'frontend_scripts'));
 	
	}
	
	public function frontend_scripts() {
		
		wp_enqueue_style('radium-gallery-styles',  plugins_url( 'assets/frontend/css/style.css', dirname(dirname(__FILE__)) ), array(), '1.0.0');
		//wp_enqueue_style('galleria-styles',  plugins_url( 'assets/frontend/css/style.css', dirname(dirname(__FILE__)) ), array(), '1.0.0');
		
		// http://www.no-margin-for-errors.com/projects/prettyphoto-jquery-lightbox-clone/#!prettyPhoto
		wp_enqueue_style('pretty_photo', plugins_url('assets/frontend/prettyphoto/css/prettyPhoto.css', dirname( dirname(__FILE__) ) ) );
		//wp_enqueue_style('gallery_core', plugins_url('css/gallery.all.css', dirname( dirname(__FILE__) ) ) );
		
 		wp_enqueue_style('gallery_plus', plugins_url('assets/frontend/galleria/themes/classic/galleria.classic.css',  dirname( dirname(__FILE__) ) ) );
 		
		wp_enqueue_script('prettyphoto', plugins_url('assets/frontend/prettyphoto/js/jquery.prettyPhoto.js', dirname( dirname(__FILE__) ) ), array('jquery'), '', true);
 		wp_enqueue_script('galleria', plugins_url('assets/frontend/galleria/galleria.min.js', dirname( dirname(__FILE__) ) ), array('jquery'), '', true);
 		wp_enqueue_script( 'galleria_theme', plugins_url('assets/frontend/galleria/themes/classic/galleria.classic.min.js', dirname( dirname(__FILE__) ) ), array('galleria'),'',true);
 		
		wp_enqueue_script('radium-galleries', plugins_url('assets/frontend/js/gallery.js', dirname( dirname(__FILE__) ) ), array('jquery'),'', true);
		
	}
	
	public function  admin_scripts() {
		
	}
	
}